/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.cos;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.sejda.io.FastByteArrayOutputStream;
import org.sejda.io.SeekableSource;
import org.sejda.io.SeekableSourceSupplier;
import org.sejda.io.SeekableSources;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSString;
import org.sejda.sambox.cos.COSVisitor;
import org.sejda.sambox.cos.Encryptable;
import org.sejda.sambox.filter.DecodeResult;
import org.sejda.sambox.filter.Filter;
import org.sejda.sambox.filter.FilterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class COSStream
extends COSDictionary
implements Closeable,
Encryptable {
    private static final List<COSName> CAN_COMPRESS = Arrays.asList(COSName.ASCII_HEX_DECODE, COSName.ASCII_HEX_DECODE_ABBREVIATION, COSName.ASCII85_DECODE, COSName.ASCII85_DECODE_ABBREVIATION);
    private static final Logger LOG = LoggerFactory.getLogger(COSStream.class);
    private LazySeekableSourceViewHolder existing;
    private byte[] filtered;
    private byte[] unfiltered;
    private DecodeResult decodeResult;
    private Function<InputStream, InputStream> encryptor;
    private boolean encryptable = true;
    private boolean indirectLength = false;

    public COSStream() {
    }

    public COSStream(COSDictionary dictionary) {
        super(dictionary);
    }

    public COSStream(COSDictionary dictionary, SeekableSource seekableSource, long startingPosition, long length) {
        super(dictionary);
        this.existing = new LazySeekableSourceViewHolder(seekableSource, startingPosition, length);
    }

    public final InputStream getFilteredStream() throws IOException {
        if (Objects.nonNull(this.encryptor)) {
            return this.encryptor.apply(this.doGetFilteredStream());
        }
        return this.doGetFilteredStream();
    }

    protected InputStream doGetFilteredStream() throws IOException {
        if (Objects.nonNull(this.existing)) {
            return this.existing.get().asInputStream();
        }
        this.encodeIfRequired();
        if (Objects.nonNull(this.filtered)) {
            return new MyByteArrayInputStream(this.filtered);
        }
        return new MyByteArrayInputStream(this.unfiltered);
    }

    public SeekableSource getFilteredSource() throws IOException {
        if (this.existing != null) {
            return this.existing.get();
        }
        return SeekableSources.inMemorySeekableSourceFrom((InputStream)this.getFilteredStream());
    }

    public long getFilteredLength() throws IOException {
        if (this.existing != null) {
            return this.existing.length;
        }
        this.encodeIfRequired();
        if (Objects.nonNull(this.filtered)) {
            return this.filtered.length;
        }
        return Optional.ofNullable(this.unfiltered).map(f -> ((byte[])f).length).orElse(0).intValue();
    }

    private void encodeIfRequired() throws IOException {
        if (this.getFilters() != null && this.filtered == null && this.unfiltered != null) {
            this.doEncode();
        }
    }

    public InputStream getUnfilteredStream() throws IOException {
        this.decodeIfRequired();
        if (this.unfiltered != null) {
            return new MyByteArrayInputStream(this.unfiltered);
        }
        return this.getStreamToDecode();
    }

    public SeekableSource getUnfilteredSource() throws IOException {
        this.decodeIfRequired();
        if (this.unfiltered != null) {
            return SeekableSources.inMemorySeekableSourceFrom((byte[])this.unfiltered);
        }
        if (this.existing != null) {
            return this.existing.get();
        }
        return SeekableSources.inMemorySeekableSourceFrom((byte[])this.filtered);
    }

    public ByteBuffer getUnfilteredByteBuffer() throws IOException {
        this.decodeIfRequired();
        if (this.unfiltered != null) {
            return ByteBuffer.wrap(this.unfiltered).asReadOnlyBuffer();
        }
        if (this.existing != null) {
            return ByteBuffer.wrap(org.sejda.util.IOUtils.toByteArray((InputStream)this.existing.get().asInputStream()));
        }
        return ByteBuffer.wrap(this.filtered).asReadOnlyBuffer();
    }

    public long getUnfilteredLength() throws IOException {
        this.decodeIfRequired();
        if (Objects.nonNull(this.unfiltered)) {
            return this.unfiltered.length;
        }
        if (Objects.nonNull(this.existing)) {
            return this.existing.length;
        }
        return Optional.ofNullable(this.filtered).map(f -> ((byte[])f).length).orElse(0).intValue();
    }

    private void decodeIfRequired() throws IOException {
        if (Objects.nonNull(this.getFilters()) && Objects.isNull(this.unfiltered)) {
            this.doDecode();
        }
    }

    public DecodeResult getDecodeResult() throws IOException {
        this.decodeIfRequired();
        return Optional.ofNullable(this.decodeResult).orElse(DecodeResult.DEFAULT);
    }

    @Override
    public void accept(COSVisitor visitor) throws IOException {
        visitor.visit(this);
    }

    private void doDecode() throws IOException {
        COSBase filters = this.getFilters();
        if (Objects.nonNull(filters)) {
            if (filters instanceof COSName) {
                this.unfiltered = this.decode((COSName)filters, 0, this.getStreamToDecode());
            } else if (filters instanceof COSArray) {
                this.unfiltered = this.decodeChain((COSArray)filters, this.getStreamToDecode());
            } else {
                throw new IOException("Unknown filter type:" + filters);
            }
        }
    }

    private InputStream getStreamToDecode() throws IOException {
        if (this.existing != null) {
            return this.existing.get().asInputStream();
        }
        return new MyByteArrayInputStream(this.filtered);
    }

    private byte[] decodeChain(COSArray filters, InputStream startingFrom) throws IOException {
        if (filters.size() > 0) {
            byte[] tmpResult = new byte[]{};
            InputStream input = startingFrom;
            for (int i = 0; i < filters.size(); ++i) {
                COSName filterName = (COSName)filters.getObject(i);
                tmpResult = this.decode(filterName, i, input);
                input = new MyByteArrayInputStream(tmpResult);
            }
            return tmpResult;
        }
        return null;
    }

    private byte[] decode(COSName filterName, int filterIndex, InputStream toDecode) throws IOException {
        if (toDecode.available() > 0) {
            Filter filter = FilterFactory.INSTANCE.getFilter(filterName);
            try (MyByteArrayOutputStream out = new MyByteArrayOutputStream();){
                this.decodeResult = filter.decode(toDecode, (OutputStream)((Object)out), this, filterIndex);
                byte[] byArray = out.toByteArray();
                return byArray;
            }
        }
        return new byte[0];
    }

    private void doEncode() throws IOException {
        COSBase filters = this.getFilters();
        if (filters instanceof COSName) {
            this.filtered = this.encode((COSName)filters, new MyByteArrayInputStream(this.unfiltered));
        } else if (filters instanceof COSArray) {
            this.filtered = this.encodeChain((COSArray)filters, new MyByteArrayInputStream(this.unfiltered));
        }
    }

    private byte[] encode(COSName filterName, InputStream toEncode) throws IOException {
        Filter filter = FilterFactory.INSTANCE.getFilter(filterName);
        try (MyByteArrayOutputStream encoded = new MyByteArrayOutputStream();){
            filter.encode(toEncode, (OutputStream)((Object)encoded), this);
            byte[] byArray = encoded.toByteArray();
            return byArray;
        }
    }

    private byte[] encodeChain(COSArray filters, InputStream startingFrom) throws IOException {
        if (filters.size() > 0) {
            byte[] tmpResult = new byte[]{};
            InputStream input = startingFrom;
            for (int i = filters.size() - 1; i >= 0; --i) {
                COSName filterName = (COSName)filters.getObject(i);
                tmpResult = this.encode(filterName, input);
                input = new MyByteArrayInputStream(tmpResult);
            }
            return tmpResult;
        }
        return null;
    }

    public COSBase getFilters() {
        return this.getDictionaryObject(COSName.FILTER);
    }

    public boolean hasFilter(COSName filter) {
        COSBase filters = this.getFilters();
        if (filters instanceof COSName) {
            return filters.equals(filter);
        }
        if (filters instanceof COSArray) {
            return ((COSArray)filters).contains(filter);
        }
        return false;
    }

    public void setEncryptor(Function<InputStream, InputStream> encryptor) {
        this.encryptor = encryptor;
    }

    public OutputStream createFilteredStream() {
        org.sejda.util.IOUtils.closeQuietly((Closeable)this.existing);
        this.unfiltered = null;
        this.existing = null;
        this.filtered = null;
        return new MyByteArrayOutputStream(bytes -> {
            this.filtered = bytes;
        });
    }

    public OutputStream createFilteredStream(COSBase filters) {
        if (filters != null) {
            this.setItem(COSName.FILTER, filters);
        }
        return this.createUnfilteredStream();
    }

    public void setFilters(COSBase filters) throws IOException {
        if (this.unfiltered == null) {
            try (InputStream in = this.getUnfilteredStream();
                 MyByteArrayOutputStream out = new MyByteArrayOutputStream(bytes -> {
                this.unfiltered = bytes;
            });){
                IOUtils.copy((InputStream)in, (OutputStream)((Object)out));
            }
        }
        this.setItem(COSName.FILTER, filters);
        org.sejda.util.IOUtils.closeQuietly((Closeable)this.existing);
        this.existing = null;
        this.filtered = null;
    }

    public void addCompression() throws IOException {
        if (this.canCompress()) {
            COSArray newFilters = new COSArray(COSName.FLATE_DECODE);
            COSBase filters = this.getFilters();
            if (filters instanceof COSName) {
                newFilters.add(filters);
                this.setFilters(newFilters);
            } else if (filters instanceof COSArray) {
                newFilters.addAll((COSArray)filters);
                this.setFilters(newFilters);
            } else {
                this.setFilters(COSName.FLATE_DECODE);
            }
        }
    }

    private boolean canCompress() {
        if (this.getDictionaryObject(COSName.DECODE_PARMS, COSName.DP) != null) {
            return false;
        }
        COSBase filters = this.getFilters();
        if (filters instanceof COSName) {
            return CAN_COMPRESS.contains(filters);
        }
        if (filters instanceof COSArray) {
            return ((COSArray)filters).stream().allMatch(CAN_COMPRESS::contains);
        }
        return true;
    }

    @Override
    public boolean encryptable() {
        return this.encryptable;
    }

    @Override
    public void encryptable(boolean encryptable) {
        this.encryptable = encryptable;
    }

    public OutputStream createUnfilteredStream() {
        this.filtered = null;
        org.sejda.util.IOUtils.closeQuietly((Closeable)this.existing);
        this.existing = null;
        this.unfiltered = null;
        return new MyByteArrayOutputStream(bytes -> {
            this.unfiltered = bytes;
        });
    }

    public boolean isEmpty() throws IOException {
        if (Objects.nonNull(this.existing)) {
            return this.existing.get().size() <= 0L;
        }
        return Optional.ofNullable(this.filtered).map(f -> ((byte[])f).length <= 0).orElseGet(() -> Optional.ofNullable(this.unfiltered).map(u -> ((byte[])u).length <= 0).orElse(true));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String asTextString() {
        try (FastByteArrayOutputStream out = new FastByteArrayOutputStream();){
            IOUtils.copy((InputStream)this.getUnfilteredStream(), (OutputStream)out);
            String string = COSString.newInstance(out.toByteArray()).getString();
            return string;
        }
        catch (IOException e) {
            LOG.warn("Unable to convert the COSStream to a text string", (Throwable)e);
            return "";
        }
    }

    @Override
    public void close() throws IOException {
        org.sejda.util.IOUtils.closeQuietly((Closeable)this.existing);
        this.existing = null;
        this.unfiltered = null;
        this.filtered = null;
    }

    public void unDecode() {
        if (Objects.nonNull(this.existing)) {
            this.unfiltered = null;
            this.filtered = null;
        }
        if (Objects.nonNull(this.filtered)) {
            this.unfiltered = null;
        }
    }

    public boolean indirectLength() {
        return this.indirectLength;
    }

    public void indirectLength(boolean indirectLength) {
        this.indirectLength = indirectLength;
    }

    private static class LazySeekableSourceViewHolder
    implements Closeable {
        private WeakReference<SeekableSource> sourceRef;
        private long length;
        private SeekableSourceSupplier<SeekableSource> supplier = () -> Optional.ofNullable(this.sourceRef.get()).filter(Channel::isOpen).orElseThrow(() -> new IllegalStateException("The original SeekableSource has been closed")).view(startingPosition, length);
        private SeekableSource view;

        public LazySeekableSourceViewHolder(SeekableSource source, long startingPosition, long length) {
            this.sourceRef = new WeakReference<SeekableSource>(source);
            this.length = length;
        }

        SeekableSource get() throws IOException {
            if (this.view == null) {
                this.view = this.supplier.get();
            }
            this.view.position(0L);
            return this.view;
        }

        @Override
        public void close() throws IOException {
            org.sejda.util.IOUtils.close((Closeable)this.view);
            this.view = null;
        }
    }

    static class MyByteArrayInputStream
    extends ByteArrayInputStream {
        MyByteArrayInputStream(byte[] bytes) {
            super(Optional.ofNullable(bytes).orElse(new byte[0]));
        }
    }

    static class MyByteArrayOutputStream
    extends FastByteArrayOutputStream {
        private Optional<Consumer<byte[]>> onClose;

        MyByteArrayOutputStream() {
            this(null);
        }

        MyByteArrayOutputStream(Consumer<byte[]> onClose) {
            this.onClose = Optional.ofNullable(onClose);
        }

        public void close() {
            super.close();
            this.onClose.ifPresent(c -> c.accept(this.toByteArray()));
        }
    }
}

