/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.input;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.sejda.io.FastByteArrayOutputStream;
import org.sejda.io.SeekableSource;
import org.sejda.sambox.cos.COSObjectKey;
import org.sejda.sambox.util.CharUtils;
import org.sejda.sambox.util.Pool;
import org.sejda.util.IOUtils;
import org.sejda.util.RequireUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SourceReader
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(SourceReader.class);
    private static final long OBJECT_NUMBER_THRESHOLD = 10000000000L;
    private static final int GENERATION_NUMBER_THRESHOLD = 65535;
    public static final String OBJ = "obj";
    private Pool<StringBuilder> pool = new Pool<StringBuilder>(StringBuilder::new, Integer.getInteger("org.sejda.sambox.buffers.pool.size", 10)).onGive(b -> {
        b.setLength(0);
        b.trimToSize();
    });
    private SeekableSource source;

    public SourceReader(SeekableSource source) {
        RequireUtils.requireNotNullArg((Object)source, (String)"Cannot read a null source");
        this.source = source;
    }

    public SeekableSource source() {
        return this.source;
    }

    public long position() throws IOException {
        return this.source.position();
    }

    public void position(long offset) throws IOException {
        this.source.position(offset);
    }

    public long length() {
        return this.source.size();
    }

    public final void skipExpected(String expected) throws IOException {
        for (char c : expected.toCharArray()) {
            this.skipExpected(c);
        }
    }

    public void skipExpected(char ec) throws IOException {
        char c = (char)this.source.read();
        if (c != ec) {
            throw new IOException("expected='" + ec + "' actual='" + c + "' at offset " + (this.position() - 1L));
        }
    }

    public boolean skipTokenIfValue(String ... values) throws IOException {
        long pos = this.position();
        String token = this.readToken();
        if (!Arrays.asList(values).contains(token)) {
            this.source.position(pos);
            return false;
        }
        return true;
    }

    public void skipIndirectObjectDefinition() throws IOException {
        this.readObjectNumber();
        this.readGenerationNumber();
        this.skipSpaces();
        this.skipExpected(OBJ);
    }

    public void skipExpectedIndirectObjectDefinition(COSObjectKey expected) throws IOException {
        long objNumOffset = this.position();
        long number = this.readObjectNumber();
        if (number != expected.objectNumber()) {
            throw new IOException(String.format("Expected '%d' object number at offset %d but was '%d'", expected.objectNumber(), objNumOffset, number));
        }
        long genNumOffset = this.position();
        long generation = this.readGenerationNumber();
        if (generation != (long)expected.generation()) {
            throw new IOException(String.format("Expected '%d' generation number at offset %d but was '%d'", expected.generation(), genNumOffset, number));
        }
        this.skipSpaces();
        this.skipExpected(OBJ);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readToken() throws IOException {
        this.skipSpaces();
        StringBuilder builder = this.pool.borrow();
        try {
            int c;
            while ((c = this.source.read()) != -1 && !CharUtils.isEndOfName(c)) {
                builder.append((char)c);
            }
            this.unreadIfValid(c);
            String string = builder.toString();
            return string;
        }
        finally {
            this.pool.give(builder);
        }
    }

    public void unreadSpaces() throws IOException {
        int c;
        while ((c = this.source.peekBack()) != -1 && CharUtils.isWhitespace(c)) {
            this.source.back();
        }
    }

    public void unreadUntilSpaces() throws IOException {
        int c;
        while ((c = this.source.peekBack()) != -1 && !CharUtils.isWhitespace(c)) {
            this.source.back();
        }
    }

    public boolean isNextToken(String ... values) throws IOException {
        long pos = this.position();
        String token = this.readToken();
        this.position(pos);
        return Arrays.asList(values).contains(token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readLine() throws IOException {
        RequireUtils.requireIOCondition((this.source.peek() != -1 ? 1 : 0) != 0, (String)"Expected line but was end of file");
        StringBuilder builder = this.pool.borrow();
        try {
            int c;
            while ((c = this.source.read()) != -1 && !CharUtils.isEOL(c)) {
                builder.append((char)c);
            }
            if (CharUtils.isCarriageReturn(c) && CharUtils.isLineFeed(this.source.peek())) {
                this.source.read();
            }
            String string = builder.toString();
            return string;
        }
        finally {
            this.pool.give(builder);
        }
    }

    public long readObjectNumber() throws IOException {
        long retval = this.readLong();
        if (retval < 0L || retval >= 10000000000L) {
            throw new IOException("Object Number '" + retval + "' has more than 10 digits or is negative");
        }
        return retval;
    }

    public int readGenerationNumber() throws IOException {
        int retval = this.readInt();
        if (retval < 0 || retval > 65535) {
            throw new IOException("Generation Number '" + retval + "' has more than 5 digits");
        }
        return retval;
    }

    public String readName() throws IOException {
        int i;
        this.skipExpected('/');
        FastByteArrayOutputStream buffer = new FastByteArrayOutputStream();
        while ((i = this.source.read()) != -1 && !CharUtils.isEndOfName(i)) {
            if (i == 35) {
                int ch1 = this.source.read();
                int ch2 = this.source.read();
                RequireUtils.requireIOCondition((ch2 != -1 && ch1 != -1 ? 1 : 0) != 0, (String)"Expected 2-digit hexadecimal code but was end of file");
                if (CharUtils.isHexDigit((char)ch1) && CharUtils.isHexDigit((char)ch2)) {
                    String hex = "" + (char)ch1 + (char)ch2;
                    i = Integer.parseInt(hex, 16);
                } else {
                    this.source.back(2L);
                    LOG.warn("Found NUMBER SIGN (#) not used as escaping char while reading name at " + this.position());
                }
            }
            buffer.write(i);
        }
        this.unreadIfValid(i);
        byte[] bytes = buffer.toByteArray();
        try {
            StandardCharsets.UTF_8.newDecoder().decode(ByteBuffer.wrap(bytes));
        }
        catch (CharacterCodingException e) {
            return new String(bytes, Charset.forName("Windows-1252"));
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public int readInt() throws IOException {
        String intBuffer = this.readIntegerNumber();
        try {
            return Integer.parseInt(intBuffer);
        }
        catch (NumberFormatException e) {
            this.source.back((long)intBuffer.getBytes(StandardCharsets.ISO_8859_1).length);
            throw new IOException(String.format("Expected an integer type at offset %d but was '%s'", this.position(), intBuffer), e);
        }
    }

    public long readLong() throws IOException {
        String longBuffer = this.readIntegerNumber();
        try {
            return Long.parseLong(longBuffer);
        }
        catch (NumberFormatException e) {
            this.source.back((long)longBuffer.getBytes(StandardCharsets.ISO_8859_1).length);
            throw new IOException(String.format("Expected a long type at offset %d but was '%s'", this.position(), longBuffer), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String readIntegerNumber() throws IOException {
        this.skipSpaces();
        StringBuilder builder = this.pool.borrow();
        try {
            int c = this.source.read();
            if (c != -1 && (CharUtils.isDigit(c) || c == 43 || c == 45)) {
                builder.append((char)c);
                while ((c = this.source.read()) != -1 && CharUtils.isDigit(c)) {
                    builder.append((char)c);
                }
            }
            this.unreadIfValid(c);
            String string = builder.toString();
            return string;
        }
        finally {
            this.pool.give(builder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String readNumber() throws IOException {
        StringBuilder builder = this.pool.borrow();
        try {
            int c = this.source.read();
            if (c != -1 && (CharUtils.isDigit(c) || c == 43 || c == 45 || c == 46)) {
                builder.append((char)c);
                while ((c = this.source.read()) != -1 && (CharUtils.isDigit(c) || c == 46 || c == 69 || c == 101 || c == 43 || c == 45)) {
                    builder.append((char)c);
                }
            }
            this.unreadIfValid(c);
            String string = builder.toString();
            return string;
        }
        finally {
            this.pool.give(builder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String readHexString() throws IOException {
        this.skipExpected('<');
        StringBuilder builder = this.pool.borrow();
        try {
            int c;
            while ((c = this.source.read()) != -1 && c != 62) {
                if (CharUtils.isHexDigit(c)) {
                    builder.append((char)c);
                    continue;
                }
                if (CharUtils.isWhitespace(c)) continue;
                LOG.warn(String.format("Expected an hexadecimal char at offset %d but was '%c'. Replaced with default 0.", this.position() - 1L, c));
                builder.append('0');
            }
            RequireUtils.requireIOCondition((c != -1 ? 1 : 0) != 0, (String)"Unexpected EOF. Missing closing bracket for hexadecimal string.");
            String string = builder.toString();
            return string;
        }
        finally {
            this.pool.give(builder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String readLiteralString() throws IOException {
        this.skipExpected('(');
        bracesCounter = 1;
        builder = this.pool.borrow();
lbl4:
        // 13 sources

        try {
            block23: while ((i = this.source.read()) != -1 && bracesCounter > 0) {
                c = (char)i;
                switch (c) {
                    case '(': {
                        ++bracesCounter;
                        builder.append(c);
                        ** GOTO lbl4
                    }
                    case ')': {
                        if (--bracesCounter <= 0) continue block23;
                        builder.append(c);
                        ** GOTO lbl4
                    }
                    case '\\': {
                        next = (char)this.source.read();
                        switch (next) {
                            case 'n': {
                                builder.append('\n');
                                ** GOTO lbl4
                            }
                            case 'r': {
                                builder.append('\r');
                                ** GOTO lbl4
                            }
                            case 't': {
                                builder.append('\t');
                                ** GOTO lbl4
                            }
                            case 'b': {
                                builder.append('\b');
                                ** GOTO lbl4
                            }
                            case 'f': {
                                builder.append('\f');
                                ** GOTO lbl4
                            }
                            case '(': 
                            case ')': 
                            case '\\': {
                                builder.append(next);
                                ** GOTO lbl4
                            }
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': {
                                octal = this.pool.borrow();
                                try {
                                    octal.append(next);
                                    next = (char)this.source.read();
                                    if (!CharUtils.isOctalDigit(next)) ** GOTO lbl61
                                    octal.append(next);
                                    next = (char)this.source.read();
                                    if (CharUtils.isOctalDigit(next)) {
                                        octal.append(next);
                                    } else {
                                        this.unreadIfValid(next);
                                    }
                                    ** GOTO lbl62
lbl61:
                                    // 1 sources

                                    this.unreadIfValid(next);
lbl62:
                                    // 3 sources

                                    builder.append((char)Integer.parseInt(octal.toString(), 8));
                                    continue block23;
                                }
                                finally {
                                    this.pool.give(octal);
                                    continue block23;
                                }
                            }
                            case '\n': 
                            case '\r': {
                                while ((c = (char)this.source.read()) != '\uffffffff' && CharUtils.isEOL(c)) {
                                }
                                this.unreadIfValid(c);
                                ** GOTO lbl4
                            }
                        }
                        this.unreadIfValid(c);
                        ** GOTO lbl4
                    }
                    case '\n': {
                        builder.append('\n');
                        ** GOTO lbl4
                    }
                    case '\r': {
                        builder.append('\n');
                        if (CharUtils.isLineFeed(this.source.read())) continue block23;
                        this.unreadIfValid(c);
                        ** GOTO lbl4
                    }
                }
                builder.append(c);
            }
            this.unreadIfValid(i);
            var4_5 = builder.toString();
            return var4_5;
        }
        finally {
            this.pool.give(builder);
        }
    }

    public void skipSpaces() throws IOException {
        int c = this.source.read();
        while (CharUtils.isWhitespace(c) || c == 37) {
            if (c == 37) {
                while ((c = this.source.read()) != -1 && !CharUtils.isEOL(c)) {
                }
                continue;
            }
            c = this.source.read();
        }
        this.unreadIfValid(c);
    }

    public void unreadIfValid(int c) throws IOException {
        if (c != -1) {
            this.source.back();
        }
    }

    @Override
    public void close() throws IOException {
        IOUtils.close((Closeable)this.source);
    }
}

