/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.output;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Queue;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSDocument;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSNull;
import org.sejda.sambox.cos.COSStream;
import org.sejda.sambox.cos.COSVisitor;
import org.sejda.sambox.cos.IndirectCOSObjectReference;
import org.sejda.sambox.input.ExistingIndirectCOSObject;
import org.sejda.sambox.input.IncrementablePDDocument;
import org.sejda.sambox.output.PDFBodyObjectsWriter;
import org.sejda.sambox.output.PDFWriteContext;
import org.sejda.sambox.output.WriteOption;
import org.sejda.util.RequireUtils;

class PDFBodyWriter
implements COSVisitor,
Closeable {
    private Queue<IndirectCOSObjectReference> stack = new LinkedList<IndirectCOSObjectReference>();
    private PDFWriteContext context;
    private boolean open = true;
    PDFBodyObjectsWriter objectsWriter;

    PDFBodyWriter(PDFWriteContext context, PDFBodyObjectsWriter objectsWriter) {
        RequireUtils.requireNotNullArg((Object)context, (String)"Write context cannot be null");
        RequireUtils.requireNotNullArg((Object)objectsWriter, (String)"Objects writer cannot be null");
        this.context = context;
        this.objectsWriter = objectsWriter;
    }

    PDFWriteContext context() {
        return this.context;
    }

    public void write(IncrementablePDDocument document) throws IOException {
        RequireUtils.requireState((boolean)this.open, (String)"The writer is closed");
        document.newIndirects().forEach(o -> this.stack.add(this.context.getOrCreateIndirectReferenceFor((COSBase)o)));
        document.trailer().getCOSObject().accept(this);
        document.replacements().forEach(this.stack::add);
        this.startWriting();
    }

    public void write(COSDocument document) throws IOException {
        RequireUtils.requireState((boolean)this.open, (String)"The writer is closed");
        document.accept(this);
    }

    @Override
    public void visit(COSDocument document) throws IOException {
        for (COSName k : Arrays.asList(COSName.ROOT, COSName.ENCRYPT)) {
            Optional.ofNullable(document.getTrailer().getCOSObject().getItem(k)).ifPresent(r -> this.stack.add(this.context.createNonStorableInObjectStreamIndirectReferenceFor((COSBase)r)));
        }
        Optional.ofNullable(document.getTrailer().getCOSObject().getItem(COSName.INFO)).ifPresent(this::createIndirectReferenceIfNeededFor);
        this.startWriting();
    }

    void startWriting() throws IOException {
        while (!this.stack.isEmpty()) {
            IndirectCOSObjectReference item = this.stack.poll();
            item.getCOSObject().accept(this);
            this.objectsWriter.writeObject(item);
        }
        this.objectsWriter.onWriteCompletion();
    }

    @Override
    public void visit(COSArray array) throws IOException {
        for (int i = 0; i < array.size(); ++i) {
            COSBase item = Optional.ofNullable(array.get(i)).orElse(COSNull.NULL);
            if (item instanceof ExistingIndirectCOSObject || item instanceof COSDictionary) {
                this.onPotentialIndirectObject(item);
                continue;
            }
            item.accept(this);
        }
    }

    @Override
    public void visit(COSDictionary value) throws IOException {
        for (COSName key : value.keySet()) {
            COSBase item = Optional.ofNullable(value.getItem(key)).orElse(COSNull.NULL);
            if (item instanceof ExistingIndirectCOSObject || item instanceof COSDictionary || COSName.THREADS.equals(key)) {
                this.onPotentialIndirectObject(item);
                continue;
            }
            item.accept(this);
        }
    }

    @Override
    public void visit(COSStream value) throws IOException {
        value.removeItem(COSName.LENGTH);
        if (this.context.hasWriteOption(WriteOption.COMPRESS_STREAMS)) {
            value.addCompression();
        }
        value.indirectLength(this.context.encryptor.isPresent());
        if (value.indirectLength()) {
            IndirectCOSObjectReference length = this.context.createNonStorableInObjectStreamIndirectReference();
            value.setItem(COSName.LENGTH, (COSBase)length);
            this.stack.add(length);
        }
        this.visit((COSDictionary)value);
    }

    public void onPotentialIndirectObject(COSBase item) throws IOException {
        this.createIndirectReferenceIfNeededFor(item);
    }

    final void createIndirectReferenceIfNeededFor(COSBase item) {
        if (!this.context.hasIndirectReferenceFor(item)) {
            this.stack.add(this.context.getOrCreateIndirectReferenceFor(item));
        }
    }

    @Override
    public void close() throws IOException {
        this.objectsWriter.close();
        this.context = null;
        this.open = false;
    }
}

