/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.graphics.image;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.stream.ImageInputStreamImpl;
import javax.imageio.stream.ImageOutputStreamImpl;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.sejda.io.FastByteArrayOutputStream;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSObjectable;
import org.sejda.sambox.filter.Filter;
import org.sejda.sambox.filter.FilterFactory;
import org.sejda.sambox.pdmodel.graphics.color.PDColorSpace;
import org.sejda.sambox.pdmodel.graphics.color.PDDeviceColorSpace;
import org.sejda.sambox.pdmodel.graphics.color.PDDeviceGray;
import org.sejda.sambox.pdmodel.graphics.color.PDDeviceRGB;
import org.sejda.sambox.pdmodel.graphics.image.PDImageXObject;

public final class LosslessFactory {
    private LosslessFactory() {
    }

    public static PDImageXObject createFromImage(BufferedImage image) throws IOException {
        byte[] imageData;
        PDDeviceColorSpace deviceColorSpace;
        int bpc;
        int height = image.getHeight();
        int width = image.getWidth();
        int[] rgbLineBuffer = new int[width];
        if (image.getType() == 10 && image.getColorModel().getPixelSize() <= 8 || image.getType() == 12 && image.getColorModel().getPixelSize() == 1) {
            bpc = image.getColorModel().getPixelSize();
            deviceColorSpace = PDDeviceGray.INSTANCE;
            FastByteArrayOutputStream bos = new FastByteArrayOutputStream(width * bpc / 8 + (width * bpc % 8 != 0 ? 1 : 0) * height);
            try (MemoryCacheImageOutputStream mcios = new MemoryCacheImageOutputStream((OutputStream)bos);){
                for (int y = 0; y < height; ++y) {
                    for (int pixel : image.getRGB(0, y, width, 1, rgbLineBuffer, 0, width)) {
                        mcios.writeBits(pixel & 0xFF, bpc);
                    }
                    int bitOffset = mcios.getBitOffset();
                    if (bitOffset == 0) continue;
                    mcios.writeBits(0L, 8 - bitOffset);
                }
                mcios.flush();
            }
            imageData = bos.toByteArray();
        } else {
            bpc = 8;
            deviceColorSpace = PDDeviceRGB.INSTANCE;
            imageData = new byte[width * height * 3];
            int byteIdx = 0;
            for (int y = 0; y < height; ++y) {
                for (int pixel : image.getRGB(0, y, width, 1, rgbLineBuffer, 0, width)) {
                    imageData[byteIdx++] = (byte)(pixel >> 16 & 0xFF);
                    imageData[byteIdx++] = (byte)(pixel >> 8 & 0xFF);
                    imageData[byteIdx++] = (byte)(pixel & 0xFF);
                }
            }
        }
        PDImageXObject pdImage = LosslessFactory.prepareImageXObject(imageData, image.getWidth(), image.getHeight(), bpc, deviceColorSpace);
        PDImageXObject xAlpha = LosslessFactory.createAlphaFromARGBImage(image);
        if (xAlpha != null) {
            pdImage.getCOSObject().setItem(COSName.SMASK, (COSObjectable)xAlpha);
        }
        return pdImage;
    }

    private static PDImageXObject createAlphaFromARGBImage(BufferedImage image) throws IOException {
        int bpc;
        if (!image.getColorModel().hasAlpha()) {
            return null;
        }
        WritableRaster alphaRaster = image.getAlphaRaster();
        if (alphaRaster == null) {
            return LosslessFactory.createAlphaFromARGBImage2(image);
        }
        int[] pixels = alphaRaster.getPixels(0, 0, alphaRaster.getWidth(), alphaRaster.getHeight(), (int[])null);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        if (image.getTransparency() == 2) {
            bpc = 1;
            Object mcios = new MemoryCacheImageOutputStream(bos);
            int width = alphaRaster.getWidth();
            int p = 0;
            for (int pixel : pixels) {
                ((ImageOutputStreamImpl)mcios).writeBit(pixel);
                if (++p % width != 0) continue;
                while (((ImageInputStreamImpl)mcios).getBitOffset() != 0) {
                    ((ImageOutputStreamImpl)mcios).writeBit(0);
                }
            }
            ((ImageInputStreamImpl)mcios).flush();
            ((MemoryCacheImageOutputStream)mcios).close();
        } else {
            bpc = 8;
            for (int pixel : pixels) {
                bos.write(pixel);
            }
        }
        PDImageXObject pdImage = LosslessFactory.prepareImageXObject(bos.toByteArray(), image.getWidth(), image.getHeight(), bpc, PDDeviceGray.INSTANCE);
        return pdImage;
    }

    private static PDImageXObject createAlphaFromARGBImage2(BufferedImage bi) throws IOException {
        int bpc;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        if (bi.getTransparency() == 2) {
            bpc = 1;
            MemoryCacheImageOutputStream mcios = new MemoryCacheImageOutputStream(bos);
            int h = bi.getHeight();
            for (int y = 0; y < h; ++y) {
                int w = bi.getWidth();
                for (int x = 0; x < w; ++x) {
                    int alpha = bi.getRGB(x, y) >>> 24;
                    mcios.writeBit(alpha);
                }
                while (mcios.getBitOffset() != 0) {
                    mcios.writeBit(0);
                }
            }
            mcios.flush();
            mcios.close();
        } else {
            bpc = 8;
            int h = bi.getHeight();
            for (int y = 0; y < h; ++y) {
                int w = bi.getWidth();
                for (int x = 0; x < w; ++x) {
                    int alpha = bi.getRGB(x, y) >>> 24;
                    bos.write(alpha);
                }
            }
        }
        PDImageXObject pdImage = LosslessFactory.prepareImageXObject(bos.toByteArray(), bi.getWidth(), bi.getHeight(), bpc, PDDeviceGray.INSTANCE);
        return pdImage;
    }

    private static PDImageXObject prepareImageXObject(byte[] byteArray, int width, int height, int bitsPerComponent, PDColorSpace initColorSpace) throws IOException {
        FastByteArrayOutputStream baos = new FastByteArrayOutputStream();
        Filter filter = FilterFactory.INSTANCE.getFilter(COSName.FLATE_DECODE);
        filter.encode(new ByteArrayInputStream(byteArray), (OutputStream)baos, new COSDictionary());
        ByteArrayInputStream encodedByteStream = new ByteArrayInputStream(baos.toByteArray());
        return new PDImageXObject(encodedByteStream, COSName.FLATE_DECODE, width, height, bitsPerComponent, initColorSpace);
    }
}

