/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.graphics.image;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSObjectable;
import org.sejda.sambox.cos.COSStream;
import org.sejda.sambox.pdmodel.PDResources;
import org.sejda.sambox.pdmodel.common.PDMetadata;
import org.sejda.sambox.pdmodel.common.PDStream;
import org.sejda.sambox.pdmodel.graphics.PDXObject;
import org.sejda.sambox.pdmodel.graphics.color.PDColorSpace;
import org.sejda.sambox.pdmodel.graphics.color.PDDeviceGray;
import org.sejda.sambox.pdmodel.graphics.image.CCITTFactory;
import org.sejda.sambox.pdmodel.graphics.image.JPEGFactory;
import org.sejda.sambox.pdmodel.graphics.image.LosslessFactory;
import org.sejda.sambox.pdmodel.graphics.image.PDImage;
import org.sejda.sambox.pdmodel.graphics.image.SampledImageReader;
import org.sejda.sambox.util.filetypedetector.FileType;
import org.sejda.sambox.util.filetypedetector.FileTypeDetector;
import org.sejda.util.RequireUtils;

public final class PDImageXObject
extends PDXObject
implements PDImage {
    private BufferedImage cachedImage;
    private PDColorSpace colorSpace;
    private PDResources resources;

    public static PDImageXObject createThumbnail(COSStream cosStream) throws IOException {
        PDStream pdStream = new PDStream(cosStream);
        return new PDImageXObject(pdStream, null);
    }

    public PDImageXObject() throws IOException {
        this(new PDStream(), (PDResources)null);
    }

    public PDImageXObject(InputStream encodedStream, COSBase cosFilter, int width, int height, int bitsPerComponent, PDColorSpace initColorSpace) throws IOException {
        super(PDImageXObject.createRawStream(encodedStream), COSName.IMAGE);
        this.getCOSObject().setItem(COSName.FILTER, cosFilter);
        this.resources = null;
        this.colorSpace = null;
        this.setBitsPerComponent(bitsPerComponent);
        this.setWidth(width);
        this.setHeight(height);
        this.setColorSpace(initColorSpace);
    }

    private static COSStream createRawStream(InputStream rawInput) throws IOException {
        COSStream stream = new COSStream();
        try (OutputStream output = stream.createFilteredStream();){
            IOUtils.copy((InputStream)rawInput, (OutputStream)output);
        }
        return stream;
    }

    public PDImageXObject(PDStream stream, PDResources resources) throws IOException {
        super(stream, COSName.IMAGE);
        stream.getCOSObject().addAll(stream.getCOSObject().getDecodeResult().getParameters());
        this.resources = resources;
        this.colorSpace = stream.getCOSObject().getDecodeResult().getJPXColorSpace();
    }

    public static PDImageXObject createFromFile(String imagePath) throws IOException {
        return PDImageXObject.createFromFile(new File(imagePath));
    }

    public static PDImageXObject createFromFile(File file) throws IOException {
        RequireUtils.requireNotNullArg((Object)file, (String)"Cannot create image from a null file");
        FileType fileType = FileTypeDetector.detectFileType(file);
        if (fileType.equals((Object)FileType.JPEG)) {
            return JPEGFactory.createFromFile(file);
        }
        if (fileType.equals((Object)FileType.TIFF)) {
            return CCITTFactory.createFromFile(file);
        }
        BufferedImage image = ImageIO.read(file);
        RequireUtils.requireNotNullArg((Object)image, (String)("Image type not supported " + file.getName()));
        return LosslessFactory.createFromImage(image);
    }

    public PDMetadata getMetadata() {
        COSStream cosStream = this.getCOSObject().getDictionaryObject(COSName.METADATA, COSStream.class);
        if (cosStream != null) {
            return new PDMetadata(cosStream);
        }
        return null;
    }

    public void setMetadata(PDMetadata meta) {
        this.getCOSObject().setItem(COSName.METADATA, (COSObjectable)meta);
    }

    public int getStructParent() {
        return this.getCOSObject().getInt(COSName.STRUCT_PARENT, 0);
    }

    public void setStructParent(int key) {
        this.getCOSObject().setInt(COSName.STRUCT_PARENT, key);
    }

    @Override
    public BufferedImage getImage() throws IOException {
        if (this.cachedImage != null) {
            return this.cachedImage;
        }
        BufferedImage image = SampledImageReader.getRGBImage(this, this.getColorKeyMask());
        PDImageXObject softMask = this.getSoftMask();
        if (softMask != null) {
            image = this.applyMask(image, softMask.getOpaqueImage(), true);
        } else {
            PDImageXObject mask = this.getMask();
            if (mask != null && mask.isStencil()) {
                image = this.applyMask(image, mask.getOpaqueImage(), false);
            }
        }
        this.cachedImage = image;
        return image;
    }

    public BufferedImage getImageWithoutMasks() throws IOException {
        return SampledImageReader.getRGBImage(this, this.getColorKeyMask());
    }

    @Override
    public BufferedImage getStencilImage(Paint paint) throws IOException {
        if (!this.isStencil()) {
            throw new IllegalStateException("Image is not a stencil");
        }
        return SampledImageReader.getStencilImage(this, paint);
    }

    public BufferedImage getOpaqueImage() throws IOException {
        return SampledImageReader.getRGBImage(this, null);
    }

    private BufferedImage applyMask(BufferedImage image, BufferedImage mask, boolean isSoft) {
        if (mask == null) {
            return image;
        }
        int width = image.getWidth();
        int height = image.getHeight();
        if (mask.getWidth() < width || mask.getHeight() < height) {
            mask = this.scaleImage(mask, width, height);
        } else if (mask.getWidth() > width || mask.getHeight() > height) {
            width = mask.getWidth();
            height = mask.getHeight();
            image = this.scaleImage(image, width, height);
        }
        BufferedImage masked = new BufferedImage(width, height, 2);
        WritableRaster src = image.getRaster();
        WritableRaster dest = masked.getRaster();
        WritableRaster alpha = mask.getRaster();
        float[] rgb = new float[4];
        float[] rgba = new float[4];
        float[] alphaPixel = null;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                src.getPixel(x, y, rgb);
                rgba[0] = rgb[0];
                rgba[1] = rgb[1];
                rgba[2] = rgb[2];
                alphaPixel = alpha.getPixel(x, y, alphaPixel);
                rgba[3] = isSoft ? alphaPixel[0] : 255.0f - alphaPixel[0];
                dest.setPixel(x, y, rgba);
            }
        }
        return masked;
    }

    private BufferedImage scaleImage(BufferedImage image, int width, int height) {
        BufferedImage image2 = new BufferedImage(width, height, 1);
        Graphics2D g = image2.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.drawImage(image, 0, 0, width, height, 0, 0, image.getWidth(), image.getHeight(), null);
        g.dispose();
        return image2;
    }

    public PDImageXObject getMask() throws IOException {
        COSStream cosStream = this.getCOSObject().getDictionaryObject(COSName.MASK, COSStream.class);
        if (cosStream != null) {
            return new PDImageXObject(new PDStream(cosStream), null);
        }
        return null;
    }

    public COSArray getColorKeyMask() {
        return this.getCOSObject().getDictionaryObject(COSName.MASK, COSArray.class);
    }

    public PDImageXObject getSoftMask() throws IOException {
        COSStream cosStream = this.getCOSObject().getDictionaryObject(COSName.SMASK, COSStream.class);
        if (cosStream != null) {
            return new PDImageXObject(new PDStream(cosStream), null);
        }
        return null;
    }

    @Override
    public int getBitsPerComponent() {
        if (this.isStencil()) {
            return 1;
        }
        return this.getCOSObject().getInt(COSName.BITS_PER_COMPONENT, COSName.BPC);
    }

    @Override
    public void setBitsPerComponent(int bpc) {
        this.getCOSObject().setInt(COSName.BITS_PER_COMPONENT, bpc);
    }

    @Override
    public PDColorSpace getColorSpace() throws IOException {
        if (this.colorSpace == null) {
            COSBase cosBase = this.getCOSObject().getDictionaryObject(COSName.COLORSPACE, COSName.CS);
            if (cosBase != null) {
                this.colorSpace = PDColorSpace.create(cosBase, this.resources);
            } else {
                if (this.isStencil()) {
                    return PDDeviceGray.INSTANCE;
                }
                throw new IOException("could not determine color space");
            }
        }
        return this.colorSpace;
    }

    @Override
    public InputStream createInputStream() throws IOException {
        return this.getStream().createInputStream();
    }

    @Override
    public ByteBuffer asByteBuffer() throws IOException {
        return this.getStream().getCOSObject().getUnfilteredByteBuffer();
    }

    @Override
    public boolean isEmpty() throws IOException {
        return this.getStream().getCOSObject().isEmpty();
    }

    @Override
    public void setColorSpace(PDColorSpace cs) {
        this.getCOSObject().setItem(COSName.COLORSPACE, cs != null ? cs.getCOSObject() : null);
    }

    @Override
    public int getHeight() {
        return this.getCOSObject().getInt(COSName.HEIGHT);
    }

    @Override
    public void setHeight(int h) {
        this.getCOSObject().setInt(COSName.HEIGHT, h);
    }

    @Override
    public int getWidth() {
        return this.getCOSObject().getInt(COSName.WIDTH);
    }

    @Override
    public void setWidth(int w) {
        this.getCOSObject().setInt(COSName.WIDTH, w);
    }

    @Override
    public boolean getInterpolate() {
        return this.getCOSObject().getBoolean(COSName.INTERPOLATE, false);
    }

    @Override
    public void setInterpolate(boolean value) {
        this.getCOSObject().setBoolean(COSName.INTERPOLATE, value);
    }

    @Override
    public void setDecode(COSArray decode) {
        this.getCOSObject().setItem(COSName.DECODE, (COSBase)decode);
    }

    @Override
    public COSArray getDecode() {
        COSBase decode = this.getCOSObject().getDictionaryObject(COSName.DECODE);
        if (decode instanceof COSArray) {
            return (COSArray)decode;
        }
        return null;
    }

    @Override
    public boolean isStencil() {
        return this.getCOSObject().getBoolean(COSName.IMAGE_MASK, false);
    }

    @Override
    public void setStencil(boolean isStencil) {
        this.getCOSObject().setBoolean(COSName.IMAGE_MASK, isStencil);
    }
}

