/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.interactive.annotation;

import java.util.Objects;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSStream;
import org.sejda.sambox.pdmodel.common.PDDictionaryWrapper;
import org.sejda.sambox.pdmodel.graphics.color.PDColor;
import org.sejda.sambox.pdmodel.graphics.color.PDColorSpace;
import org.sejda.sambox.pdmodel.graphics.color.PDDeviceCMYK;
import org.sejda.sambox.pdmodel.graphics.color.PDDeviceGray;
import org.sejda.sambox.pdmodel.graphics.color.PDDeviceRGB;
import org.sejda.sambox.pdmodel.graphics.form.PDFormXObject;

public class PDAppearanceCharacteristicsDictionary
extends PDDictionaryWrapper {
    public PDAppearanceCharacteristicsDictionary(COSDictionary dict) {
        super(dict);
    }

    public int getRotation() {
        return this.getCOSObject().getInt(COSName.R, 0);
    }

    public void setRotation(int rotation) {
        this.getCOSObject().setInt(COSName.R, rotation);
    }

    public PDColor getBorderColour() {
        return this.getColor(COSName.BC);
    }

    public void setBorderColour(PDColor c) {
        this.getCOSObject().setItem(COSName.BC, (COSBase)c.toComponentsCOSArray());
    }

    public PDColor getBackground() {
        return this.getColor(COSName.BG);
    }

    public void setBackground(PDColor c) {
        this.getCOSObject().setItem(COSName.BG, (COSBase)c.toComponentsCOSArray());
    }

    public String getNormalCaption() {
        return this.getCOSObject().getString("CA");
    }

    public void setNormalCaption(String caption) {
        this.getCOSObject().setString("CA", caption);
    }

    public String getRolloverCaption() {
        return this.getCOSObject().getString("RC");
    }

    public void setRolloverCaption(String caption) {
        this.getCOSObject().setString("RC", caption);
    }

    public String getAlternateCaption() {
        return this.getCOSObject().getString("AC");
    }

    public void setAlternateCaption(String caption) {
        this.getCOSObject().setString("AC", caption);
    }

    public PDFormXObject getNormalIcon() {
        COSStream i = this.getCOSObject().getDictionaryObject("I", COSStream.class);
        if (Objects.nonNull(i)) {
            return new PDFormXObject(i);
        }
        return null;
    }

    public PDFormXObject getRolloverIcon() {
        COSStream i = this.getCOSObject().getDictionaryObject("RI", COSStream.class);
        if (Objects.nonNull(i)) {
            return new PDFormXObject(i);
        }
        return null;
    }

    public PDFormXObject getAlternateIcon() {
        COSStream i = this.getCOSObject().getDictionaryObject("IX", COSStream.class);
        if (Objects.nonNull(i)) {
            return new PDFormXObject(i);
        }
        return null;
    }

    private PDColor getColor(COSName itemName) {
        COSArray c = this.getCOSObject().getDictionaryObject(itemName, COSArray.class);
        if (Objects.nonNull(c)) {
            switch (c.size()) {
                case 1: {
                    return new PDColor(c, (PDColorSpace)PDDeviceGray.INSTANCE);
                }
                case 3: {
                    return new PDColor(c, (PDColorSpace)PDDeviceRGB.INSTANCE);
                }
                case 4: {
                    return new PDColor(c, (PDColorSpace)PDDeviceCMYK.INSTANCE);
                }
            }
        }
        return null;
    }
}

