/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.interactive.form;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSArrayList;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSObjectable;
import org.sejda.sambox.cos.COSString;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.PDPageContentStream;
import org.sejda.sambox.pdmodel.PDResources;
import org.sejda.sambox.pdmodel.common.PDDictionaryWrapper;
import org.sejda.sambox.pdmodel.common.PDRectangle;
import org.sejda.sambox.pdmodel.font.PDType1Font;
import org.sejda.sambox.pdmodel.graphics.PDXObject;
import org.sejda.sambox.pdmodel.graphics.form.PDFormXObject;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotation;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.sejda.sambox.pdmodel.interactive.form.PDField;
import org.sejda.sambox.pdmodel.interactive.form.PDFieldTree;
import org.sejda.sambox.pdmodel.interactive.form.PDTerminalField;
import org.sejda.sambox.pdmodel.interactive.form.PDXFAResource;
import org.sejda.sambox.util.Matrix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PDAcroForm
extends PDDictionaryWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(PDAcroForm.class);
    private static final int FLAG_SIGNATURES_EXIST = 1;
    private static final int FLAG_APPEND_ONLY = 2;
    private final PDDocument document;

    public PDAcroForm(PDDocument document) {
        this.document = document;
        this.getCOSObject().setItem(COSName.FIELDS, (COSBase)new COSArray());
    }

    public PDAcroForm(PDDocument document, COSDictionary form) {
        super(form);
        this.document = document;
        this.verifyOrCreateDefaults();
    }

    private void verifyOrCreateDefaults() {
        PDResources defaultResources;
        String adobeDefaultAppearanceString = "/Helv 0 Tf 0 g ";
        if (this.getDefaultAppearance().length() == 0) {
            this.setDefaultAppearance("/Helv 0 Tf 0 g ");
        }
        if ((defaultResources = this.getDefaultResources()) == null) {
            defaultResources = new PDResources();
            this.setDefaultResources(defaultResources);
        }
        if (!defaultResources.getCOSObject().containsKey("Helv")) {
            defaultResources.put(COSName.getPDFName("Helv"), PDType1Font.HELVETICA);
        }
        if (!defaultResources.getCOSObject().containsKey("ZaDb")) {
            defaultResources.put(COSName.getPDFName("ZaDb"), PDType1Font.ZAPF_DINGBATS);
        }
    }

    public PDDocument getDocument() {
        return this.document;
    }

    public void flatten() throws IOException {
        if (this.xfaIsDynamic()) {
            LOG.warn("Flatten for a dynamic XFA form is not supported");
            return;
        }
        ArrayList<PDField> fields = new ArrayList<PDField>();
        for (PDField field : this.getFieldTree()) {
            fields.add(field);
        }
        this.flatten(fields, false);
    }

    public void flatten(List<PDField> fields, boolean refreshAppearances) throws IOException {
        if (this.xfaIsDynamic()) {
            LOG.warn("Flatten for a dynamix XFA form is not supported");
            return;
        }
        if (refreshAppearances) {
            this.refreshAppearances(fields);
        }
        for (PDPage page : this.document.getPages()) {
            boolean isContentStreamWrapped = false;
            ArrayList<PDAnnotation> annotations = new ArrayList<PDAnnotation>();
            for (PDAnnotation annotation : page.getAnnotations()) {
                PDPageContentStream contentStream;
                if (!(annotation instanceof PDAnnotationWidget)) {
                    annotations.add(annotation);
                    continue;
                }
                if (annotation.isInvisible() || annotation.isHidden() || annotation.getNormalAppearanceStream() == null) continue;
                if (!isContentStreamWrapped) {
                    contentStream = new PDPageContentStream(this.document, page, PDPageContentStream.AppendMode.APPEND, true, true);
                    isContentStreamWrapped = true;
                } else {
                    contentStream = new PDPageContentStream(this.document, page, PDPageContentStream.AppendMode.APPEND, true);
                }
                PDAppearanceStream appearanceStream = annotation.getNormalAppearanceStream();
                PDFormXObject fieldObject = new PDFormXObject(appearanceStream.getCOSObject());
                contentStream.saveGraphicsState();
                boolean needsTranslation = this.resolveNeedsTranslation(appearanceStream);
                boolean needsScaling = this.resolveNeedsScaling(appearanceStream);
                Matrix transformationMatrix = new Matrix();
                boolean transformed = false;
                if (needsTranslation) {
                    transformationMatrix.translate(annotation.getRectangle().getLowerLeftX(), annotation.getRectangle().getLowerLeftY());
                    transformed = true;
                }
                if (needsScaling) {
                    PDRectangle bbox = appearanceStream.getBBox();
                    PDRectangle fieldRect = annotation.getRectangle();
                    if (bbox.getWidth() - fieldRect.getWidth() != 0.0f && bbox.getHeight() - fieldRect.getHeight() != 0.0f) {
                        float xScale = fieldRect.getWidth() / bbox.getWidth();
                        float yScale = fieldRect.getHeight() / bbox.getHeight();
                        Matrix scalingMatrix = Matrix.getScaleInstance(xScale, yScale);
                        transformationMatrix.concatenate(scalingMatrix);
                        transformed = true;
                    }
                }
                if (transformed) {
                    contentStream.transform(transformationMatrix);
                }
                contentStream.drawForm(fieldObject);
                contentStream.restoreGraphicsState();
                contentStream.close();
            }
            page.setAnnotations(annotations);
        }
        this.setFields(Collections.emptyList());
        this.getCOSObject().removeItem(COSName.XFA);
    }

    public void refreshAppearances() throws IOException {
        for (PDField field : this.getFieldTree()) {
            if (!(field instanceof PDTerminalField)) continue;
            ((PDTerminalField)field).constructAppearances();
        }
    }

    public void refreshAppearances(List<PDField> fields) throws IOException {
        for (PDField field : fields) {
            if (!(field instanceof PDTerminalField)) continue;
            ((PDTerminalField)field).constructAppearances();
        }
    }

    public List<PDField> getFields() {
        ArrayList<PDField> pdFields = new ArrayList<PDField>();
        COSArray fields = this.getCOSObject().getDictionaryObject(COSName.FIELDS, COSArray.class);
        if (Objects.nonNull(fields)) {
            for (COSBase field : fields) {
                if (!Objects.nonNull(field) || !(field.getCOSObject() instanceof COSDictionary)) continue;
                pdFields.add(PDField.fromDictionary(this, (COSDictionary)field.getCOSObject(), null));
            }
        }
        return pdFields;
    }

    public void addFields(List<PDField> toAdd) {
        COSArray fields = Optional.ofNullable(this.getCOSObject().getDictionaryObject(COSName.FIELDS, COSArray.class)).orElseGet(COSArray::new);
        for (PDField field : toAdd) {
            fields.add(field);
        }
        this.getCOSObject().setItem(COSName.FIELDS, (COSBase)fields);
    }

    public COSBase removeField(PDField remove) {
        int removeIdx;
        COSArray fields = this.getCOSObject().getDictionaryObject(COSName.FIELDS, COSArray.class);
        if (Objects.nonNull(fields) && (removeIdx = fields.indexOfObject(remove.getCOSObject())) >= 0) {
            return fields.remove(removeIdx);
        }
        return null;
    }

    public void setFields(List<PDField> fields) {
        this.getCOSObject().setItem(COSName.FIELDS, (COSBase)COSArrayList.converterToCOSArray(fields));
    }

    public Iterator<PDField> getFieldIterator() {
        return new PDFieldTree(this).iterator();
    }

    public PDFieldTree getFieldTree() {
        return new PDFieldTree(this);
    }

    public PDField getField(String fullyQualifiedName) {
        if (fullyQualifiedName == null) {
            return null;
        }
        return this.getFieldTree().stream().filter(f -> f != null && fullyQualifiedName.equals(f.getFullyQualifiedName())).findFirst().orElse(null);
    }

    public String getDefaultAppearance() {
        return Optional.ofNullable(this.getCOSObject().getDictionaryObject(COSName.DA, COSString.class)).map(COSString::getString).orElse("");
    }

    public void setDefaultAppearance(String daValue) {
        this.getCOSObject().setString(COSName.DA, daValue);
    }

    public boolean isNeedAppearances() {
        return this.getCOSObject().getBoolean(COSName.NEED_APPEARANCES, false);
    }

    public void setNeedAppearances(Boolean value) {
        this.getCOSObject().setBoolean(COSName.NEED_APPEARANCES, (boolean)value);
    }

    public PDResources getDefaultResources() {
        return Optional.ofNullable(this.getCOSObject().getDictionaryObject(COSName.DR, COSDictionary.class)).map(dr -> new PDResources((COSDictionary)dr, this.document.getResourceCache())).orElse(null);
    }

    public void setDefaultResources(PDResources dr) {
        this.getCOSObject().setItem(COSName.DR, (COSObjectable)dr);
    }

    public boolean hasXFA() {
        return this.getCOSObject().containsKey(COSName.XFA);
    }

    public boolean xfaIsDynamic() {
        return this.hasXFA() && this.getFields().isEmpty();
    }

    public PDXFAResource getXFA() {
        return Optional.ofNullable(this.getCOSObject().getDictionaryObject(COSName.XFA, COSDictionary.class)).map(PDXFAResource::new).orElse(null);
    }

    public void setXFA(PDXFAResource xfa) {
        this.getCOSObject().setItem(COSName.XFA, (COSObjectable)xfa);
    }

    public int getQuadding() {
        return this.getCOSObject().getInt(COSName.Q, 0);
    }

    public void setQuadding(int q) {
        this.getCOSObject().setInt(COSName.Q, q);
    }

    public boolean isSignaturesExist() {
        return this.getCOSObject().getFlag(COSName.SIG_FLAGS, 1);
    }

    public void setSignaturesExist(boolean signaturesExist) {
        this.getCOSObject().setFlag(COSName.SIG_FLAGS, 1, signaturesExist);
    }

    public boolean isAppendOnly() {
        return this.getCOSObject().getFlag(COSName.SIG_FLAGS, 2);
    }

    public void setAppendOnly(boolean appendOnly) {
        this.getCOSObject().setFlag(COSName.SIG_FLAGS, 2, appendOnly);
    }

    private boolean resolveNeedsTranslation(PDAppearanceStream appearanceStream) {
        boolean needsTranslation = false;
        PDResources resources = appearanceStream.getResources();
        if (resources != null && resources.getXObjectNames().iterator().hasNext()) {
            Iterator<COSName> xObjectNames = resources.getXObjectNames().iterator();
            while (xObjectNames.hasNext()) {
                try {
                    PDXObject xObject = resources.getXObject(xObjectNames.next());
                    if (!(xObject instanceof PDFormXObject)) continue;
                    PDRectangle bbox = ((PDFormXObject)xObject).getBBox();
                    float llX = bbox.getLowerLeftX();
                    float llY = bbox.getLowerLeftY();
                    if (llX != 0.0f || llY != 0.0f) continue;
                    needsTranslation = true;
                }
                catch (IOException iOException) {}
            }
            return needsTranslation;
        }
        return true;
    }

    private boolean resolveNeedsScaling(PDAppearanceStream appearanceStream) {
        PDResources resources = appearanceStream.getResources();
        return resources != null && resources.getXObjectNames().iterator().hasNext();
    }
}

