/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.interactive.form;

import java.io.IOException;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSNumber;
import org.sejda.sambox.cos.COSStream;
import org.sejda.sambox.cos.COSString;
import org.sejda.sambox.pdmodel.PDResources;
import org.sejda.sambox.pdmodel.font.PDFont;
import org.sejda.sambox.pdmodel.interactive.form.PDAcroForm;
import org.sejda.sambox.pdmodel.interactive.form.PDDefaultAppearanceString;
import org.sejda.sambox.pdmodel.interactive.form.PDNonTerminalField;
import org.sejda.sambox.pdmodel.interactive.form.PDTerminalField;

public abstract class PDVariableText
extends PDTerminalField {
    public static final int QUADDING_LEFT = 0;
    public static final int QUADDING_CENTERED = 1;
    public static final int QUADDING_RIGHT = 2;
    private PDFont appearanceOverrideFont = null;

    PDVariableText(PDAcroForm acroForm) {
        super(acroForm);
    }

    PDVariableText(PDAcroForm acroForm, COSDictionary field, PDNonTerminalField parent) {
        super(acroForm, field, parent);
    }

    public String getDefaultAppearance() {
        COSString defaultAppearance = (COSString)this.getInheritableAttribute(COSName.DA);
        return defaultAppearance.getString();
    }

    PDDefaultAppearanceString getDefaultAppearanceString() throws IOException {
        COSString da = (COSString)this.getInheritableAttribute(COSName.DA);
        PDResources dr = this.getAcroForm().getDefaultResources();
        return new PDDefaultAppearanceString(da, dr);
    }

    public void setDefaultAppearance(String daValue) {
        this.getCOSObject().setString(COSName.DA, daValue);
    }

    public String getDefaultStyleString() {
        COSString defaultStyleString = (COSString)this.getCOSObject().getDictionaryObject(COSName.DS);
        return defaultStyleString.getString();
    }

    public void setDefaultStyleString(String defaultStyleString) {
        if (defaultStyleString != null) {
            this.getCOSObject().setItem(COSName.DS, (COSBase)COSString.parseLiteral(defaultStyleString));
        } else {
            this.getCOSObject().removeItem(COSName.DS);
        }
    }

    public int getQ() {
        int retval = 0;
        COSNumber number = (COSNumber)this.getInheritableAttribute(COSName.Q);
        if (number != null) {
            retval = number.intValue();
        }
        return retval;
    }

    public void setQ(int q) {
        this.getCOSObject().setInt(COSName.Q, q);
    }

    public String getRichTextValue() {
        return this.getStringOrStream(this.getInheritableAttribute(COSName.RV));
    }

    public void setRichTextValue(String richTextValue) {
        if (richTextValue != null) {
            this.getCOSObject().setItem(COSName.RV, (COSBase)COSString.parseLiteral(richTextValue));
        } else {
            this.getCOSObject().removeItem(COSName.RV);
        }
    }

    protected final String getStringOrStream(COSBase base) {
        if (base instanceof COSString) {
            return ((COSString)base).getString();
        }
        if (base instanceof COSStream) {
            return ((COSStream)base).asTextString();
        }
        return "";
    }

    public PDFont getAppearanceFont() {
        try {
            if (this.appearanceOverrideFont != null) {
                return this.appearanceOverrideFont;
            }
            return this.getDefaultAppearanceString().getFont();
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public PDFont getAppearanceOverrideFont() {
        return this.appearanceOverrideFont;
    }

    public void setAppearanceOverrideFont(PDFont appearanceOverrideFont) {
        this.appearanceOverrideFont = appearanceOverrideFont;
    }
}

