/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.text;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.sejda.sambox.contentstream.operator.markedcontent.BeginMarkedContentSequence;
import org.sejda.sambox.contentstream.operator.markedcontent.BeginMarkedContentSequenceWithProperties;
import org.sejda.sambox.contentstream.operator.markedcontent.DrawObject;
import org.sejda.sambox.contentstream.operator.markedcontent.EndMarkedContentSequence;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.pdmodel.documentinterchange.markedcontent.PDMarkedContent;
import org.sejda.sambox.pdmodel.graphics.PDXObject;
import org.sejda.sambox.text.PDFTextStreamEngine;
import org.sejda.sambox.text.TextPosition;

public class PDFMarkedContentExtractor
extends PDFTextStreamEngine {
    private final boolean suppressDuplicateOverlappingText = true;
    private final List<PDMarkedContent> markedContents = new ArrayList<PDMarkedContent>();
    private final Stack<PDMarkedContent> currentMarkedContents = new Stack();
    private final Map<String, List<TextPosition>> characterListMapping = new HashMap<String, List<TextPosition>>();

    public PDFMarkedContentExtractor() throws IOException {
        this(null);
    }

    public PDFMarkedContentExtractor(String encoding) throws IOException {
        this.addOperator(new BeginMarkedContentSequenceWithProperties());
        this.addOperator(new BeginMarkedContentSequence());
        this.addOperator(new EndMarkedContentSequence());
        this.addOperator(new DrawObject());
    }

    private boolean within(float first, float second, float variance) {
        return second > first - variance && second < first + variance;
    }

    public void beginMarkedContentSequence(COSName tag, COSDictionary properties) {
        PDMarkedContent markedContent = PDMarkedContent.create(tag, properties);
        if (this.currentMarkedContents.isEmpty()) {
            this.markedContents.add(markedContent);
        } else {
            PDMarkedContent currentMarkedContent = this.currentMarkedContents.peek();
            if (currentMarkedContent != null) {
                currentMarkedContent.addMarkedContent(markedContent);
            }
        }
        this.currentMarkedContents.push(markedContent);
    }

    public void endMarkedContentSequence() {
        if (!this.currentMarkedContents.isEmpty()) {
            this.currentMarkedContents.pop();
        }
    }

    public void xobject(PDXObject xobject) {
        if (!this.currentMarkedContents.isEmpty()) {
            this.currentMarkedContents.peek().addXObject(xobject);
        }
    }

    @Override
    protected void processTextPosition(TextPosition text) {
        boolean showCharacter = true;
        this.getClass();
        showCharacter = false;
        String textCharacter = text.getUnicode();
        float textX = text.getX();
        float textY = text.getY();
        List<TextPosition> sameTextCharacters = this.characterListMapping.get(textCharacter);
        if (sameTextCharacters == null) {
            sameTextCharacters = new ArrayList<TextPosition>();
            this.characterListMapping.put(textCharacter, sameTextCharacters);
        }
        boolean suppressCharacter = false;
        float tolerance = text.getWidth() / (float)textCharacter.length() / 3.0f;
        Iterator<TextPosition> iterator = sameTextCharacters.iterator();
        while (iterator.hasNext()) {
            TextPosition sameTextCharacter;
            TextPosition character = sameTextCharacter = iterator.next();
            String charCharacter = character.getUnicode();
            float charX = character.getX();
            float charY = character.getY();
            if (charCharacter == null || !this.within(charX, textX, tolerance) || !this.within(charY, textY, tolerance)) continue;
            suppressCharacter = true;
            break;
        }
        if (!suppressCharacter) {
            sameTextCharacters.add(text);
            showCharacter = true;
        }
        if (showCharacter) {
            ArrayList<TextPosition> textList = new ArrayList<TextPosition>();
            if (textList.isEmpty()) {
                textList.add(text);
            } else {
                TextPosition previousTextPosition = (TextPosition)textList.get(textList.size() - 1);
                if (text.isDiacritic() && previousTextPosition.contains(text)) {
                    previousTextPosition.mergeDiacritic(text);
                } else if (previousTextPosition.isDiacritic() && text.contains(previousTextPosition)) {
                    text.mergeDiacritic(previousTextPosition);
                    textList.remove(textList.size() - 1);
                    textList.add(text);
                } else {
                    textList.add(text);
                }
            }
            if (!this.currentMarkedContents.isEmpty()) {
                this.currentMarkedContents.peek().addText(text);
            }
        }
    }

    public List<PDMarkedContent> getMarkedContents() {
        return this.markedContents;
    }
}

