/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.text;

import java.io.IOException;
import java.io.InputStream;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.fontbox.util.BoundingBox;
import org.sejda.sambox.contentstream.PDFStreamEngine;
import org.sejda.sambox.contentstream.operator.DrawObject;
import org.sejda.sambox.contentstream.operator.state.Concatenate;
import org.sejda.sambox.contentstream.operator.state.Restore;
import org.sejda.sambox.contentstream.operator.state.Save;
import org.sejda.sambox.contentstream.operator.state.SetGraphicsStateParameters;
import org.sejda.sambox.contentstream.operator.state.SetMatrix;
import org.sejda.sambox.contentstream.operator.text.BeginText;
import org.sejda.sambox.contentstream.operator.text.EndText;
import org.sejda.sambox.contentstream.operator.text.MoveText;
import org.sejda.sambox.contentstream.operator.text.MoveTextSetLeading;
import org.sejda.sambox.contentstream.operator.text.NextLine;
import org.sejda.sambox.contentstream.operator.text.SetCharSpacing;
import org.sejda.sambox.contentstream.operator.text.SetFontAndSize;
import org.sejda.sambox.contentstream.operator.text.SetTextHorizontalScaling;
import org.sejda.sambox.contentstream.operator.text.SetTextLeading;
import org.sejda.sambox.contentstream.operator.text.SetTextRenderingMode;
import org.sejda.sambox.contentstream.operator.text.SetTextRise;
import org.sejda.sambox.contentstream.operator.text.SetWordSpacing;
import org.sejda.sambox.contentstream.operator.text.ShowText;
import org.sejda.sambox.contentstream.operator.text.ShowTextAdjusted;
import org.sejda.sambox.contentstream.operator.text.ShowTextLine;
import org.sejda.sambox.contentstream.operator.text.ShowTextLineAndSpace;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.common.PDRectangle;
import org.sejda.sambox.pdmodel.font.PDCIDFont;
import org.sejda.sambox.pdmodel.font.PDCIDFontType2;
import org.sejda.sambox.pdmodel.font.PDFont;
import org.sejda.sambox.pdmodel.font.PDFontDescriptor;
import org.sejda.sambox.pdmodel.font.PDSimpleFont;
import org.sejda.sambox.pdmodel.font.PDTrueTypeFont;
import org.sejda.sambox.pdmodel.font.PDType0Font;
import org.sejda.sambox.pdmodel.font.PDType3Font;
import org.sejda.sambox.pdmodel.font.encoding.GlyphList;
import org.sejda.sambox.pdmodel.graphics.state.PDGraphicsState;
import org.sejda.sambox.text.TextPosition;
import org.sejda.sambox.util.Matrix;
import org.sejda.sambox.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFTextStreamEngine
extends PDFStreamEngine {
    private static final Logger LOG = LoggerFactory.getLogger(PDFTextStreamEngine.class);
    private int pageRotation;
    private PDRectangle cropBox;
    private Matrix translateMatrix;
    private final GlyphList glyphList;

    public PDFTextStreamEngine() throws IOException {
        this.addOperator(new BeginText());
        this.addOperator(new Concatenate());
        this.addOperator(new DrawObject());
        this.addOperator(new EndText());
        this.addOperator(new SetGraphicsStateParameters());
        this.addOperator(new Save());
        this.addOperator(new Restore());
        this.addOperator(new NextLine());
        this.addOperator(new SetCharSpacing());
        this.addOperator(new MoveText());
        this.addOperator(new MoveTextSetLeading());
        this.addOperator(new SetFontAndSize());
        this.addOperator(new ShowText());
        this.addOperator(new ShowTextAdjusted());
        this.addOperator(new SetTextLeading());
        this.addOperator(new SetMatrix());
        this.addOperator(new SetTextRenderingMode());
        this.addOperator(new SetTextRise());
        this.addOperator(new SetWordSpacing());
        this.addOperator(new SetTextHorizontalScaling());
        this.addOperator(new ShowTextLine());
        this.addOperator(new ShowTextLineAndSpace());
        String path = "org/sejda/sambox/resources/glyphlist/additional.txt";
        InputStream input = GlyphList.class.getClassLoader().getResourceAsStream(path);
        this.glyphList = new GlyphList(GlyphList.getAdobeGlyphList(), input);
    }

    @Override
    public void processPage(PDPage page) throws IOException {
        this.pageRotation = page.getRotation();
        this.cropBox = page.getCropBox();
        this.translateMatrix = this.cropBox.getLowerLeftX() == 0.0f && this.cropBox.getLowerLeftY() == 0.0f ? null : Matrix.getTranslateInstance(-this.cropBox.getLowerLeftX(), -this.cropBox.getLowerLeftY());
        super.processPage(page);
    }

    @Override
    protected void showGlyph(Matrix textRenderingMatrix, PDFont font, int code, String unicode, Vector displacement) throws IOException {
        Matrix translatedTextRenderingMatrix;
        float capHeight;
        PDGraphicsState state = this.getGraphicsState();
        Matrix ctm = state.getCurrentTransformationMatrix();
        float fontSize = state.getTextState().getFontSize();
        float horizontalScaling = state.getTextState().getHorizontalScaling() / 100.0f;
        Matrix textMatrix = this.getTextMatrix();
        BoundingBox bbox = font.getBoundingBox();
        if (bbox.getLowerLeftY() < -32768.0f) {
            bbox.setLowerLeftY(-(bbox.getLowerLeftY() + 65536.0f));
        }
        float glyphHeight = bbox.getHeight() / 2.0f;
        PDFontDescriptor fontDescriptor = font.getFontDescriptor();
        if (fontDescriptor != null && (capHeight = fontDescriptor.getCapHeight()) != 0.0f && (capHeight < glyphHeight || glyphHeight == 0.0f)) {
            glyphHeight = capHeight;
        }
        float height = font instanceof PDType3Font ? font.getFontMatrix().transformPoint((float)0.0f, (float)glyphHeight).y : glyphHeight / 1000.0f;
        float displacementX = displacement.getX();
        if (font.isVertical()) {
            PDCIDFont cidFont;
            displacementX = font.getWidth(code) / 1000.0f;
            TrueTypeFont ttf = null;
            if (font instanceof PDTrueTypeFont) {
                ttf = ((PDTrueTypeFont)font).getTrueTypeFont();
            } else if (font instanceof PDType0Font && (cidFont = ((PDType0Font)font).getDescendantFont()) instanceof PDCIDFontType2) {
                ttf = ((PDCIDFontType2)cidFont).getTrueTypeFont();
            }
            if (ttf != null && ttf.getUnitsPerEm() != 1000) {
                displacementX *= 1000.0f / (float)ttf.getUnitsPerEm();
            }
        }
        float tx = displacementX * fontSize * horizontalScaling;
        float ty = displacement.getY() * fontSize;
        Matrix td = Matrix.getTranslateInstance(tx, ty);
        Matrix nextTextRenderingMatrix = td.multiply(textMatrix).multiply(ctm);
        float nextX = nextTextRenderingMatrix.getTranslateX();
        float nextY = nextTextRenderingMatrix.getTranslateY();
        float dxDisplay = nextX - textRenderingMatrix.getTranslateX();
        float dyDisplay = height * textRenderingMatrix.getScalingFactorY();
        float glyphSpaceToTextSpaceFactor = 0.001f;
        if (font instanceof PDType3Font) {
            glyphSpaceToTextSpaceFactor = font.getFontMatrix().getScaleX();
        }
        float spaceWidthText = 0.0f;
        try {
            spaceWidthText = font.getSpaceWidth() * glyphSpaceToTextSpaceFactor;
        }
        catch (Throwable exception) {
            LOG.warn(exception.getMessage(), exception);
        }
        if (spaceWidthText == 0.0f) {
            spaceWidthText = font.getAverageFontWidth() * glyphSpaceToTextSpaceFactor;
            spaceWidthText *= 0.8f;
        }
        if (spaceWidthText == 0.0f) {
            spaceWidthText = 1.0f;
        }
        float spaceWidthDisplay = spaceWidthText * textRenderingMatrix.getScalingFactorX();
        unicode = font.toUnicode(code, this.glyphList);
        if (unicode == null) {
            char c;
            if (font instanceof PDSimpleFont) {
                c = (char)code;
                unicode = new String(new char[]{c});
            } else {
                c = (char)code;
                unicode = new String(new char[]{c});
            }
        }
        if (this.translateMatrix == null) {
            translatedTextRenderingMatrix = textRenderingMatrix;
        } else {
            translatedTextRenderingMatrix = Matrix.concatenate(this.translateMatrix, textRenderingMatrix);
            nextX -= this.cropBox.getLowerLeftX();
            nextY -= this.cropBox.getLowerLeftY();
        }
        this.processTextPosition(new TextPosition(this.pageRotation, this.cropBox.getWidth(), this.cropBox.getHeight(), translatedTextRenderingMatrix, nextX, nextY, Math.abs(dyDisplay), dxDisplay, Math.abs(spaceWidthDisplay), unicode, new int[]{code}, font, fontSize, (int)(fontSize * textMatrix.getScalingFactorX())));
    }

    protected void processTextPosition(TextPosition text) {
    }
}

