/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.cos;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSFloat;
import org.sejda.sambox.cos.COSInteger;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSNull;
import org.sejda.sambox.cos.COSNumber;
import org.sejda.sambox.cos.COSObjectable;
import org.sejda.sambox.cos.COSString;

public class COSArrayList<E>
implements List<E> {
    private final COSArray array;
    private final List<E> actual;
    private boolean isFiltered = false;
    private COSDictionary parentDict;
    private COSName dictKey;

    public COSArrayList() {
        this.array = new COSArray();
        this.actual = new ArrayList();
    }

    public COSArrayList(List<E> actualList, COSArray cosArray) {
        this.actual = actualList;
        this.array = cosArray;
        if (this.actual.size() != this.array.size()) {
            this.isFiltered = true;
        }
    }

    public COSArrayList(E actualObject, COSBase item, COSDictionary dictionary, COSName dictionaryKey) {
        this.array = new COSArray();
        this.array.add(item);
        this.actual = new ArrayList();
        this.actual.add(actualObject);
        this.parentDict = dictionary;
        this.dictKey = dictionaryKey;
    }

    public COSArrayList(COSDictionary dictionary, COSName dictionaryKey) {
        this.array = new COSArray();
        this.actual = new ArrayList();
        this.parentDict = dictionary;
        this.dictKey = dictionaryKey;
    }

    @Override
    public int size() {
        return this.actual.size();
    }

    @Override
    public boolean isEmpty() {
        return this.actual.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.actual.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.actual.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.actual.toArray();
    }

    @Override
    public <X> X[] toArray(X[] a) {
        return this.actual.toArray(a);
    }

    @Override
    public boolean add(E o) {
        if (this.parentDict != null) {
            this.parentDict.setItem(this.dictKey, (COSBase)this.array);
            this.parentDict = null;
        }
        if (o instanceof String) {
            this.array.add(COSString.parseLiteral((String)o));
        } else if (this.array != null) {
            this.array.add(((COSObjectable)o).getCOSObject());
        }
        return this.actual.add(o);
    }

    @Override
    public boolean remove(Object o) {
        if (this.isFiltered) {
            throw new UnsupportedOperationException("removing entries from a filtered List is not permitted");
        }
        boolean retval = true;
        int index = this.actual.indexOf(o);
        if (index >= 0) {
            this.actual.remove(index);
            this.array.remove(index);
        } else {
            retval = false;
        }
        return retval;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.actual.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new RuntimeException("Unsupported");
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new RuntimeException("Unsupported operation");
    }

    public static List<Integer> convertIntegerCOSArrayToList(COSArray intArray) {
        COSArrayList retval = null;
        if (intArray != null) {
            ArrayList<Integer> numbers = new ArrayList<Integer>();
            for (int i = 0; i < intArray.size(); ++i) {
                COSNumber num = (COSNumber)intArray.get(i).getCOSObject();
                numbers.add(num.intValue());
            }
            retval = new COSArrayList(numbers, intArray);
        }
        return retval;
    }

    public static List<Float> convertFloatCOSArrayToList(COSArray floatArray) {
        if (Objects.nonNull(floatArray)) {
            ArrayList<Object> numbers = new ArrayList<Object>(floatArray.size());
            for (int i = 0; i < floatArray.size(); ++i) {
                numbers.add(Optional.ofNullable(floatArray.getObject(i)).filter(v -> v instanceof COSNumber).map(v -> Float.valueOf(((COSNumber)v).floatValue())).orElse(null));
            }
            return new COSArrayList<Float>(numbers, floatArray);
        }
        return null;
    }

    public static List<String> convertCOSNameCOSArrayToList(COSArray nameArray) {
        COSArrayList retval = null;
        if (nameArray != null) {
            ArrayList<String> names = new ArrayList<String>();
            for (int i = 0; i < nameArray.size(); ++i) {
                names.add(((COSName)nameArray.getObject(i)).getName());
            }
            retval = new COSArrayList(names, nameArray);
        }
        return retval;
    }

    public static List<String> convertCOSStringCOSArrayToList(COSArray stringArray) {
        COSArrayList retval = null;
        if (stringArray != null) {
            ArrayList<String> string = new ArrayList<String>();
            for (int i = 0; i < stringArray.size(); ++i) {
                string.add(((COSString)stringArray.getObject(i)).getString());
            }
            retval = new COSArrayList(string, stringArray);
        }
        return retval;
    }

    public static COSArray convertStringListToCOSNameCOSArray(List<String> strings) {
        COSArray retval = new COSArray();
        for (String string : strings) {
            retval.add(COSName.getPDFName(string));
        }
        return retval;
    }

    public static COSArray convertStringListToCOSStringCOSArray(List<String> strings) {
        COSArray retval = new COSArray();
        for (String string : strings) {
            retval.add(COSString.parseLiteral(string));
        }
        return retval;
    }

    public static COSArray converterToCOSArray(List<?> cosObjectableList) {
        if (cosObjectableList != null && !cosObjectableList.isEmpty()) {
            if (cosObjectableList instanceof COSArrayList) {
                return ((COSArrayList)cosObjectableList).array;
            }
            COSArray array = new COSArray();
            for (Object current : cosObjectableList) {
                if (current instanceof String) {
                    array.add(COSString.parseLiteral((String)current));
                    continue;
                }
                if (current instanceof Integer || current instanceof Long) {
                    array.add(COSInteger.get(((Number)current).longValue()));
                    continue;
                }
                if (current instanceof Float || current instanceof Double) {
                    array.add(new COSFloat(((Number)current).floatValue()));
                    continue;
                }
                if (current instanceof COSObjectable) {
                    array.add(((COSObjectable)current).getCOSObject());
                    continue;
                }
                if (current == null) {
                    array.add(COSNull.NULL);
                    continue;
                }
                throw new RuntimeException("Unable to convert '" + current.getClass().getName() + "' to COSBase ");
            }
            return array;
        }
        return null;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (this.isFiltered) {
            throw new UnsupportedOperationException("removing entries from a filtered List is not permitted");
        }
        boolean retval = false;
        for (Object o : c) {
            retval = retval || this.remove(o);
        }
        return retval;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (this.isFiltered) {
            throw new UnsupportedOperationException("removing entries from a filtered List is not permitted");
        }
        LinkedList<E> toRemove = new LinkedList<E>();
        for (E o : this.actual) {
            if (c.contains(o)) continue;
            toRemove.add(o);
        }
        return this.removeAll(toRemove);
    }

    @Override
    public void clear() {
        if (this.parentDict != null) {
            this.parentDict.setItem(this.dictKey, (COSBase)null);
        }
        this.actual.clear();
        this.array.clear();
    }

    @Override
    public boolean equals(Object o) {
        return this.actual.equals(o);
    }

    @Override
    public int hashCode() {
        return this.actual.hashCode();
    }

    @Override
    public E get(int index) {
        return this.actual.get(index);
    }

    @Override
    public E set(int index, E element) {
        if (element instanceof String) {
            COSString item = COSString.parseLiteral((String)element);
            if (this.parentDict != null && index == 0) {
                this.parentDict.setItem(this.dictKey, (COSBase)item);
            }
            this.array.set(index, item);
        } else {
            if (this.parentDict != null && index == 0) {
                this.parentDict.setItem(this.dictKey, ((COSObjectable)element).getCOSObject());
            }
            this.array.set(index, ((COSObjectable)element).getCOSObject());
        }
        return this.actual.set(index, element);
    }

    @Override
    public void add(int index, E element) {
        if (this.parentDict != null) {
            this.parentDict.setItem(this.dictKey, (COSBase)this.array);
            this.parentDict = null;
        }
        this.actual.add(index, element);
        if (element instanceof String) {
            this.array.add(index, COSString.parseLiteral((String)element));
        } else {
            this.array.add(index, ((COSObjectable)element).getCOSObject());
        }
    }

    @Override
    public E remove(int index) {
        if (this.isFiltered) {
            throw new UnsupportedOperationException("removing entries from a filtered List is not permitted");
        }
        this.array.remove(index);
        return this.actual.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.actual.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.actual.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.actual.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.actual.listIterator(index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.actual.subList(fromIndex, toIndex);
    }

    public String toString() {
        return "COSArrayList{" + this.array.toString() + "}";
    }

    public COSArray getCOSArray() {
        return this.array;
    }
}

