/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.input;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sejda.io.SeekableSource;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSBoolean;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSInteger;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSNull;
import org.sejda.sambox.cos.COSNumber;
import org.sejda.sambox.cos.COSStream;
import org.sejda.sambox.cos.COSString;
import org.sejda.sambox.input.SourceReader;
import org.sejda.sambox.util.CharUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseCOSParser
extends SourceReader {
    private static final Logger LOG = LoggerFactory.getLogger(BaseCOSParser.class);
    public static final String ENDOBJ = "endobj";
    public static final String OBJ = "obj";
    public static final String STREAM = "stream";
    public static final String ENDSTREAM = "endstream";

    BaseCOSParser(SeekableSource source) {
        super(source);
    }

    public abstract COSBase nextParsedToken() throws IOException;

    public COSDictionary nextDictionary() throws IOException {
        int c;
        this.skipExpected("<<");
        this.skipSpaces();
        COSDictionary dictionary = new COSDictionary();
        while ((c = this.source().peek()) != -1 && c != 62) {
            if (c != 47) {
                LOG.warn("Invalid dictionary key, expected '/' but was '" + (char)c + "' at " + this.position());
                if (!this.consumeInvalidDictionaryKey()) {
                    return dictionary;
                }
            } else {
                COSName key = this.nextName();
                COSBase value = this.nextParsedToken();
                if (value == null) {
                    LOG.warn("Bad dictionary declaration for key '{}'", (Object)key);
                } else {
                    dictionary.setItem(key, value);
                }
            }
            this.skipSpaces();
        }
        this.skipExpected(">>");
        return dictionary;
    }

    private boolean consumeInvalidDictionaryKey() throws IOException {
        int c;
        while ((c = this.source().peek()) != -1 && c != 62 && c != 47) {
            if (this.isNextToken(ENDOBJ, ENDSTREAM)) {
                LOG.warn("Found unexpected 'endobj or 'endstream' at position {}, assuming end of dictionary", (Object)this.position());
                return false;
            }
            this.source().read();
        }
        return c != -1;
    }

    public COSArray nextArray() throws IOException {
        int c;
        this.skipExpected('[');
        COSArray array = new COSArray();
        this.skipSpaces();
        while ((c = this.source().peek()) != -1 && c != 93) {
            long position = this.position();
            COSBase item = this.nextParsedToken();
            if (item != null) {
                array.add(item);
            } else {
                if (this.isNextToken(ENDOBJ, ENDSTREAM)) {
                    LOG.warn("Found unexpected 'endobj or 'endstream' at position {}, assuming end of array", (Object)position);
                    return array;
                }
                if (this.isNextToken(OBJ) && array.size() >= 2 && array.getObject(array.size() - 1) instanceof COSInteger && array.getObject(array.size() - 2) instanceof COSInteger) {
                    this.unreadSpaces();
                    this.unreadUntilSpaces();
                    this.unreadSpaces();
                    this.unreadUntilSpaces();
                    array.removeLast();
                    array.removeLast();
                    LOG.warn("Found unexpected object definition at position {}, assuming end of array", (Object)position);
                    return array;
                }
                LOG.warn("Found invalid token while parsing array at {}", (Object)position);
            }
            this.skipSpaces();
        }
        this.skipExpected(']');
        return array;
    }

    public COSBoolean nextBoolean() throws IOException {
        char c = (char)this.source().peek();
        if (c == 't') {
            this.skipExpected(Boolean.TRUE.toString());
            return COSBoolean.TRUE;
        }
        this.skipExpected(Boolean.FALSE.toString());
        return COSBoolean.FALSE;
    }

    public COSNumber nextNumber() throws IOException {
        return COSNumber.get(this.readNumber());
    }

    public COSNull nextNull() throws IOException {
        this.skipExpected("null");
        return COSNull.NULL;
    }

    public COSName nextName() throws IOException {
        return COSName.getPDFName(this.readName());
    }

    public COSString nextLiteralString() throws IOException {
        return COSString.newInstance(this.readLiteralString().getBytes(StandardCharsets.ISO_8859_1));
    }

    public COSString nextHexadecimalString() throws IOException {
        return COSString.parseHex(this.readHexString());
    }

    public COSString nextString() throws IOException {
        char next = (char)this.source().peek();
        switch (next) {
            case '(': {
                return this.nextLiteralString();
            }
            case '<': {
                return this.nextHexadecimalString();
            }
        }
        throw new IOException(String.format("Expected '(' or '<' at offset %d but was '%c'", this.position(), Character.valueOf(next)));
    }

    public COSStream nextStream(COSDictionary streamDictionary) throws IOException {
        long length;
        this.skipSpaces();
        this.skipExpected(STREAM);
        int c = this.source().read();
        while (CharUtils.isSpace(c)) {
            LOG.warn("Found unexpected space character after 'stream' keyword");
            c = this.source().read();
        }
        if (CharUtils.isCarriageReturn(c)) {
            c = this.source().read();
            if (!CharUtils.isLineFeed(c)) {
                this.source().back();
                LOG.warn("Couldn't find expected LF following CR after 'stream' keyword at " + this.position());
            }
        } else if (!CharUtils.isLineFeed(c)) {
            this.source().back();
        }
        COSStream stream = (length = this.streamLength(streamDictionary)) > 0L ? new COSStream(streamDictionary, this.source(), this.position(), length) : new COSStream(streamDictionary);
        this.source().forward(stream.getFilteredLength());
        if (!this.skipTokenIfValue(ENDSTREAM) && this.isNextToken(ENDOBJ)) {
            LOG.warn("Expected 'endstream' at " + this.position() + " but was 'endobj'");
        }
        return stream;
    }

    private long streamLength(COSDictionary streamDictionary) throws IOException {
        long length = this.streamLengthFrom(streamDictionary);
        if (length <= 0L) {
            LOG.info("Using fallback strategy reading until 'endstream' or 'endobj' is found. Starting at offset " + this.position());
            length = this.findStreamLength();
        }
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long streamLengthFrom(COSDictionary streamDictionary) throws IOException {
        long start = this.position();
        COSBase lengthBaseObj = streamDictionary.getItem(COSName.LENGTH);
        try {
            long l = this.doStreamLengthFrom(lengthBaseObj);
            return l;
        }
        finally {
            this.position(start);
        }
    }

    private long doStreamLengthFrom(COSBase lengthBaseObj) throws IOException {
        long startingOffset = this.position();
        if (lengthBaseObj == null) {
            LOG.warn("Invalid stream length. No length provided");
            return -1L;
        }
        COSBase retVal = lengthBaseObj.getCOSObject();
        if (!(retVal instanceof COSNumber)) {
            LOG.warn("Invalid stream length. Expected number instance but was " + retVal.getClass().getSimpleName());
            return -1L;
        }
        long length = ((COSNumber)retVal).longValue();
        long endStreamOffset = startingOffset + length;
        if (endStreamOffset > this.length()) {
            LOG.warn("Invalid stream length. Out of range");
            return -1L;
        }
        this.position(endStreamOffset);
        if (!this.isNextToken(ENDSTREAM)) {
            LOG.warn("Invalid stream length. Expected 'endstream' at " + endStreamOffset);
            return -1L;
        }
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long findStreamLength() throws IOException {
        long start = this.position();
        try {
            long l = this.doFindStreamLength(start);
            return l;
        }
        finally {
            this.position(start);
        }
    }

    private long doFindStreamLength(long start) throws IOException {
        long currentPosition;
        String currentLine;
        Matcher matcher;
        Pattern pattern = Pattern.compile("endstream|endobj");
        do {
            currentPosition = this.position();
        } while (!(matcher = pattern.matcher(currentLine = this.readLine())).find());
        this.position(currentPosition + (long)matcher.start());
        long length = this.position() - start;
        int prevChar = this.source().back().peek();
        if (CharUtils.isCarriageReturn(prevChar)) {
            return length - 1L;
        }
        if (CharUtils.isLineFeed(prevChar)) {
            prevChar = this.source().back().peek();
            if (CharUtils.isCarriageReturn(prevChar)) {
                return length - 2L;
            }
            return length - 1L;
        }
        return length;
    }
}

