/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.input;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.sejda.commons.FastByteArrayOutputStream;
import org.sejda.commons.util.IOUtils;
import org.sejda.io.SeekableSource;
import org.sejda.io.SeekableSources;
import org.sejda.sambox.contentstream.PDContentStream;
import org.sejda.sambox.contentstream.operator.Operator;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.input.ContentStreamCOSParser;
import org.sejda.sambox.input.SourceReader;
import org.sejda.sambox.util.CharUtils;

public class ContentStreamParser
extends SourceReader {
    private ContentStreamCOSParser cosParser;
    private List<Object> tokens = new ArrayList<Object>();

    public ContentStreamParser(PDContentStream stream) throws IOException {
        this(SeekableSources.inMemorySeekableSourceFrom((InputStream)stream.getContents()));
    }

    public ContentStreamParser(SeekableSource source) {
        super(source);
        this.cosParser = new ContentStreamCOSParser(this.source());
    }

    public List<Object> tokens() throws IOException {
        Object token;
        this.tokens.clear();
        while ((token = this.nextParsedToken()) != null) {
            this.tokens.add(token);
        }
        return Collections.unmodifiableList(this.tokens);
    }

    public Object nextParsedToken() throws IOException {
        this.skipSpaces();
        long pos = this.position();
        COSBase token = this.cosParser.nextParsedToken();
        if (token != null) {
            return token;
        }
        this.position(pos);
        return this.nextOperator();
    }

    private Object nextOperator() throws IOException {
        if ('B' == (char)this.source().peek()) {
            Operator operator = Operator.getOperator(this.readToken());
            if ("BI".equals(operator.getName())) {
                this.nextInlineImage(operator);
            }
            return operator;
        }
        return Optional.ofNullable(this.readToken()).filter(s -> s.length() > 0).map(Operator::getOperator).orElse(null);
    }

    private void nextInlineImage(Operator operator) throws IOException {
        COSDictionary imageParams = new COSDictionary();
        operator.setImageParameters(imageParams);
        COSBase nextToken = null;
        long position = this.position();
        while ((nextToken = this.cosParser.nextParsedToken()) instanceof COSName) {
            imageParams.setItem((COSName)nextToken, this.cosParser.nextParsedToken());
            position = this.position();
        }
        this.position(position);
        operator.setImageData(this.nextImageData());
    }

    private byte[] nextImageData() throws IOException {
        this.skipSpaces();
        this.skipExpected("ID");
        if (!CharUtils.isWhitespace(this.source().read())) {
            this.source().back();
        }
        try (FastByteArrayOutputStream imageData = new FastByteArrayOutputStream();){
            int current;
            while ((current = this.source().read()) != -1) {
                long position = this.source().position();
                if (current == 69 && this.isEndOfImageFrom(position - 1L) || CharUtils.isWhitespace(current) && this.isEndOfImageFrom(position)) break;
                imageData.write(current);
            }
            byte[] byArray = imageData.toByteArray();
            return byArray;
        }
    }

    private boolean isEndOfImageFrom(long position) throws IOException {
        long currentPosition = this.source().position();
        this.source().position(position);
        int current = this.source().read();
        if (current == 69 && (current = this.source().read()) == 73 && (this.isEndOfImage() || CharUtils.isEOF(this.source().peek()))) {
            return true;
        }
        this.source().position(currentPosition);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEndOfImage() throws IOException {
        long currentPosition = this.source().position();
        try {
            int current = this.source().read();
            if (CharUtils.isSpace(current) || CharUtils.isEOL(current)) {
                for (int i = 0; i < 10; ++i) {
                    current = this.source().read();
                    if (CharUtils.isNul(current) && !CharUtils.isNul(this.source().peek()) || CharUtils.isEOF(current) || CharUtils.isEOL(current) || current >= 32 && current <= 127) continue;
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.source().position(currentPosition);
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        IOUtils.closeQuietly((Closeable)this.cosParser);
    }
}

