/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.output;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import org.sejda.commons.util.IOUtils;
import org.sejda.io.CountingWritableByteChannel;
import org.sejda.io.DevNullWritableByteChannel;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSObjectable;
import org.sejda.sambox.cos.COSStream;
import org.sejda.sambox.cos.IndirectCOSObjectReference;
import org.sejda.sambox.output.IndirectObjectsWriter;
import org.sejda.sambox.output.PDFBodyObjectsWriter;
import org.sejda.sambox.output.PDFBodyWriter;
import org.sejda.sambox.output.PDFWriteContext;
import org.sejda.sambox.output.WriteOption;
import org.sejda.sambox.pdmodel.PDPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExistingPagesSizePredictor
extends PDFBodyWriter {
    private static final Logger LOG = LoggerFactory.getLogger(ExistingPagesSizePredictor.class);
    private static final int STREAM_WRAPPING_SIZE = 19;
    private CountingWritableByteChannel channel;
    private IndirectObjectsWriter writer;
    private long pages;

    private ExistingPagesSizePredictor(PDFWriteContext context, IndirectObjectsWriter writer, CountingWritableByteChannel channel) {
        super(context, new BodyObjectsWriter(context, writer));
        this.channel = channel;
        this.writer = writer;
    }

    public void addPage(PDPage page) throws IOException {
        if (page != null) {
            ++this.pages;
            COSDictionary pageCopy = page.getCOSObject().duplicate();
            pageCopy.removeItem(COSName.PARENT);
            this.createIndirectReferenceIfNeededFor(pageCopy);
            this.startWriting();
            LOG.debug("Page {} addition simulated, now at {} body bytes and {} xref bytes", new Object[]{page, this.predictedPagesSize(), this.predictedXrefTableSize()});
        }
    }

    public void addIndirectReferenceFor(COSObjectable value) throws IOException {
        if (value != null) {
            this.createIndirectReferenceIfNeededFor(value.getCOSObject());
            this.startWriting();
            LOG.debug("{} addition simulated, now at {} body bytes and {} xref bytes", new Object[]{value.getCOSObject(), this.predictedPagesSize(), this.predictedXrefTableSize()});
        }
    }

    public long predictedPagesSize() throws IOException {
        this.writer.writer().writer().flush();
        return ((BodyObjectsWriter)this.objectsWriter).streamsSize + this.channel.count();
    }

    public long predictedXrefTableSize() {
        return 21 * (this.context().written() + 1) + 10;
    }

    public boolean hasPages() {
        return this.pages > 0L;
    }

    public long pages() {
        return this.pages;
    }

    @Override
    public void close() throws IOException {
        super.close();
        IOUtils.close((Closeable)this.writer);
    }

    public static ExistingPagesSizePredictor instance(WriteOption ... opts) {
        CountingWritableByteChannel channel = CountingWritableByteChannel.from((WritableByteChannel)new DevNullWritableByteChannel());
        PDFWriteContext context = new PDFWriteContext(null, opts);
        IndirectObjectsWriter writer = new IndirectObjectsWriter(channel, context){

            @Override
            protected void onWritten(IndirectCOSObjectReference ref) {
            }
        };
        return new ExistingPagesSizePredictor(context, writer, channel);
    }

    private static class BodyObjectsWriter
    implements PDFBodyObjectsWriter {
        long streamsSize;
        private PDFWriteContext context;
        private IndirectObjectsWriter writer;

        public BodyObjectsWriter(PDFWriteContext context, IndirectObjectsWriter writer) {
            this.context = context;
            this.writer = writer;
        }

        @Override
        public void writeObject(IndirectCOSObjectReference ref) throws IOException {
            COSBase wrapped;
            if (!this.context.hasWritten(ref.xrefEntry()) && (wrapped = ref.getCOSObject().getCOSObject()) instanceof COSStream) {
                COSStream stream = (COSStream)wrapped;
                this.streamsSize += stream.getFilteredLength();
                this.streamsSize += 19L;
                ref.setValue(stream.duplicate());
            }
            this.writer.writeObject(ref);
        }

        @Override
        public void onWriteCompletion() {
        }

        @Override
        public void close() {
        }
    }
}

