/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.output;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSInteger;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSStream;
import org.sejda.sambox.cos.DirectCOSObject;
import org.sejda.sambox.output.PDFWriteContext;
import org.sejda.sambox.xref.XrefEntry;

class XrefStream
extends COSStream {
    XrefStream(COSDictionary dictionary, PDFWriteContext context) throws IOException {
        super(dictionary);
        this.setItem(COSName.TYPE, (COSBase)COSName.XREF);
        this.setItem(COSName.SIZE, (COSBase)XrefStream.asDirect(context.highestObjectNumber() + 1L));
        COSArray index = new COSArray();
        for (List<Long> continuos : context.getWrittenContiguousGroups()) {
            index.add(XrefStream.asDirect(continuos.get(0)));
            index.add(XrefStream.asDirect(continuos.size()));
        }
        this.setItem(COSName.INDEX, (COSBase)DirectCOSObject.asDirectObject(index));
        int secondFieldLength = XrefStream.sizeOf(context.highestWritten().getByteOffset());
        this.setItem(COSName.W, (COSBase)DirectCOSObject.asDirectObject(new COSArray(XrefStream.asDirect(1L), XrefStream.asDirect(secondFieldLength), XrefStream.asDirect(2L))));
        try (OutputStream out = this.createUnfilteredStream();){
            for (List<Long> continuos : context.getWrittenContiguousGroups()) {
                for (long key : continuos) {
                    out.write(Optional.ofNullable(context.getWritten(key)).orElse(XrefEntry.freeEntry(key, 0)).toXrefStreamEntry(secondFieldLength, 2));
                }
            }
        }
        this.setItem(COSName.DL, (COSBase)XrefStream.asDirect(this.getUnfilteredLength()));
        this.setItem(COSName.FILTER, (COSBase)DirectCOSObject.asDirectObject(COSName.FLATE_DECODE));
    }

    private static DirectCOSObject asDirect(long num) {
        return DirectCOSObject.asDirectObject(COSInteger.get(num));
    }

    @Override
    public boolean encryptable() {
        return false;
    }

    @Override
    public void encryptable(boolean encryptable) {
    }

    @Override
    public void setEncryptor(Function<InputStream, InputStream> encryptor) {
    }

    private static int sizeOf(long number) {
        int size = 0;
        while (number > 0L) {
            ++size;
            number >>= 8;
        }
        return size;
    }
}

