/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel;

import java.awt.Point;
import java.awt.image.Raster;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.sejda.commons.util.IOUtils;
import org.sejda.commons.util.RequireUtils;
import org.sejda.io.CountingWritableByteChannel;
import org.sejda.io.SeekableSources;
import org.sejda.sambox.SAMBox;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSDocument;
import org.sejda.sambox.cos.COSInteger;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSNumber;
import org.sejda.sambox.cos.COSString;
import org.sejda.sambox.cos.DirectCOSObject;
import org.sejda.sambox.encryption.EncryptionContext;
import org.sejda.sambox.encryption.MessageDigests;
import org.sejda.sambox.encryption.StandardSecurity;
import org.sejda.sambox.input.PDFParser;
import org.sejda.sambox.output.PDDocumentWriter;
import org.sejda.sambox.output.WriteOption;
import org.sejda.sambox.pdmodel.DefaultResourceCache;
import org.sejda.sambox.pdmodel.PDDocumentCatalog;
import org.sejda.sambox.pdmodel.PDDocumentInformation;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.PDPageTree;
import org.sejda.sambox.pdmodel.ResourceCache;
import org.sejda.sambox.pdmodel.common.PDStream;
import org.sejda.sambox.pdmodel.encryption.AccessPermission;
import org.sejda.sambox.pdmodel.encryption.PDEncryption;
import org.sejda.sambox.pdmodel.encryption.SecurityHandler;
import org.sejda.sambox.pdmodel.font.Subsettable;
import org.sejda.sambox.pdmodel.graphics.color.PDDeviceRGB;
import org.sejda.sambox.util.SpecVersionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDDocument
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(PDDocument.class);
    private final COSDocument document;
    private PDDocumentCatalog documentCatalog;
    private SecurityHandler securityHandler;
    private boolean open = true;
    private OnClose onClose = () -> LOG.debug("Closing document");
    private OnBeforeWrite onBeforeWrite = () -> LOG.trace("About to write document");
    private ResourceCache resourceCache = new DefaultResourceCache();
    private final Set<Subsettable> fontsToSubset = new HashSet<Subsettable>();

    public PDDocument() {
        this.document = new COSDocument();
        this.document.getCatalog().setItem(COSName.VERSION, (COSBase)COSName.getPDFName("1.4"));
        COSDictionary pages = new COSDictionary();
        this.document.getCatalog().setItem(COSName.PAGES, (COSBase)pages);
        pages.setItem(COSName.TYPE, (COSBase)COSName.PAGES);
        pages.setItem(COSName.KIDS, (COSBase)new COSArray());
        pages.setItem(COSName.COUNT, (COSBase)COSInteger.ZERO);
    }

    public PDDocument(COSDocument document) {
        this(document, null);
    }

    public PDDocument(COSDocument document, SecurityHandler securityHandler) {
        this.document = document;
        this.securityHandler = securityHandler;
    }

    public void addPage(PDPage page) {
        this.requireOpen();
        this.getPages().add(page);
    }

    public void removePage(PDPage page) {
        this.requireOpen();
        this.getPages().remove(page);
    }

    public void removePage(int pageNumber) {
        this.requireOpen();
        this.getPages().remove(pageNumber);
    }

    public PDPage importPage(PDPage page) {
        this.requireOpen();
        PDPage importedPage = new PDPage(page.getCOSObject().duplicate());
        InputStream in = null;
        try {
            in = page.getContents();
            if (in != null) {
                PDStream dest = new PDStream(in, COSName.FLATE_DECODE);
                importedPage.setContents(dest);
            }
            this.addPage(importedPage);
        }
        catch (IOException e) {
            IOUtils.closeQuietly((Closeable)in);
        }
        return importedPage;
    }

    public COSDocument getDocument() {
        return this.document;
    }

    public PDDocumentInformation getDocumentInformation() {
        COSDictionary infoDic = this.document.getTrailer().getCOSObject().getDictionaryObject(COSName.INFO, COSDictionary.class);
        if (infoDic == null) {
            infoDic = new COSDictionary();
            this.document.getTrailer().getCOSObject().setItem(COSName.INFO, (COSBase)infoDic);
        }
        return new PDDocumentInformation(infoDic);
    }

    public void setDocumentInformation(PDDocumentInformation documentInformation) {
        this.requireOpen();
        this.document.getTrailer().getCOSObject().setItem(COSName.INFO, (COSBase)documentInformation.getCOSObject());
    }

    public PDDocumentCatalog getDocumentCatalog() {
        if (this.documentCatalog == null) {
            this.documentCatalog = new PDDocumentCatalog(this, this.document.getCatalog());
        }
        return this.documentCatalog;
    }

    public boolean isEncrypted() {
        return this.document.isEncrypted();
    }

    public PDEncryption getEncryption() {
        if (this.isEncrypted()) {
            return new PDEncryption(this.document.getEncryptionDictionary());
        }
        return new PDEncryption();
    }

    public void registerTrueTypeFontForClosing(TrueTypeFont ttf) {
        this.onClose.andThen(() -> IOUtils.closeQuietly((Closeable)ttf));
    }

    public Set<Subsettable> getFontsToSubset() {
        return this.fontsToSubset;
    }

    public PDPage getPage(int pageIndex) {
        return this.getDocumentCatalog().getPages().get(pageIndex);
    }

    public PDPageTree getPages() {
        return this.getDocumentCatalog().getPages();
    }

    public int getNumberOfPages() {
        return this.getDocumentCatalog().getPages().getCount();
    }

    public AccessPermission getCurrentAccessPermission() {
        return Optional.ofNullable(this.securityHandler).map(s -> s.getCurrentAccessPermission()).orElseGet(AccessPermission::getOwnerAccessPermission);
    }

    public SecurityHandler getSecurityHandler() {
        return this.securityHandler;
    }

    public String getVersion() {
        String headerVersion = this.getDocument().getHeaderVersion();
        if (SpecVersionUtils.isAtLeast(headerVersion, "1.4")) {
            return Optional.ofNullable(this.getDocumentCatalog().getVersion()).filter(catalogVersion -> catalogVersion.compareTo(headerVersion) > 0).orElse(headerVersion);
        }
        return headerVersion;
    }

    public void setVersion(String newVersion) {
        this.requireOpen();
        RequireUtils.requireNotBlank((String)newVersion, (String)"Spec version cannot be blank");
        int compare = this.getVersion().compareTo(newVersion);
        if (compare > 0) {
            LOG.info("Spec version downgrade not allowed");
        } else if (compare < 0) {
            if (SpecVersionUtils.isAtLeast(newVersion, "1.4")) {
                this.getDocumentCatalog().setVersion(newVersion);
            }
            this.getDocument().setHeaderVersion(newVersion);
        }
    }

    public void requireMinVersion(String version) {
        if (!SpecVersionUtils.isAtLeast(this.getVersion(), version)) {
            LOG.debug("Minimum spec version required is {}", (Object)version);
            this.setVersion(version);
        }
    }

    public void setOnCloseAction(OnClose onClose) {
        this.requireOpen();
        this.onClose = onClose.andThen(this.onClose);
    }

    public void setOnBeforeWriteAction(OnBeforeWrite onBeforeWrite) {
        this.requireOpen();
        this.onBeforeWrite = onBeforeWrite.andThen(this.onBeforeWrite);
    }

    private void requireOpen() throws IllegalStateException {
        if (!this.isOpen()) {
            throw new IllegalStateException("The document is closed");
        }
    }

    private void generateFileIdentifier(byte[] md5Update, Optional<EncryptionContext> encContext) {
        COSString id = this.generateFileIdentifier(md5Update);
        encContext.ifPresent(c -> c.documentId(id.getBytes()));
        DirectCOSObject directId = DirectCOSObject.asDirectObject(id);
        this.getDocument().getTrailer().getCOSObject().setItem(COSName.ID, (COSBase)DirectCOSObject.asDirectObject(new COSArray(directId, directId)));
    }

    public COSString generateFileIdentifier(byte[] md5Update) {
        MessageDigest md5 = MessageDigests.md5();
        md5.update(Long.toString(System.currentTimeMillis()).getBytes(StandardCharsets.ISO_8859_1));
        md5.update(md5Update);
        Optional.ofNullable(this.getDocument().getTrailer().getCOSObject().getDictionaryObject(COSName.INFO, COSDictionary.class)).ifPresent(d -> {
            for (COSBase current : d.getValues()) {
                md5.update(current.toString().getBytes(StandardCharsets.ISO_8859_1));
            }
        });
        COSString retVal = COSString.newInstance(md5.digest());
        retVal.setForceHexForm(true);
        retVal.encryptable(false);
        return retVal;
    }

    public void writeTo(File file, WriteOption ... options) throws IOException {
        this.writeTo(CountingWritableByteChannel.from((File)file), null, options);
    }

    public void writeTo(String filename, WriteOption ... options) throws IOException {
        this.writeTo(CountingWritableByteChannel.from((String)filename), null, options);
    }

    public void writeTo(WritableByteChannel channel, WriteOption ... options) throws IOException {
        this.writeTo(CountingWritableByteChannel.from((WritableByteChannel)channel), null, options);
    }

    public void writeTo(OutputStream out, WriteOption ... options) throws IOException {
        this.writeTo(CountingWritableByteChannel.from((OutputStream)out), null, options);
    }

    public void writeTo(File file, StandardSecurity security, WriteOption ... options) throws IOException {
        this.writeTo(CountingWritableByteChannel.from((File)file), security, options);
    }

    public void writeTo(String filename, StandardSecurity security, WriteOption ... options) throws IOException {
        this.writeTo(CountingWritableByteChannel.from((String)filename), security, options);
    }

    public void writeTo(WritableByteChannel channel, StandardSecurity security, WriteOption ... options) throws IOException {
        this.writeTo(CountingWritableByteChannel.from((WritableByteChannel)channel), security, options);
    }

    public void writeTo(OutputStream out, StandardSecurity security, WriteOption ... options) throws IOException {
        this.writeTo(CountingWritableByteChannel.from((OutputStream)out), security, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTo(CountingWritableByteChannel output, StandardSecurity security, WriteOption ... options) throws IOException {
        this.requireOpen();
        if (!Arrays.stream(options).anyMatch(i -> i == WriteOption.NO_METADATA_PRODUCER_MODIFIED_DATE_UPDATE)) {
            this.getDocumentInformation().setProducer(SAMBox.PRODUCER);
            this.getDocumentInformation().setModificationDate(Calendar.getInstance());
        }
        for (Subsettable font : this.fontsToSubset) {
            try {
                font.subset();
            }
            catch (Exception e) {
                LOG.warn("Exception occurred while subsetting font: " + font, (Throwable)e);
            }
        }
        this.fontsToSubset.clear();
        Optional<Object> encryptionContext = Optional.ofNullable(Optional.ofNullable(security).map(EncryptionContext::new).orElse(null));
        this.generateFileIdentifier(output.toString().getBytes(StandardCharsets.ISO_8859_1), encryptionContext);
        try (PDDocumentWriter writer = new PDDocumentWriter(output, encryptionContext, options);){
            this.onBeforeWrite.onBeforeWrite();
            writer.write(this);
        }
        finally {
            IOUtils.close((Closeable)this);
        }
    }

    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() throws IOException {
        if (this.isOpen()) {
            this.onClose.onClose();
            this.resourceCache.clear();
            this.open = false;
        }
    }

    public ResourceCache getResourceCache() {
        return this.resourceCache;
    }

    public static PDDocument load(File file) throws IOException {
        return PDFParser.parse(SeekableSources.seekableSourceFrom((File)file));
    }

    static {
        try {
            PDDeviceRGB.INSTANCE.toRGBImage(Raster.createBandedRaster(0, 1, 1, 3, new Point(0, 0)));
        }
        catch (IOException e) {
            LOG.warn("This shouldn't happen", (Throwable)e);
        }
        try {
            COSNumber.get("0");
            COSNumber.get("1");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @FunctionalInterface
    public static interface OnBeforeWrite {
        public void onBeforeWrite() throws IOException;

        default public OnBeforeWrite andThen(OnBeforeWrite after) {
            Objects.requireNonNull(after);
            return () -> {
                this.onBeforeWrite();
                after.onBeforeWrite();
            };
        }
    }

    @FunctionalInterface
    public static interface OnClose {
        public void onClose() throws IOException;

        default public OnClose andThen(OnClose after) {
            Objects.requireNonNull(after);
            return () -> {
                this.onClose();
                after.onClose();
            };
        }
    }
}

