/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.graphics.color;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.pdmodel.graphics.color.PDColor;
import org.sejda.sambox.pdmodel.graphics.color.PDColorSpace;
import org.sejda.sambox.pdmodel.graphics.color.PDDeviceColorSpace;

public final class PDDeviceRGB
extends PDDeviceColorSpace {
    public static final PDDeviceRGB INSTANCE = new PDDeviceRGB();
    private final PDColor initialColor = new PDColor(new float[]{0.0f, 0.0f, 0.0f}, (PDColorSpace)this);
    private volatile ColorSpace awtColorSpace;

    private PDDeviceRGB() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        if (this.awtColorSpace != null) {
            return;
        }
        PDDeviceRGB pDDeviceRGB = this;
        synchronized (pDDeviceRGB) {
            if (this.awtColorSpace != null) {
                return;
            }
            this.awtColorSpace = ColorSpace.getInstance(1000);
            this.awtColorSpace.toRGB(new float[]{0.0f, 0.0f, 0.0f, 0.0f});
        }
    }

    @Override
    public String getName() {
        return COSName.DEVICERGB.getName();
    }

    @Override
    public int getNumberOfComponents() {
        return 3;
    }

    @Override
    public float[] getDefaultDecode(int bitsPerComponent) {
        return new float[]{0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f};
    }

    @Override
    public PDColor getInitialColor() {
        return this.initialColor;
    }

    @Override
    public float[] toRGB(float[] value) {
        return value;
    }

    @Override
    public BufferedImage toRGBImage(WritableRaster raster) throws IOException {
        this.init();
        BufferedImage image = new BufferedImage(raster.getWidth(), raster.getHeight(), 1);
        image.setData(raster);
        return image;
    }
}

