/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.graphics.image;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.sejda.commons.FastByteArrayOutputStream;
import org.sejda.io.SeekableSource;
import org.sejda.io.SeekableSources;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSStream;
import org.sejda.sambox.filter.Filter;
import org.sejda.sambox.filter.FilterFactory;
import org.sejda.sambox.pdmodel.graphics.color.PDColorSpace;
import org.sejda.sambox.pdmodel.graphics.color.PDDeviceGray;
import org.sejda.sambox.pdmodel.graphics.image.PDImageXObject;
import org.sejda.sambox.pdmodel.graphics.image.UnsupportedTiffImageException;

public final class CCITTFactory {
    private CCITTFactory() {
    }

    public static PDImageXObject createFromImage(BufferedImage image) throws IOException {
        if (image.getType() != 12 && image.getColorModel().getPixelSize() != 1) {
            throw new IllegalArgumentException("Only 1-bit b/w images supported");
        }
        int height = image.getHeight();
        int width = image.getWidth();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (MemoryCacheImageOutputStream mcios = new MemoryCacheImageOutputStream(bos);){
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    mcios.writeBits(~(image.getRGB(x, y) & 1), 1);
                }
                if (mcios.getBitOffset() == 0) continue;
                mcios.writeBits(0L, 8 - mcios.getBitOffset());
            }
            mcios.flush();
        }
        return CCITTFactory.prepareImageXObject(bos.toByteArray(), width, height, PDDeviceGray.INSTANCE);
    }

    private static PDImageXObject prepareImageXObject(byte[] byteArray, int width, int height, PDColorSpace initColorSpace) throws IOException {
        FastByteArrayOutputStream baos = new FastByteArrayOutputStream();
        Filter filter = FilterFactory.INSTANCE.getFilter(COSName.CCITTFAX_DECODE);
        COSDictionary dict = new COSDictionary();
        dict.setInt(COSName.COLUMNS, width);
        dict.setInt(COSName.ROWS, height);
        filter.encode(new ByteArrayInputStream(byteArray), (OutputStream)baos, dict);
        ByteArrayInputStream encodedByteStream = new ByteArrayInputStream(baos.toByteArray());
        PDImageXObject image = new PDImageXObject(encodedByteStream, COSName.CCITTFAX_DECODE, width, height, 1, initColorSpace);
        dict.setInt(COSName.K, -1);
        image.getCOSObject().setItem(COSName.DECODE_PARMS, (COSBase)dict);
        return image;
    }

    public static PDImageXObject createFromFile(File file) throws IOException {
        return CCITTFactory.createFromFile(file, 0);
    }

    public static PDImageXObject createFromFile(File file, int number) throws IOException {
        try (SeekableSource source = SeekableSources.seekableSourceFrom((File)file);){
            PDImageXObject pDImageXObject = CCITTFactory.createFromRandomAccessImpl(source, number);
            return pDImageXObject;
        }
    }

    public static PDImageXObject createFromSeekableSource(SeekableSource source) throws IOException {
        return CCITTFactory.createFromRandomAccessImpl(source, 0);
    }

    public static PDImageXObject createFromSeekableSource(SeekableSource source, int number) throws IOException {
        return CCITTFactory.createFromRandomAccessImpl(source, number);
    }

    private static PDImageXObject createFromRandomAccessImpl(SeekableSource source, int number) throws IOException {
        COSDictionary decodeParms = new COSDictionary();
        SeekableSource tiffView = CCITTFactory.extractFromTiff(source, decodeParms, number);
        if (tiffView != null) {
            PDImageXObject pdImage = new PDImageXObject(tiffView.asInputStream(), COSName.CCITTFAX_DECODE, decodeParms.getInt(COSName.COLUMNS), decodeParms.getInt(COSName.ROWS), 1, PDDeviceGray.INSTANCE);
            COSStream dict = pdImage.getCOSObject();
            dict.setItem(COSName.DECODE_PARMS, (COSBase)decodeParms);
            return pdImage;
        }
        return null;
    }

    private static SeekableSource extractFromTiff(SeekableSource source, COSDictionary params, int number) throws IOException {
        source.position(0L);
        char endianess = (char)source.read();
        if ((char)source.read() != endianess) {
            throw new IOException("Not a valid tiff file");
        }
        if (endianess != 'M' && endianess != 'I') {
            throw new IOException("Not a valid tiff file");
        }
        int magicNumber = CCITTFactory.readshort(endianess, source);
        if (magicNumber != 42) {
            throw new IOException("Not a valid tiff file");
        }
        int address = CCITTFactory.readlong(endianess, source);
        source.position((long)address);
        for (int i = 0; i < number; ++i) {
            int numtags = CCITTFactory.readshort(endianess, source);
            if (numtags > 50) {
                throw new IOException("Not a valid tiff file");
            }
            source.position((long)(address + 2 + numtags * 12));
            address = CCITTFactory.readlong(endianess, source);
            if (address == 0) {
                return null;
            }
            source.position((long)address);
        }
        int numtags = CCITTFactory.readshort(endianess, source);
        if (numtags > 50) {
            throw new IOException("Not a valid tiff file");
        }
        int k = -1000;
        int dataoffset = 0;
        int datalength = 0;
        block18: for (int i = 0; i < numtags; ++i) {
            int val;
            int tag = CCITTFactory.readshort(endianess, source);
            int type = CCITTFactory.readshort(endianess, source);
            int count = CCITTFactory.readlong(endianess, source);
            switch (type) {
                case 1: {
                    val = source.read();
                    source.read();
                    source.read();
                    source.read();
                    break;
                }
                case 3: {
                    val = CCITTFactory.readshort(endianess, source);
                    source.read();
                    source.read();
                    break;
                }
                default: {
                    val = CCITTFactory.readlong(endianess, source);
                }
            }
            switch (tag) {
                case 256: {
                    params.setInt(COSName.COLUMNS, val);
                    continue block18;
                }
                case 257: {
                    params.setInt(COSName.ROWS, val);
                    continue block18;
                }
                case 259: {
                    if (val == 4) {
                        k = -1;
                    }
                    if (val != 3) continue block18;
                    k = 0;
                    continue block18;
                }
                case 262: {
                    if (val != 1) continue block18;
                    params.setBoolean(COSName.BLACK_IS_1, true);
                    continue block18;
                }
                case 266: {
                    if (val == 1) continue block18;
                    throw new UnsupportedTiffImageException("FillOrder " + val + " is not supported");
                }
                case 273: {
                    if (count != 1) continue block18;
                    dataoffset = val;
                    continue block18;
                }
                case 274: {
                    if (val == 1) continue block18;
                    throw new UnsupportedTiffImageException("Orientation " + val + " is not supported");
                }
                case 279: {
                    if (count != 1) continue block18;
                    datalength = val;
                    continue block18;
                }
                case 292: {
                    if ((val & 1) != 0) {
                        k = 50;
                    }
                    if ((val & 4) != 0) {
                        throw new UnsupportedTiffImageException("CCITT Group 3 'uncompressed mode' is not supported");
                    }
                    if ((val & 2) == 0) continue block18;
                    throw new UnsupportedTiffImageException("CCITT Group 3 'fill bits before EOL' is not supported");
                }
                case 324: {
                    if (count != 1) continue block18;
                    dataoffset = val;
                    continue block18;
                }
                case 325: {
                    if (count != 1) continue block18;
                    datalength = val;
                    continue block18;
                }
            }
        }
        if (k == -1000) {
            throw new UnsupportedTiffImageException("First image in tiff is not CCITT T4 or T6 compressed");
        }
        if (dataoffset == 0) {
            throw new UnsupportedTiffImageException("First image in tiff is not a single tile/strip");
        }
        params.setInt(COSName.K, k);
        source.position((long)dataoffset);
        return source.view((long)dataoffset, (long)datalength);
    }

    private static int readshort(char endianess, SeekableSource source) throws IOException {
        if (endianess == 'I') {
            return source.read() | source.read() << 8;
        }
        return source.read() << 8 | source.read();
    }

    private static int readlong(char endianess, SeekableSource source) throws IOException {
        if (endianess == 'I') {
            return source.read() | source.read() << 8 | source.read() << 16 | source.read() << 24;
        }
        return source.read() << 24 | source.read() << 16 | source.read() << 8 | source.read();
    }
}

