/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.interactive.annotation;

import java.util.Optional;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSFloat;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSObjectable;
import org.sejda.sambox.pdmodel.common.PDRectangle;
import org.sejda.sambox.pdmodel.graphics.color.PDColor;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotationMarkup;
import org.sejda.sambox.pdmodel.interactive.annotation.PDBorderEffectDictionary;
import org.sejda.sambox.pdmodel.interactive.annotation.PDBorderStyleDictionary;
import org.sejda.sambox.pdmodel.interactive.annotation.handlers.PDAppearanceHandler;
import org.sejda.sambox.pdmodel.interactive.annotation.handlers.PDCircleAppearanceHandler;
import org.sejda.sambox.pdmodel.interactive.annotation.handlers.PDSquareAppearanceHandler;

public class PDAnnotationSquareCircle
extends PDAnnotationMarkup {
    public static final String SUB_TYPE_SQUARE = "Square";
    public static final String SUB_TYPE_CIRCLE = "Circle";
    private PDAppearanceHandler customAppearanceHandler;

    public PDAnnotationSquareCircle(String subType) {
        this.setSubtype(subType);
    }

    public PDAnnotationSquareCircle(COSDictionary field) {
        super(field);
    }

    @Override
    public void setInteriorColor(PDColor ic) {
        this.getCOSObject().setItem(COSName.IC, (COSBase)ic.toComponentsCOSArray());
    }

    @Override
    public PDColor getInteriorColor() {
        return this.getColor(COSName.IC);
    }

    @Override
    public void setBorderEffect(PDBorderEffectDictionary be) {
        this.getCOSObject().setItem(COSName.BE, (COSObjectable)be);
    }

    @Override
    public PDBorderEffectDictionary getBorderEffect() {
        return Optional.ofNullable(this.getCOSObject().getDictionaryObject(COSName.BE, COSDictionary.class)).map(PDBorderEffectDictionary::new).orElse(null);
    }

    @Override
    public void setRectDifference(PDRectangle rd) {
        this.getCOSObject().setItem(COSName.RD, (COSObjectable)rd);
    }

    @Override
    public PDRectangle getRectDifference() {
        return Optional.ofNullable(this.getCOSObject().getDictionaryObject(COSName.RD, COSArray.class)).map(PDRectangle::new).orElse(null);
    }

    public void setSubtype(String subType) {
        this.getCOSObject().setName(COSName.SUBTYPE, subType);
    }

    @Override
    public String getSubtype() {
        return this.getCOSObject().getNameAsString(COSName.SUBTYPE);
    }

    @Override
    public void setBorderStyle(PDBorderStyleDictionary bs) {
        this.getCOSObject().setItem(COSName.BS, (COSObjectable)bs);
    }

    @Override
    public PDBorderStyleDictionary getBorderStyle() {
        return Optional.ofNullable(this.getCOSObject().getDictionaryObject(COSName.BS, COSDictionary.class)).map(PDBorderStyleDictionary::new).orElse(null);
    }

    @Override
    public void setRectDifferences(float difference) {
        this.setRectDifferences(difference, difference, difference, difference);
    }

    @Override
    public void setRectDifferences(float differenceLeft, float differenceTop, float differenceRight, float differenceBottom) {
        COSArray margins = new COSArray();
        margins.add(new COSFloat(differenceLeft));
        margins.add(new COSFloat(differenceTop));
        margins.add(new COSFloat(differenceRight));
        margins.add(new COSFloat(differenceBottom));
        this.getCOSObject().setItem(COSName.RD, (COSBase)margins);
    }

    @Override
    public float[] getRectDifferences() {
        COSBase margin = this.getCOSObject().getItem(COSName.RD);
        if (margin instanceof COSArray) {
            return ((COSArray)margin).toFloatArray();
        }
        return new float[0];
    }

    @Override
    public void setCustomAppearanceHandler(PDAppearanceHandler appearanceHandler) {
        this.customAppearanceHandler = appearanceHandler;
    }

    @Override
    public void constructAppearances() {
        if (this.customAppearanceHandler == null) {
            if (SUB_TYPE_CIRCLE.equals(this.getSubtype())) {
                PDCircleAppearanceHandler appearanceHandler = new PDCircleAppearanceHandler(this);
                appearanceHandler.generateAppearanceStreams();
            } else if (SUB_TYPE_SQUARE.equals(this.getSubtype())) {
                PDSquareAppearanceHandler appearanceHandler = new PDSquareAppearanceHandler(this);
                appearanceHandler.generateAppearanceStreams();
            }
        } else {
            this.customAppearanceHandler.generateAppearanceStreams();
        }
    }
}

