/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.interactive.documentnavigation.outline;

import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;

class PDOutlineItemIterator
implements Iterator<PDOutlineItem> {
    private PDOutlineItem currentItem;
    private final PDOutlineItem startingItem;
    private final HashSet<PDOutlineItem> visited = new HashSet();

    PDOutlineItemIterator(PDOutlineItem startingItem) {
        this.startingItem = startingItem;
    }

    @Override
    public boolean hasNext() {
        if (this.startingItem == null) {
            return false;
        }
        if (this.currentItem == null) {
            return true;
        }
        PDOutlineItem next = this.currentItem.getNextSibling();
        if (next != null) {
            return !this.startingItem.equals(this.currentItem.getNextSibling()) && !this.visited.contains(next);
        }
        return false;
    }

    @Override
    public PDOutlineItem next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.currentItem = this.currentItem == null ? this.startingItem : this.currentItem.getNextSibling();
        if (this.visited.contains(this.currentItem)) {
            throw new NoSuchElementException();
        }
        this.visited.add(this.currentItem);
        return this.currentItem;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

