/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.interactive.form;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSArrayList;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSString;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAppearanceEntry;
import org.sejda.sambox.pdmodel.interactive.form.PDAcroForm;
import org.sejda.sambox.pdmodel.interactive.form.PDNonTerminalField;
import org.sejda.sambox.pdmodel.interactive.form.PDTerminalField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PDButton
extends PDTerminalField {
    private static final Logger LOG = LoggerFactory.getLogger(PDButton.class);
    static final int FLAG_RADIO = 32768;
    static final int FLAG_PUSHBUTTON = 65536;
    static final int FLAG_RADIOS_IN_UNISON = 0x2000000;

    public PDButton(PDAcroForm acroForm) {
        super(acroForm);
        this.getCOSObject().setItem(COSName.FT, (COSBase)COSName.BTN);
    }

    PDButton(PDAcroForm acroForm, COSDictionary field, PDNonTerminalField parent) {
        super(acroForm, field, parent);
    }

    public boolean isPushButton() {
        return this.getCOSObject().getFlag(COSName.FF, 65536);
    }

    public void setPushButton(boolean pushbutton) {
        this.getCOSObject().setFlag(COSName.FF, 65536, pushbutton);
    }

    public boolean isRadioButton() {
        return this.getCOSObject().getFlag(COSName.FF, 32768);
    }

    public void setRadioButton(boolean radiobutton) {
        this.getCOSObject().setFlag(COSName.FF, 32768, radiobutton);
    }

    public String getValue() {
        COSBase value = this.getInheritableAttribute(COSName.V);
        if (value instanceof COSName) {
            return ((COSName)value).getName();
        }
        return "Off";
    }

    @Override
    public void setValue(String value) throws IOException {
        this.checkValue(value);
        List<String> exportValues = this.getExportValues();
        if (exportValues.contains(value)) {
            this.updateByOption(value);
        } else {
            this.updateByValue(value);
        }
        this.applyChange();
    }

    public void setValueIgnoreExportOptions(String value) throws IOException {
        this.checkValue(value);
        this.updateByValue(value);
        this.applyChange();
    }

    public String getDefaultValue() {
        COSBase value = this.getInheritableAttribute(COSName.DV);
        if (value instanceof COSName) {
            return ((COSName)value).getName();
        }
        return "";
    }

    public void setDefaultValue(String value) {
        this.checkValue(value);
        this.getCOSObject().setName(COSName.DV, value);
    }

    @Override
    public String getValueAsString() {
        return this.getValue();
    }

    public List<String> getExportValues() {
        COSBase value = this.getInheritableAttribute(COSName.OPT);
        if (value instanceof COSString) {
            ArrayList<String> array = new ArrayList<String>();
            array.add(((COSString)value).getString());
            return array;
        }
        if (value instanceof COSArray) {
            return COSArrayList.convertCOSStringCOSArrayToList((COSArray)value);
        }
        return Collections.emptyList();
    }

    public void setExportValues(List<String> values) {
        if (values != null && !values.isEmpty()) {
            COSArray cosValues = COSArrayList.convertStringListToCOSStringCOSArray(values);
            this.getCOSObject().setItem(COSName.OPT, (COSBase)cosValues);
        } else {
            this.getCOSObject().removeItem(COSName.OPT);
        }
    }

    @Override
    void constructAppearances() throws IOException {
        List<String> exportValues = this.getExportValues();
        if (exportValues.contains(this.getValue())) {
            try {
                int optionsIndex = Integer.parseInt(this.getValue());
                if (optionsIndex >= 0 && optionsIndex < exportValues.size()) {
                    this.updateByOption(exportValues.get(optionsIndex));
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            this.updateByValue(this.getValue());
        }
    }

    public Set<String> getOnValues() {
        HashSet<String> onValues = new HashSet<String>();
        onValues.addAll(this.getExportValues());
        onValues.addAll(this.getNormalAppearanceValues());
        return onValues;
    }

    public List<String> getNormalAppearanceValues() {
        ArrayList<String> values = new ArrayList<String>();
        List<PDAnnotationWidget> widgets = this.getWidgets();
        for (PDAnnotationWidget widget : widgets) {
            String value = this.getOnValueForWidget(widget);
            if (value == null) continue;
            values.add(value);
        }
        return values;
    }

    private String getOnValue(int index) {
        List<PDAnnotationWidget> widgets = this.getWidgets();
        if (index < widgets.size()) {
            return this.getOnValueForWidget(widgets.get(index));
        }
        return null;
    }

    private String getOnValueForWidget(PDAnnotationWidget widget) {
        PDAppearanceEntry normalAppearance;
        PDAppearanceDictionary apDictionary = widget.getAppearance();
        if (apDictionary != null && (normalAppearance = apDictionary.getNormalAppearance()) != null) {
            try {
                Set<COSName> entries = normalAppearance.getSubDictionary().keySet();
                for (COSName entry : entries) {
                    if (COSName.Off.compareTo(entry) == 0) continue;
                    return entry.getName();
                }
            }
            catch (IllegalStateException ex) {
                LOG.warn("Could not parse normal appearances sub-dictionary for field {}", (Object)this.getFullyQualifiedName());
            }
        }
        return null;
    }

    void checkValue(String value) throws IllegalArgumentException {
        Set<String> onValues = this.getOnValues();
        if (onValues.isEmpty()) {
            return;
        }
        if (COSName.Off.getName().compareTo(value) != 0 && !onValues.contains(value)) {
            throw new IllegalArgumentException("value '" + value + "' is not a valid option for the field " + this.getFullyQualifiedName() + ", valid values are: " + onValues + " and " + COSName.Off.getName());
        }
    }

    private void updateByValue(String value) {
        this.getCOSObject().setName(COSName.V, value);
        for (PDAnnotationWidget widget : this.getWidgets()) {
            boolean matchesAppearance = false;
            if (widget.getAppearance() != null && widget.getAppearance().getNormalAppearance() != null) {
                matchesAppearance = ((COSDictionary)widget.getAppearance().getNormalAppearance().getCOSObject()).containsKey(value);
            }
            if (!COSName.OFF.getName().equals(value) && widget.getAppearance() == null && this.getWidgets().size() == 1) {
                matchesAppearance = true;
            }
            if (matchesAppearance) {
                widget.getCOSObject().setName(COSName.AS, value);
                continue;
            }
            widget.getCOSObject().setItem(COSName.AS, (COSBase)COSName.Off);
        }
    }

    private void updateByOption(String value) throws IOException {
        List<PDAnnotationWidget> widgets = this.getWidgets();
        List<String> options = this.getExportValues();
        HashSet<String> uniqueOptions = new HashSet<String>(options);
        if (widgets.size() != options.size() && uniqueOptions.size() > 1) {
            throw new IllegalArgumentException("The number of options doesn't match the number of widgets");
        }
        if (value.equals(COSName.Off.getName())) {
            this.updateByValue(value);
        } else {
            String onValue;
            int optionsIndex = options.indexOf(value);
            if (optionsIndex != -1 && (onValue = this.getOnValue(optionsIndex)) != null) {
                this.updateByValue(onValue);
            }
        }
    }
}

