/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.xref;

import org.sejda.commons.util.RequireUtils;
import org.sejda.sambox.xref.XrefEntry;
import org.sejda.sambox.xref.XrefType;

public final class CompressedXrefEntry
extends XrefEntry {
    private long objectStreamNumber;
    private long index;

    private CompressedXrefEntry(XrefType type, long objectNumber, long byteOffset, int generationNumber, long objectStreamNumber, long index) {
        super(type, objectNumber, byteOffset, generationNumber);
        RequireUtils.requireArg((objectStreamNumber >= 0L ? 1 : 0) != 0, (String)"Containing object stream number cannot be negative");
        this.objectStreamNumber = objectStreamNumber;
        this.index = index;
    }

    public long getObjectStreamNumber() {
        return this.objectStreamNumber;
    }

    @Override
    public byte[] toXrefStreamEntry(int secondFieldLength, int thirdFieldLength) {
        byte[] retVal = new byte[1 + secondFieldLength + thirdFieldLength];
        retVal[0] = 2;
        this.copyBytesTo(this.getObjectStreamNumber(), secondFieldLength, retVal, 1);
        this.copyBytesTo(this.index, thirdFieldLength, retVal, 1 + secondFieldLength);
        return retVal;
    }

    @Override
    public String toString() {
        return String.format("%s offset=%d objectStreamNumber=%d, %s", this.getType().toString(), this.getByteOffset(), this.objectStreamNumber, this.key().toString());
    }

    public static CompressedXrefEntry compressedEntry(long objectNumber, long objectStreamNumber, long index) {
        return new CompressedXrefEntry(XrefType.COMPRESSED, objectNumber, -1L, 0, objectStreamNumber, index);
    }
}

