/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.output;

import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.sejda.commons.util.IOUtils;
import org.sejda.commons.util.RequireUtils;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSInteger;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.DirectCOSObject;
import org.sejda.sambox.cos.IndirectCOSObjectReference;
import org.sejda.sambox.output.IndirectObjectsWriter;
import org.sejda.sambox.output.XrefStream;
import org.sejda.sambox.xref.XrefEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultPDFWriter
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPDFWriter.class);
    byte COMMENT = (byte)37;
    byte[] GARBAGE = new byte[]{-89, -29, -15, -15};
    private IndirectObjectsWriter writer;

    public DefaultPDFWriter(IndirectObjectsWriter writer) {
        RequireUtils.requireNotNullArg((Object)writer, (String)"Cannot write to a null COSWriter");
        this.writer = writer;
    }

    public void writeHeader(String version) throws IOException {
        LOG.debug("Writing header " + version);
        this.writer().write("%PDF-");
        this.writer().write(version);
        this.writer().writeEOL();
        this.writer().write(this.COMMENT);
        this.writer().write(this.GARBAGE);
        this.writer().writeEOL();
    }

    public long writeXrefTable() throws IOException {
        long startxref = this.writer().offset();
        LOG.debug("Writing xref table at offset " + startxref);
        if (Objects.nonNull(this.writer.context().addWritten(XrefEntry.DEFAULT_FREE_ENTRY))) {
            LOG.warn("Reserved object number 0 has been overwritten with the expected free entry");
        }
        this.writer().write("xref");
        this.writer().writeEOL();
        for (List<Long> continuos : this.writer.context().getWrittenContiguousGroups()) {
            this.writer().write(continuos.get(0).toString() + " " + continuos.size());
            this.writer().writeEOL();
            for (long key : continuos) {
                this.writer().write(Optional.ofNullable(this.writer.context().getWritten(key)).orElse(XrefEntry.DEFAULT_FREE_ENTRY).toXrefTableEntry());
            }
        }
        return startxref;
    }

    public void writeTrailer(COSDictionary trailer, long startxref) throws IOException {
        this.writeTrailer(trailer, startxref, -1L);
    }

    public void writeTrailer(COSDictionary trailer, long startxref, long prev) throws IOException {
        LOG.trace("Writing trailer");
        DefaultPDFWriter.sanitizeTrailer(trailer, prev);
        trailer.setItem(COSName.SIZE, (COSBase)DirectCOSObject.asDirectObject(COSInteger.get(this.writer.context().highestObjectNumber() + 1L)));
        this.writer.write("trailer".getBytes(StandardCharsets.US_ASCII));
        this.writer.writeEOL();
        trailer.getCOSObject().accept(this.writer.writer());
        this.writeXrefFooter(startxref);
    }

    public void writeXrefStream(COSDictionary trailer) throws IOException {
        if (Objects.nonNull(this.writer.context().addWritten(XrefEntry.DEFAULT_FREE_ENTRY))) {
            LOG.warn("Reserved object number 0 has been overwritten with the expected free entry");
        }
        this.writeXrefStream(trailer, -1L);
    }

    public void writeXrefStream(COSDictionary trailer, long prev) throws IOException {
        long startxref = this.writer().offset();
        LOG.debug("Writing xref stream at offset " + startxref);
        DefaultPDFWriter.sanitizeTrailer(trailer, prev);
        XrefEntry entry = XrefEntry.inUseEntry(this.writer.context().highestObjectNumber() + 1L, startxref, 0);
        this.writer.context().addWritten(entry);
        this.writer.writeObject(new IndirectCOSObjectReference(entry.getObjectNumber(), entry.getGenerationNumber(), new XrefStream(trailer, this.writer.context())));
        this.writeXrefFooter(startxref);
    }

    private static void sanitizeTrailer(COSDictionary trailer, long prev) {
        trailer.removeItem(COSName.PREV);
        trailer.removeItem(COSName.XREF_STM);
        trailer.removeItem(COSName.DOC_CHECKSUM);
        trailer.removeItem(COSName.DECODE_PARMS);
        trailer.removeItem(COSName.FILTER);
        trailer.removeItem(COSName.F_DECODE_PARMS);
        trailer.removeItem(COSName.F_FILTER);
        trailer.removeItem(COSName.F);
        trailer.removeItem(COSName.LENGTH);
        trailer.removeItem(COSName.W);
        trailer.removeItem(COSName.DL);
        trailer.removeItem(COSName.TYPE);
        trailer.removeItem(COSName.INDEX);
        if (prev != -1L) {
            trailer.setLong(COSName.PREV, prev);
        }
    }

    private void writeXrefFooter(long startxref) throws IOException {
        this.writer.write("startxref".getBytes(StandardCharsets.US_ASCII));
        this.writer.writeEOL();
        this.writer.write(Long.toString(startxref));
        this.writer.writeEOL();
        this.writer.write("%%EOF".getBytes(StandardCharsets.US_ASCII));
        this.writer.writeEOL();
    }

    IndirectObjectsWriter writer() {
        return this.writer;
    }

    @Override
    public void close() throws IOException {
        IOUtils.close((Closeable)this.writer);
    }
}

