/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSObjectKey;
import org.sejda.sambox.cos.COSObjectable;
import org.sejda.sambox.cos.COSStream;
import org.sejda.sambox.input.ExistingIndirectCOSObject;
import org.sejda.sambox.pdmodel.ResourceCache;
import org.sejda.sambox.pdmodel.documentinterchange.markedcontent.PDPropertyList;
import org.sejda.sambox.pdmodel.font.PDFont;
import org.sejda.sambox.pdmodel.font.PDFontFactory;
import org.sejda.sambox.pdmodel.graphics.PDXObject;
import org.sejda.sambox.pdmodel.graphics.color.PDColorSpace;
import org.sejda.sambox.pdmodel.graphics.color.PDPattern;
import org.sejda.sambox.pdmodel.graphics.form.PDFormXObject;
import org.sejda.sambox.pdmodel.graphics.image.PDImageXObject;
import org.sejda.sambox.pdmodel.graphics.optionalcontent.PDOptionalContentGroup;
import org.sejda.sambox.pdmodel.graphics.pattern.PDAbstractPattern;
import org.sejda.sambox.pdmodel.graphics.shading.PDShading;
import org.sejda.sambox.pdmodel.graphics.state.PDExtendedGraphicsState;

public final class PDResources
implements COSObjectable {
    private final COSDictionary resources;
    private final ResourceCache cache;
    private final Map<COSName, SoftReference<PDFont>> directFontCache = new HashMap<COSName, SoftReference<PDFont>>();

    public PDResources() {
        this.resources = new COSDictionary();
        this.cache = null;
    }

    public PDResources(COSDictionary resourceDictionary) {
        if (resourceDictionary == null) {
            throw new IllegalArgumentException("resourceDictionary is null");
        }
        this.resources = resourceDictionary;
        this.cache = null;
    }

    public PDResources(COSDictionary resourceDictionary, ResourceCache resourceCache) {
        if (resourceDictionary == null) {
            throw new IllegalArgumentException("resourceDictionary is null");
        }
        this.resources = resourceDictionary;
        this.cache = resourceCache;
    }

    @Override
    public COSDictionary getCOSObject() {
        return this.resources;
    }

    public PDFont getFont(COSName name) throws IOException {
        PDFont cached;
        SoftReference<PDFont> ref;
        COSObjectKey key = this.getIndirectKey(COSName.FONT, name);
        if (this.cache != null && key != null) {
            PDFont cached2 = this.cache.getFont(key);
            if (cached2 != null) {
                return cached2;
            }
        } else if (key == null && (ref = this.directFontCache.get(name)) != null && (cached = ref.get()) != null) {
            return cached;
        }
        PDFont font = null;
        COSDictionary dict = (COSDictionary)this.get(COSName.FONT, name);
        if (dict != null) {
            font = PDFontFactory.createFont(dict, this.cache);
        }
        if (this.cache != null && key != null) {
            this.cache.put(key, font);
        } else if (key == null) {
            this.directFontCache.put(name, new SoftReference<PDFont>(font));
        }
        return font;
    }

    public PDColorSpace getColorSpace(COSName name) throws IOException {
        return this.getColorSpace(name, false);
    }

    public PDColorSpace getColorSpace(COSName name, boolean wasDefault) throws IOException {
        PDColorSpace cached;
        COSObjectKey key = this.getIndirectKey(COSName.COLORSPACE, name);
        if (this.cache != null && key != null && (cached = this.cache.getColorSpace(key)) != null) {
            return cached;
        }
        COSBase object = this.get(COSName.COLORSPACE, name);
        PDColorSpace colorSpace = object != null ? PDColorSpace.create(object, this, wasDefault) : PDColorSpace.create(name, this, wasDefault);
        if (this.cache != null && !(colorSpace instanceof PDPattern)) {
            this.cache.put(key, colorSpace);
        }
        return colorSpace;
    }

    public boolean hasColorSpace(COSName name) {
        return this.get(COSName.COLORSPACE, name) != null;
    }

    public PDExtendedGraphicsState getExtGState(COSName name) {
        PDExtendedGraphicsState cached;
        COSObjectKey key = this.getIndirectKey(COSName.EXT_G_STATE, name);
        if (this.cache != null && key != null && (cached = this.cache.getExtGState(key)) != null) {
            return cached;
        }
        PDExtendedGraphicsState extGState = null;
        COSBase base = this.get(COSName.EXT_G_STATE, name);
        COSDictionary dict = null;
        if (base instanceof COSDictionary) {
            dict = (COSDictionary)base;
        }
        if (dict != null) {
            extGState = new PDExtendedGraphicsState(dict);
        }
        if (this.cache != null) {
            this.cache.put(key, extGState);
        }
        return extGState;
    }

    public PDShading getShading(COSName name) throws IOException {
        PDShading cached;
        COSObjectKey key = this.getIndirectKey(COSName.SHADING, name);
        if (this.cache != null && key != null && (cached = this.cache.getShading(key)) != null) {
            return cached;
        }
        PDShading shading = null;
        COSDictionary dict = (COSDictionary)this.get(COSName.SHADING, name);
        if (dict != null) {
            shading = PDShading.create(dict);
        }
        if (this.cache != null) {
            this.cache.put(key, shading);
        }
        return shading;
    }

    public PDAbstractPattern getPattern(COSName name) throws IOException {
        PDAbstractPattern cached;
        COSObjectKey key = this.getIndirectKey(COSName.PATTERN, name);
        if (this.cache != null && key != null && (cached = this.cache.getPattern(key)) != null) {
            return cached;
        }
        PDAbstractPattern pattern = null;
        COSDictionary dict = (COSDictionary)this.get(COSName.PATTERN, name);
        if (dict != null) {
            pattern = PDAbstractPattern.create(dict, this.getResourceCache());
        }
        if (this.cache != null) {
            this.cache.put(key, pattern);
        }
        return pattern;
    }

    public PDPropertyList getProperties(COSName name) {
        PDPropertyList cached;
        COSObjectKey key = this.getIndirectKey(COSName.PROPERTIES, name);
        if (this.cache != null && key != null && (cached = this.cache.getProperties(key)) != null) {
            return cached;
        }
        PDPropertyList propertyList = null;
        COSDictionary dict = (COSDictionary)this.get(COSName.PROPERTIES, name);
        if (dict != null) {
            propertyList = PDPropertyList.create(dict);
        }
        if (this.cache != null) {
            this.cache.put(key, propertyList);
        }
        return propertyList;
    }

    public boolean isImageXObject(COSName name) {
        return Optional.ofNullable(this.get(COSName.XOBJECT, name)).map(COSBase::getCOSObject).filter(s -> s instanceof COSStream).map(s -> (COSStream)s).map(s -> COSName.IMAGE.equals(s.getCOSName(COSName.SUBTYPE))).orElse(false);
    }

    public boolean isFormXObject(COSName name) {
        return Optional.ofNullable(this.get(COSName.XOBJECT, name)).map(COSBase::getCOSObject).map(s -> (COSStream)s).map(s -> COSName.FORM.equals(s.getCOSName(COSName.SUBTYPE))).orElse(false);
    }

    public PDXObject getXObject(COSName name) throws IOException {
        PDXObject cached;
        COSObjectKey key = this.getIndirectKey(COSName.XOBJECT, name);
        if (this.cache != null && key != null && (cached = this.cache.getXObject(key)) != null) {
            return cached;
        }
        COSBase value = this.get(COSName.XOBJECT, name);
        PDXObject xobject = value == null ? null : PDXObject.createXObject(value.getCOSObject(), this);
        if (this.cache != null && this.isAllowedCache(xobject)) {
            this.cache.put(key, xobject);
        }
        return xobject;
    }

    private boolean isAllowedCache(PDXObject xobject) {
        COSBase colorSpace;
        if (xobject instanceof PDImageXObject && (colorSpace = xobject.getCOSObject().getDictionaryObject(COSName.COLORSPACE)) instanceof COSName) {
            COSName colorSpaceName = (COSName)colorSpace;
            if (colorSpaceName.equals(COSName.DEVICECMYK) && this.hasColorSpace(COSName.DEFAULT_CMYK)) {
                return false;
            }
            if (colorSpaceName.equals(COSName.DEVICERGB) && this.hasColorSpace(COSName.DEFAULT_RGB)) {
                return false;
            }
            if (colorSpaceName.equals(COSName.DEVICEGRAY) && this.hasColorSpace(COSName.DEFAULT_GRAY)) {
                return false;
            }
            if (this.hasColorSpace(colorSpaceName)) {
                return false;
            }
        }
        return true;
    }

    public COSObjectKey getIndirectKey(COSName kind, COSName name) {
        COSBase found = Optional.ofNullable(this.resources.getDictionaryObject(kind, COSDictionary.class)).map(d -> d.getItem(name)).orElse(null);
        if (found instanceof ExistingIndirectCOSObject) {
            return ((ExistingIndirectCOSObject)found).id().objectIdentifier;
        }
        if (found != null && found.id() != null) {
            return found.id().objectIdentifier;
        }
        return null;
    }

    private COSBase get(COSName kind, COSName name) {
        return Optional.ofNullable(this.resources.getDictionaryObject(kind, COSDictionary.class)).map(d -> d.getDictionaryObject(name)).orElse(null);
    }

    public Iterable<COSName> getColorSpaceNames() {
        return this.getNames(COSName.COLORSPACE);
    }

    public Iterable<COSName> getXObjectNames() {
        return this.getNames(COSName.XOBJECT);
    }

    public Iterable<COSName> getFontNames() {
        return this.getNames(COSName.FONT);
    }

    public Iterable<COSName> getPropertiesNames() {
        return this.getNames(COSName.PROPERTIES);
    }

    public Iterable<COSName> getShadingNames() {
        return this.getNames(COSName.SHADING);
    }

    public Iterable<COSName> getPatternNames() {
        return this.getNames(COSName.PATTERN);
    }

    public Iterable<COSName> getExtGStateNames() {
        return this.getNames(COSName.EXT_G_STATE);
    }

    private Iterable<COSName> getNames(COSName kind) {
        return Optional.ofNullable(this.resources.getDictionaryObject(kind, COSDictionary.class)).map(COSDictionary::keySet).orElseGet(Collections::emptySet);
    }

    public COSName add(PDFont font) {
        return this.add(COSName.FONT, "F", font);
    }

    public COSName add(PDColorSpace colorSpace) {
        return this.add(COSName.COLORSPACE, "cs", colorSpace);
    }

    public COSName add(PDExtendedGraphicsState extGState) {
        return this.add(COSName.EXT_G_STATE, "gs", extGState);
    }

    public COSName add(PDShading shading) {
        return this.add(COSName.SHADING, "sh", shading);
    }

    public COSName add(PDAbstractPattern pattern) {
        return this.add(COSName.PATTERN, "p", pattern);
    }

    public COSName add(PDPropertyList properties) {
        if (properties instanceof PDOptionalContentGroup) {
            return this.add(COSName.PROPERTIES, "oc", properties);
        }
        return this.add(COSName.PROPERTIES, "Prop", properties);
    }

    public COSName add(PDImageXObject image) {
        return this.add(COSName.XOBJECT, "Im", image);
    }

    public COSName add(PDFormXObject form) {
        return this.add(COSName.XOBJECT, "Form", form);
    }

    public COSName add(PDXObject xobject, String prefix) {
        return this.add(COSName.XOBJECT, prefix, xobject);
    }

    private COSName add(COSName kind, String prefix, COSObjectable object) {
        COSDictionary dict = this.resources.getDictionaryObject(kind, COSDictionary.class);
        return Optional.ofNullable(dict).map(d -> d.getKeyForValue(object.getCOSObject())).orElseGet(() -> {
            COSName name = this.createKey(kind, prefix);
            this.put(kind, name, object);
            return name;
        });
    }

    private COSName createKey(COSName kind, String prefix) {
        String key;
        COSDictionary dict = this.resources.getDictionaryObject(kind, COSDictionary.class);
        if (dict == null) {
            return COSName.getPDFName(prefix + 1);
        }
        int n = dict.keySet().size();
        while (dict.containsKey(key = prefix + ++n)) {
        }
        return COSName.getPDFName(key);
    }

    private void put(COSName kind, COSName name, COSObjectable object) {
        COSDictionary dict = this.resources.getDictionaryObject(kind, COSDictionary.class);
        if (dict == null) {
            dict = new COSDictionary();
            this.resources.setItem(kind, (COSBase)dict);
        }
        dict.setItem(name, object);
    }

    public void put(COSName name, PDFont font) {
        this.put(COSName.FONT, name, font);
    }

    public void put(COSName name, PDColorSpace colorSpace) {
        this.put(COSName.COLORSPACE, name, colorSpace);
    }

    public void put(COSName name, PDExtendedGraphicsState extGState) {
        this.put(COSName.EXT_G_STATE, name, extGState);
    }

    public void put(COSName name, PDShading shading) {
        this.put(COSName.SHADING, name, shading);
    }

    public void put(COSName name, PDAbstractPattern pattern) {
        this.put(COSName.PATTERN, name, pattern);
    }

    public void put(COSName name, PDPropertyList properties) {
        this.put(COSName.PROPERTIES, name, properties);
    }

    public void put(COSName name, PDXObject xobject) {
        this.put(COSName.XOBJECT, name, xobject);
    }

    public ResourceCache getResourceCache() {
        return this.cache;
    }
}

