/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.interactive.annotation;

import java.io.IOException;
import java.util.Optional;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSObjectable;
import org.sejda.sambox.pdmodel.interactive.action.PDAction;
import org.sejda.sambox.pdmodel.interactive.action.PDActionFactory;
import org.sejda.sambox.pdmodel.interactive.action.PDActionURI;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotation;
import org.sejda.sambox.pdmodel.interactive.annotation.PDBorderStyleDictionary;
import org.sejda.sambox.pdmodel.interactive.annotation.handlers.PDAppearanceHandler;
import org.sejda.sambox.pdmodel.interactive.annotation.handlers.PDLinkAppearanceHandler;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.destination.WithActionOrDestination;

public class PDAnnotationLink
extends PDAnnotation
implements WithActionOrDestination {
    private PDAppearanceHandler customAppearanceHandler;
    public static final String HIGHLIGHT_MODE_NONE = "N";
    public static final String HIGHLIGHT_MODE_INVERT = "I";
    public static final String HIGHLIGHT_MODE_OUTLINE = "O";
    public static final String HIGHLIGHT_MODE_PUSH = "P";
    public static final String SUB_TYPE = "Link";

    public PDAnnotationLink() {
        this.getCOSObject().setName(COSName.SUBTYPE, SUB_TYPE);
    }

    public PDAnnotationLink(COSDictionary field) {
        super(field);
    }

    @Override
    public PDAction getAction() {
        COSDictionary action = this.getCOSObject().getDictionaryObject(COSName.A, COSDictionary.class);
        return PDActionFactory.createAction(action);
    }

    public void setAction(PDAction action) {
        this.getCOSObject().setItem(COSName.A, (COSObjectable)action);
    }

    public void setBorderStyle(PDBorderStyleDictionary bs) {
        this.getCOSObject().setItem(COSName.BS, (COSObjectable)bs);
    }

    public PDBorderStyleDictionary getBorderStyle() {
        COSBase bs = this.getCOSObject().getDictionaryObject(COSName.BS);
        if (bs instanceof COSDictionary) {
            return new PDBorderStyleDictionary((COSDictionary)bs);
        }
        return null;
    }

    @Override
    public PDDestination getDestination() throws IOException {
        return PDDestination.create(this.getCOSObject().getDictionaryObject(COSName.DEST));
    }

    public void setDestination(PDDestination dest) {
        this.getCOSObject().setItem(COSName.DEST, (COSObjectable)dest);
    }

    public String getHighlightMode() {
        return this.getCOSObject().getNameAsString(COSName.H, HIGHLIGHT_MODE_INVERT);
    }

    public void setHighlightMode(String mode) {
        this.getCOSObject().setName(COSName.H, mode);
    }

    public void setPreviousURI(PDActionURI pa) {
        this.getCOSObject().setItem("PA", (COSObjectable)pa);
    }

    public PDActionURI getPreviousURI() {
        COSDictionary pa = this.getCOSObject().getDictionaryObject("PA", COSDictionary.class);
        if (pa != null) {
            return new PDActionURI(pa);
        }
        return null;
    }

    public void setQuadPoints(float[] quadPoints) {
        COSArray newQuadPoints = new COSArray();
        newQuadPoints.setFloatArray(quadPoints);
        this.getCOSObject().setItem(COSName.QUADPOINTS, (COSBase)newQuadPoints);
    }

    public float[] getQuadPoints() {
        return Optional.ofNullable(this.getCOSObject().getDictionaryObject(COSName.QUADPOINTS, COSArray.class)).map(COSArray::toFloatArray).orElse(null);
    }

    public void setCustomAppearanceHandler(PDAppearanceHandler appearanceHandler) {
        this.customAppearanceHandler = appearanceHandler;
    }

    @Override
    public void constructAppearances() {
        if (this.customAppearanceHandler == null) {
            PDLinkAppearanceHandler appearanceHandler = new PDLinkAppearanceHandler(this);
            appearanceHandler.generateAppearanceStreams();
        } else {
            this.customAppearanceHandler.generateAppearanceStreams();
        }
    }
}

