/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.rendering;

import java.awt.Color;
import java.awt.DisplayMode;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.PDPageTree;
import org.sejda.sambox.pdmodel.PDResources;
import org.sejda.sambox.pdmodel.common.PDRectangle;
import org.sejda.sambox.pdmodel.graphics.blend.BlendMode;
import org.sejda.sambox.pdmodel.graphics.optionalcontent.PDOptionalContentGroup;
import org.sejda.sambox.pdmodel.graphics.optionalcontent.PDOptionalContentProperties;
import org.sejda.sambox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.sejda.sambox.pdmodel.interactive.annotation.AnnotationFilter;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotation;
import org.sejda.sambox.rendering.ImageType;
import org.sejda.sambox.rendering.PageDrawer;
import org.sejda.sambox.rendering.PageDrawerParameters;
import org.sejda.sambox.rendering.RenderDestination;

public class PDFRenderer {
    protected final PDDocument document;
    private AnnotationFilter annotationFilter = new AnnotationFilter(){

        @Override
        public boolean accept(PDAnnotation annotation) {
            return true;
        }
    };
    private boolean subsamplingAllowed = false;
    private RenderDestination defaultDestination;
    private RenderingHints renderingHints = null;
    private BufferedImage pageImage;
    private final PDPageTree pageTree;

    public PDFRenderer(PDDocument document) {
        this.document = document;
        this.pageTree = document.getPages();
    }

    public AnnotationFilter getAnnotationsFilter() {
        return this.annotationFilter;
    }

    public void setAnnotationsFilter(AnnotationFilter annotationsFilter) {
        this.annotationFilter = annotationsFilter;
    }

    public boolean isSubsamplingAllowed() {
        return this.subsamplingAllowed;
    }

    public void setSubsamplingAllowed(boolean subsamplingAllowed) {
        this.subsamplingAllowed = subsamplingAllowed;
    }

    public RenderDestination getDefaultDestination() {
        return this.defaultDestination;
    }

    public void setDefaultDestination(RenderDestination defaultDestination) {
        this.defaultDestination = defaultDestination;
    }

    public RenderingHints getRenderingHints() {
        return this.renderingHints;
    }

    public void setRenderingHints(RenderingHints renderingHints) {
        this.renderingHints = renderingHints;
    }

    public BufferedImage renderImage(int pageIndex) throws IOException {
        return this.renderImage(pageIndex, 1.0f);
    }

    public BufferedImage renderImage(int pageIndex, float scale) throws IOException {
        return this.renderImage(pageIndex, scale, ImageType.RGB);
    }

    public BufferedImage renderImageWithDPI(int pageIndex, float dpi) throws IOException {
        return this.renderImage(pageIndex, dpi / 72.0f, ImageType.RGB);
    }

    public BufferedImage renderImageWithDPI(int pageIndex, float dpi, ImageType imageType) throws IOException {
        return this.renderImage(pageIndex, dpi / 72.0f, imageType);
    }

    public BufferedImage renderImage(int pageIndex, float scale, ImageType imageType) throws IOException {
        return this.renderImage(pageIndex, scale, imageType, this.defaultDestination == null ? RenderDestination.EXPORT : this.defaultDestination);
    }

    public BufferedImage renderImage(int pageIndex, float scale, ImageType imageType, RenderDestination destination) throws IOException {
        int heightPx;
        PDPage page = this.pageTree.get(pageIndex);
        PDRectangle cropBox = page.getCropBox();
        float widthPt = cropBox.getWidth();
        float heightPt = cropBox.getHeight();
        int widthPx = (int)Math.max(Math.floor(widthPt * scale), 1.0);
        if ((long)widthPx * (long)(heightPx = (int)Math.max(Math.floor(heightPt * scale), 1.0)) > Integer.MAX_VALUE) {
            throw new IOException("Maximum size of image exceeded (w * h * scale ^ 2) = " + widthPt + " * " + heightPt + " * " + scale + " ^ 2 > " + Integer.MAX_VALUE);
        }
        int rotationAngle = page.getRotation();
        int bimType = imageType != ImageType.ARGB && this.hasBlendMode(page) ? 2 : imageType.toBufferedImageType();
        BufferedImage image = rotationAngle == 90 || rotationAngle == 270 ? new BufferedImage(heightPx, widthPx, bimType) : new BufferedImage(widthPx, heightPx, bimType);
        this.pageImage = image;
        Graphics2D g = image.createGraphics();
        if (image.getType() == 2) {
            g.setBackground(new Color(0, 0, 0, 0));
        } else {
            g.setBackground(Color.WHITE);
        }
        g.clearRect(0, 0, image.getWidth(), image.getHeight());
        this.transform(g, page.getRotation(), cropBox, scale, scale);
        RenderingHints actualRenderingHints = this.renderingHints == null ? this.createDefaultRenderingHints(g) : this.renderingHints;
        PageDrawerParameters parameters = new PageDrawerParameters(this, page, this.subsamplingAllowed, destination, actualRenderingHints);
        PageDrawer drawer = this.createPageDrawer(parameters);
        drawer.drawPage(g, cropBox);
        g.dispose();
        if (image.getType() != imageType.toBufferedImageType()) {
            BufferedImage newImage = new BufferedImage(image.getWidth(), image.getHeight(), imageType.toBufferedImageType());
            Graphics2D dstGraphics = newImage.createGraphics();
            dstGraphics.setBackground(Color.WHITE);
            dstGraphics.clearRect(0, 0, image.getWidth(), image.getHeight());
            dstGraphics.drawImage((Image)image, 0, 0, null);
            dstGraphics.dispose();
            image = newImage;
        }
        return image;
    }

    public void renderPageToGraphics(int pageIndex, Graphics2D graphics) throws IOException {
        this.renderPageToGraphics(pageIndex, graphics, 1.0f);
    }

    public void renderPageToGraphics(int pageIndex, Graphics2D graphics, float scale) throws IOException {
        this.renderPageToGraphics(pageIndex, graphics, scale, scale);
    }

    public void renderPageToGraphics(int pageIndex, Graphics2D graphics, float scaleX, float scaleY) throws IOException {
        this.renderPageToGraphics(pageIndex, graphics, scaleX, scaleY, this.defaultDestination == null ? RenderDestination.VIEW : this.defaultDestination);
    }

    public void renderPageToGraphics(int pageIndex, Graphics2D graphics, float scaleX, float scaleY, RenderDestination destination) throws IOException {
        PDPage page = this.pageTree.get(pageIndex);
        PDRectangle cropBox = page.getCropBox();
        this.transform(graphics, page.getRotation(), cropBox, scaleX, scaleY);
        graphics.clearRect(0, 0, (int)cropBox.getWidth(), (int)cropBox.getHeight());
        RenderingHints actualRenderingHints = this.renderingHints == null ? this.createDefaultRenderingHints(graphics) : this.renderingHints;
        PageDrawerParameters parameters = new PageDrawerParameters(this, page, this.subsamplingAllowed, destination, actualRenderingHints);
        PageDrawer drawer = this.createPageDrawer(parameters);
        drawer.drawPage(graphics, cropBox);
    }

    public boolean isGroupEnabled(PDOptionalContentGroup group) {
        PDOptionalContentProperties ocProperties = this.document.getDocumentCatalog().getOCProperties();
        return ocProperties == null || ocProperties.isGroupEnabled(group);
    }

    private void transform(Graphics2D graphics, int rotationAngle, PDRectangle cropBox, float scaleX, float scaleY) {
        graphics.scale(scaleX, scaleY);
        if (rotationAngle != 0) {
            float translateX = 0.0f;
            float translateY = 0.0f;
            switch (rotationAngle) {
                case 90: {
                    translateX = cropBox.getHeight();
                    break;
                }
                case 270: {
                    translateY = cropBox.getWidth();
                    break;
                }
                case 180: {
                    translateX = cropBox.getWidth();
                    translateY = cropBox.getHeight();
                    break;
                }
            }
            graphics.translate(translateX, translateY);
            graphics.rotate(Math.toRadians(rotationAngle));
        }
    }

    private boolean isBitonal(Graphics2D graphics) {
        GraphicsConfiguration deviceConfiguration = graphics.getDeviceConfiguration();
        if (deviceConfiguration == null) {
            return false;
        }
        GraphicsDevice device = deviceConfiguration.getDevice();
        if (device == null) {
            return false;
        }
        DisplayMode displayMode = device.getDisplayMode();
        if (displayMode == null) {
            return false;
        }
        return displayMode.getBitDepth() == 1;
    }

    private RenderingHints createDefaultRenderingHints(Graphics2D graphics) {
        RenderingHints r = new RenderingHints(null);
        r.put(RenderingHints.KEY_INTERPOLATION, this.isBitonal(graphics) ? RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR : RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        r.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        r.put(RenderingHints.KEY_ANTIALIASING, this.isBitonal(graphics) ? RenderingHints.VALUE_ANTIALIAS_OFF : RenderingHints.VALUE_ANTIALIAS_ON);
        return r;
    }

    protected PageDrawer createPageDrawer(PageDrawerParameters parameters) throws IOException {
        PageDrawer pageDrawer = new PageDrawer(parameters);
        pageDrawer.setAnnotationFilter(this.annotationFilter);
        return pageDrawer;
    }

    private boolean hasBlendMode(PDPage page) {
        PDResources resources = page.getResources();
        if (resources == null) {
            return false;
        }
        for (COSName name : resources.getExtGStateNames()) {
            BlendMode blendMode;
            PDExtendedGraphicsState extGState = resources.getExtGState(name);
            if (extGState == null || (blendMode = extGState.getBlendMode()) == BlendMode.NORMAL) continue;
            return true;
        }
        return false;
    }

    BufferedImage getPageImage() {
        return this.pageImage;
    }
}

