/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.cos;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.regex.Pattern;
import org.sejda.commons.util.RequireUtils;
import org.sejda.sambox.cos.COSNumber;
import org.sejda.sambox.cos.COSVisitor;

public class COSFloat
extends COSNumber {
    private BigDecimal value;
    private static final Pattern DOTS = Pattern.compile("\\.");
    private static final Pattern EXP_END = Pattern.compile("[e|E]$");
    private static final Pattern NUM1 = Pattern.compile("^(-)([-|+]+)\\d+\\.\\d+");
    private static final Pattern NUM2 = Pattern.compile("^(-)([\\-|\\+]+)");
    private static final Pattern NUM3 = Pattern.compile("^0\\.0*\\-\\d+");
    private static final Pattern ZERO = Pattern.compile("^0\\-(\\.|\\d+)*");
    private static final Pattern MINUS = Pattern.compile("\\-");

    public COSFloat(float aFloat) {
        this.value = new BigDecimal(String.valueOf(aFloat));
    }

    public COSFloat(String aFloat) throws IOException {
        try {
            int dot = aFloat.indexOf(46);
            if (dot != aFloat.lastIndexOf(46)) {
                aFloat = aFloat.substring(0, dot + 1) + DOTS.matcher(aFloat.substring(dot + 1)).replaceAll("0");
            }
            aFloat = EXP_END.matcher(aFloat).replaceAll("");
            this.value = new BigDecimal(aFloat);
            this.checkMinMaxValues();
        }
        catch (NumberFormatException e) {
            try {
                if (NUM1.matcher(aFloat).matches()) {
                    this.value = new BigDecimal(NUM2.matcher(aFloat).replaceFirst("-"));
                } else if (ZERO.matcher(aFloat).matches()) {
                    this.value = BigDecimal.ZERO;
                } else {
                    RequireUtils.requireIOCondition((boolean)NUM3.matcher(aFloat).matches(), (String)("Expected floating point number but found '" + aFloat + "'"));
                    this.value = new BigDecimal("-" + MINUS.matcher(aFloat).replaceFirst(""));
                }
                this.checkMinMaxValues();
            }
            catch (NumberFormatException e2) {
                throw new IOException("Error expected floating point number actual='" + aFloat + "'", e2);
            }
        }
    }

    private void checkMinMaxValues() {
        float floatValue = this.value.floatValue();
        double doubleValue = this.value.doubleValue();
        boolean valueReplaced = false;
        if (floatValue == Float.NEGATIVE_INFINITY || floatValue == Float.POSITIVE_INFINITY) {
            if (Math.abs(doubleValue) > 3.4028234663852886E38) {
                floatValue = Float.MAX_VALUE * (float)(floatValue == Float.POSITIVE_INFINITY ? 1 : -1);
                valueReplaced = true;
            }
        } else if (floatValue == 0.0f && doubleValue != 0.0 && Math.abs(doubleValue) < 1.1754943508222875E-38) {
            valueReplaced = true;
        }
        if (valueReplaced) {
            this.value = BigDecimal.valueOf(floatValue);
        }
    }

    @Override
    public float floatValue() {
        return this.value.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.value.doubleValue();
    }

    @Override
    public long longValue() {
        return this.value.longValue();
    }

    @Override
    public int intValue() {
        return this.value.intValue();
    }

    public boolean equals(Object o) {
        return o instanceof COSFloat && Float.floatToIntBits(((COSFloat)o).value.floatValue()) == Float.floatToIntBits(this.value.floatValue());
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.value.stripTrailingZeros().toPlainString();
    }

    @Override
    public void accept(COSVisitor visitor) throws IOException {
        visitor.visit(this);
    }
}

