/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.common.filespecification;

import java.util.Optional;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSObjectable;
import org.sejda.sambox.cos.COSStream;
import org.sejda.sambox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.sejda.sambox.pdmodel.common.filespecification.PDFileSpecification;

public class PDComplexFileSpecification
implements PDFileSpecification {
    private final COSDictionary fileSpecificationDictionary;
    private COSDictionary embeddedFileDictionary;

    public PDComplexFileSpecification(COSDictionary dict) {
        this.fileSpecificationDictionary = Optional.ofNullable(dict).orElseGet(COSDictionary::new);
        this.fileSpecificationDictionary.setItem(COSName.TYPE, (COSBase)COSName.FILESPEC);
    }

    @Override
    public COSDictionary getCOSObject() {
        return this.fileSpecificationDictionary;
    }

    private COSDictionary getEFDictionary() {
        if (this.embeddedFileDictionary == null && this.fileSpecificationDictionary != null) {
            this.embeddedFileDictionary = this.fileSpecificationDictionary.getDictionaryObject(COSName.EF, COSDictionary.class);
        }
        return this.embeddedFileDictionary;
    }

    private COSBase getObjectFromEFDictionary(COSName key) {
        COSDictionary ef = this.getEFDictionary();
        if (ef != null) {
            return ef.getDictionaryObject(key);
        }
        return null;
    }

    public String getFilename() {
        String filename = this.getFileUnicode();
        if (filename == null) {
            filename = this.getFileDos();
        }
        if (filename == null) {
            filename = this.getFileMac();
        }
        if (filename == null) {
            filename = this.getFileUnix();
        }
        if (filename == null) {
            filename = this.getFile();
        }
        return filename;
    }

    public String getFileUnicode() {
        return this.fileSpecificationDictionary.getString(COSName.UF);
    }

    public void setFileUnicode(String file) {
        this.fileSpecificationDictionary.setString(COSName.UF, file);
    }

    @Override
    public String getFile() {
        return this.fileSpecificationDictionary.getString(COSName.F);
    }

    @Override
    public void setFile(String file) {
        this.fileSpecificationDictionary.setString(COSName.F, file);
    }

    public String getFileDos() {
        return this.fileSpecificationDictionary.getString(COSName.DOS);
    }

    @Deprecated
    public void setFileDos(String file) {
        this.fileSpecificationDictionary.setString(COSName.DOS, file);
    }

    public String getFileMac() {
        return this.fileSpecificationDictionary.getString(COSName.MAC);
    }

    @Deprecated
    public void setFileMac(String file) {
        this.fileSpecificationDictionary.setString(COSName.MAC, file);
    }

    public String getFileUnix() {
        return this.fileSpecificationDictionary.getString(COSName.UNIX);
    }

    @Deprecated
    public void setFileUnix(String file) {
        this.fileSpecificationDictionary.setString(COSName.UNIX, file);
    }

    public void setVolatile(boolean fileIsVolatile) {
        this.fileSpecificationDictionary.setBoolean(COSName.V, fileIsVolatile);
    }

    public boolean isVolatile() {
        return this.fileSpecificationDictionary.getBoolean(COSName.V, false);
    }

    public PDEmbeddedFile getEmbeddedFile() {
        return this.embeddedFileFor(COSName.F);
    }

    public void setEmbeddedFile(PDEmbeddedFile file) {
        COSDictionary ef = this.getEFDictionary();
        if (ef == null && file != null) {
            ef = new COSDictionary();
            this.fileSpecificationDictionary.setItem(COSName.EF, (COSBase)ef);
        }
        if (ef != null) {
            ef.setItem(COSName.F, (COSObjectable)file);
        }
    }

    public PDEmbeddedFile getEmbeddedFileDos() {
        return this.embeddedFileFor(COSName.DOS);
    }

    @Deprecated
    public void setEmbeddedFileDos(PDEmbeddedFile file) {
        COSDictionary ef = this.getEFDictionary();
        if (ef == null && file != null) {
            ef = new COSDictionary();
            this.fileSpecificationDictionary.setItem(COSName.EF, (COSBase)ef);
        }
        if (ef != null) {
            ef.setItem(COSName.DOS, (COSObjectable)file);
        }
    }

    public PDEmbeddedFile getEmbeddedFileMac() {
        return this.embeddedFileFor(COSName.MAC);
    }

    @Deprecated
    public void setEmbeddedFileMac(PDEmbeddedFile file) {
        COSDictionary ef = this.getEFDictionary();
        if (ef == null && file != null) {
            ef = new COSDictionary();
            this.fileSpecificationDictionary.setItem(COSName.EF, (COSBase)ef);
        }
        if (ef != null) {
            ef.setItem(COSName.MAC, (COSObjectable)file);
        }
    }

    public PDEmbeddedFile getEmbeddedFileUnix() {
        return this.embeddedFileFor(COSName.UNIX);
    }

    @Deprecated
    public void setEmbeddedFileUnix(PDEmbeddedFile file) {
        COSDictionary ef = this.getEFDictionary();
        if (ef == null && file != null) {
            ef = new COSDictionary();
            this.fileSpecificationDictionary.setItem(COSName.EF, (COSBase)ef);
        }
        if (ef != null) {
            ef.setItem(COSName.UNIX, (COSObjectable)file);
        }
    }

    public PDEmbeddedFile getEmbeddedFileUnicode() {
        return this.embeddedFileFor(COSName.UF);
    }

    private PDEmbeddedFile embeddedFileFor(COSName key) {
        return Optional.ofNullable(this.getObjectFromEFDictionary(key)).filter(s -> s instanceof COSStream).map(s -> (COSStream)s).map(PDEmbeddedFile::new).orElse(null);
    }

    public void setEmbeddedFileUnicode(PDEmbeddedFile file) {
        COSDictionary ef = this.getEFDictionary();
        if (ef == null && file != null) {
            ef = new COSDictionary();
            this.fileSpecificationDictionary.setItem(COSName.EF, (COSBase)ef);
        }
        if (ef != null) {
            ef.setItem(COSName.UF, (COSObjectable)file);
        }
    }

    public PDEmbeddedFile getBestEmbeddedFile() {
        return Optional.ofNullable(this.getEmbeddedFileUnicode()).orElseGet(() -> Optional.ofNullable(this.getEmbeddedFileDos()).orElseGet(() -> Optional.ofNullable(this.getEmbeddedFileMac()).orElseGet(() -> Optional.ofNullable(this.getEmbeddedFileUnix()).orElseGet(() -> this.getEmbeddedFile()))));
    }

    public void setFileDescription(String description) {
        this.fileSpecificationDictionary.setString(COSName.DESC, description);
    }

    public String getFileDescription() {
        return this.fileSpecificationDictionary.getString(COSName.DESC);
    }

    public void setCollectionItem(COSDictionary dictionary) {
        this.fileSpecificationDictionary.setItem(COSName.CI, (COSBase)dictionary);
    }
}

