/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.encryption;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.io.CipherInputStream;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.sejda.commons.FastByteArrayOutputStream;
import org.sejda.commons.util.IOUtils;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSStream;
import org.sejda.sambox.cos.COSString;
import org.sejda.sambox.pdmodel.encryption.AccessPermission;
import org.sejda.sambox.pdmodel.encryption.DecryptionMaterial;
import org.sejda.sambox.pdmodel.encryption.MessageDigests;
import org.sejda.sambox.pdmodel.encryption.PDEncryption;
import org.sejda.sambox.pdmodel.encryption.RC4Cipher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SecurityHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityHandler.class);
    private static final short DEFAULT_KEY_LENGTH = 40;
    private static final byte[] AES_SALT = new byte[]{115, 65, 108, 84};
    protected short keyLength = (short)40;
    private byte[] encryptionKey;
    private final RC4Cipher rc4 = new RC4Cipher();
    private boolean decryptMetadata;
    private final Set<COSBase> objects = Collections.newSetFromMap(new IdentityHashMap());
    private boolean useAES;
    private AccessPermission currentAccessPermission = null;
    private COSName streamFilterName;
    private COSName stringFilterName;

    protected void setDecryptMetadata(boolean decryptMetadata) {
        this.decryptMetadata = decryptMetadata;
    }

    public boolean isDecryptMetadata() {
        return this.decryptMetadata;
    }

    protected void setStringFilterName(COSName stringFilterName) {
        this.stringFilterName = stringFilterName;
    }

    protected void setStreamFilterName(COSName streamFilterName) {
        this.streamFilterName = streamFilterName;
    }

    public abstract void prepareForDecryption(PDEncryption var1, COSArray var2, DecryptionMaterial var3) throws IOException;

    private void decryptData(long objectNumber, long genNumber, InputStream data, OutputStream output) throws IOException {
        if (this.useAES && this.encryptionKey.length == 32) {
            this.decryptDataAES256(data, output);
        } else {
            byte[] finalKey = this.calcFinalKey(objectNumber, genNumber);
            if (this.useAES) {
                this.decryptDataAESother(finalKey, data, output);
            } else {
                this.decryptDataRC4(finalKey, data, output);
            }
        }
        IOUtils.close((Closeable)output);
    }

    private byte[] calcFinalKey(long objectNumber, long genNumber) {
        byte[] newKey = new byte[this.encryptionKey.length + 5];
        System.arraycopy(this.encryptionKey, 0, newKey, 0, this.encryptionKey.length);
        newKey[newKey.length - 5] = (byte)(objectNumber & 0xFFL);
        newKey[newKey.length - 4] = (byte)(objectNumber >> 8 & 0xFFL);
        newKey[newKey.length - 3] = (byte)(objectNumber >> 16 & 0xFFL);
        newKey[newKey.length - 2] = (byte)(genNumber & 0xFFL);
        newKey[newKey.length - 1] = (byte)(genNumber >> 8 & 0xFFL);
        MessageDigest md = MessageDigests.getMD5();
        md.update(newKey);
        if (this.useAES) {
            md.update(AES_SALT);
        }
        byte[] digestedKey = md.digest();
        int length = Math.min(newKey.length, 16);
        byte[] finalKey = new byte[length];
        System.arraycopy(digestedKey, 0, finalKey, 0, length);
        return finalKey;
    }

    protected void decryptDataRC4(byte[] finalKey, InputStream input, OutputStream output) throws IOException {
        this.rc4.setKey(finalKey);
        this.rc4.write(input, output);
    }

    protected void decryptDataRC4(byte[] finalKey, byte[] input, OutputStream output) throws IOException {
        this.rc4.setKey(finalKey);
        this.rc4.write(input, output);
    }

    private void decryptDataAESother(byte[] finalKey, InputStream data, OutputStream output) throws IOException {
        byte[] iv = new byte[16];
        int ivSize = data.read(iv);
        if (ivSize == -1) {
            return;
        }
        if (ivSize != iv.length) {
            throw new IOException("AES initialization vector not fully read: only " + ivSize + " bytes read instead of " + iv.length);
        }
        try {
            int n;
            Cipher decryptCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            SecretKeySpec aesKey = new SecretKeySpec(finalKey, "AES");
            IvParameterSpec ips = new IvParameterSpec(iv);
            decryptCipher.init(2, (Key)aesKey, ips);
            byte[] buffer = new byte[256];
            while ((n = data.read(buffer)) != -1) {
                byte[] update = decryptCipher.update(buffer, 0, n);
                if (update == null) continue;
                output.write(update);
            }
            output.write(decryptCipher.doFinal());
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new IOException(e);
        }
    }

    private void decryptDataAES256(InputStream data, OutputStream output) throws IOException {
        byte[] iv = new byte[16];
        int ivSize = data.read(iv);
        if (ivSize == -1) {
            return;
        }
        if (ivSize != iv.length) {
            throw new IOException("AES initialization vector not fully read: only " + ivSize + " bytes read instead of " + iv.length);
        }
        PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new AESFastEngine()));
        cipher.init(false, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(this.encryptionKey), iv));
        try (CipherInputStream cis = new CipherInputStream(data, (BufferedBlockCipher)cipher);){
            IOUtils.copy((InputStream)cis, (OutputStream)output);
        }
    }

    public void decrypt(COSBase obj, long objNum, long genNum) throws IOException {
        if (obj instanceof COSString) {
            if (this.objects.contains(obj)) {
                return;
            }
            this.objects.add(obj);
            this.decryptString((COSString)obj, objNum, genNum);
        } else if (obj instanceof COSStream) {
            if (this.objects.contains(obj)) {
                return;
            }
            this.objects.add(obj);
            this.decryptStream((COSStream)obj, objNum, genNum);
        } else if (obj instanceof COSDictionary) {
            this.decryptDictionary((COSDictionary)obj, objNum, genNum);
        } else if (obj instanceof COSArray) {
            this.decryptArray((COSArray)obj, objNum, genNum);
        }
    }

    public void decryptStream(COSStream stream, long objNum, long genNum) throws IOException {
        if (!COSName.IDENTITY.equals(this.streamFilterName)) {
            COSName type = stream.getCOSName(COSName.TYPE);
            if (!this.decryptMetadata && COSName.METADATA.equals(type)) {
                return;
            }
            if (COSName.XREF.equals(type)) {
                return;
            }
            if (COSName.METADATA.equals(type)) {
                byte[] buf = new byte[10];
                try (InputStream is = stream.getUnfilteredStream();){
                    is.read(buf);
                }
                if (Arrays.equals(buf, "<?xpacket ".getBytes(StandardCharsets.ISO_8859_1))) {
                    LOG.warn("Metadata is not encrypted, but was expected to be");
                    LOG.warn("Read PDF specification about EncryptMetadata (default value: true)");
                    return;
                }
            }
            this.decryptDictionary(stream, objNum, genNum);
            byte[] encrypted = IOUtils.toByteArray((InputStream)stream.getFilteredStream());
            ByteArrayInputStream encryptedStream = new ByteArrayInputStream(encrypted);
            try (OutputStream output = stream.createFilteredStream();){
                this.decryptData(objNum, genNum, encryptedStream, output);
            }
            catch (IOException e) {
                LOG.error("An error occurred decrypting object {} {}", (Object)objNum, (Object)genNum);
                throw e;
            }
        }
    }

    private void decryptDictionary(COSDictionary dictionary, long objNum, long genNum) throws IOException {
        if (dictionary.getItem(COSName.CF) != null) {
            return;
        }
        COSBase type = dictionary.getDictionaryObject(COSName.TYPE);
        boolean isSignature = COSName.SIG.equals(type) || COSName.DOC_TIME_STAMP.equals(type) || dictionary.getDictionaryObject(COSName.CONTENTS) instanceof COSString && dictionary.getDictionaryObject(COSName.BYTERANGE) instanceof COSArray;
        for (Map.Entry<COSName, COSBase> entry : dictionary.entrySet()) {
            COSBase value;
            if (isSignature && COSName.CONTENTS.equals(entry.getKey()) || !((value = entry.getValue()) instanceof COSString) && !(value instanceof COSArray) && !(value instanceof COSDictionary)) continue;
            this.decrypt(value, objNum, genNum);
        }
    }

    private void decryptString(COSString string, long objNum, long genNum) throws IOException {
        if (!COSName.IDENTITY.equals(this.stringFilterName)) {
            ByteArrayInputStream data = new ByteArrayInputStream(string.getBytes());
            FastByteArrayOutputStream outputStream = new FastByteArrayOutputStream();
            try {
                this.decryptData(objNum, genNum, data, (OutputStream)outputStream);
                string.setValue(outputStream.toByteArray());
            }
            catch (IOException ex) {
                LOG.error("Failed to decrypt COSString of length " + string.getBytes().length + " in object " + objNum + ": " + ex.getMessage());
            }
        }
    }

    private void decryptArray(COSArray array, long objNum, long genNum) throws IOException {
        for (int i = 0; i < array.size(); ++i) {
            this.decrypt(array.get(i), objNum, genNum);
        }
    }

    public int getKeyLength() {
        return this.keyLength;
    }

    public void setKeyLength(int keyLen) {
        this.keyLength = (short)keyLen;
    }

    public void setCurrentAccessPermission(AccessPermission currentAccessPermission) {
        this.currentAccessPermission = currentAccessPermission;
    }

    public AccessPermission getCurrentAccessPermission() {
        return this.currentAccessPermission;
    }

    public boolean isAES() {
        return this.useAES;
    }

    public void setAES(boolean aesValue) {
        this.useAES = aesValue;
    }

    public byte[] getEncryptionKey() {
        return this.encryptionKey;
    }

    protected void setEncryptionKey(byte[] encryptionKey) {
        this.encryptionKey = encryptionKey;
    }
}

