/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.interactive.documentnavigation.outline;

import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSObjectable;
import org.sejda.sambox.pdmodel.common.PDDictionaryWrapper;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.outline.PDOutlineItemIterator;

public abstract class PDOutlineNode
extends PDDictionaryWrapper {
    public PDOutlineNode() {
    }

    public PDOutlineNode(COSDictionary dict) {
        super(dict);
    }

    PDOutlineNode getParent() {
        COSDictionary item = this.getCOSObject().getDictionaryObject(COSName.PARENT, COSDictionary.class);
        if (item != null) {
            if (COSName.OUTLINES.equals(item.getCOSName(COSName.TYPE))) {
                return new PDDocumentOutline(item);
            }
            return new PDOutlineItem(item);
        }
        return null;
    }

    void setParent(PDOutlineNode parent) {
        this.getCOSObject().setItem(COSName.PARENT, (COSObjectable)parent);
    }

    public void addLast(PDOutlineItem newChild) {
        this.requireSingleNode(newChild);
        this.append(newChild);
        this.updateParentOpenCountForAddedChild(newChild);
    }

    public void addAtPosition(PDOutlineItem newChild, int index) {
        this.requireSingleNode(newChild);
        this.insert(newChild, index);
        this.updateParentOpenCountForAddedChild(newChild);
    }

    public void addFirst(PDOutlineItem newChild) {
        this.requireSingleNode(newChild);
        this.prepend(newChild);
        this.updateParentOpenCountForAddedChild(newChild);
    }

    void requireSingleNode(PDOutlineItem node) {
        if (node.getNextSibling() != null || node.getPreviousSibling() != null) {
            throw new IllegalArgumentException("A single node with no siblings is required");
        }
    }

    private void append(PDOutlineItem newChild) {
        newChild.setParent(this);
        if (!this.hasChildren()) {
            this.setFirstChild(newChild);
        } else {
            PDOutlineItem previousLastChild = this.getLastChild();
            previousLastChild.setNextSibling(newChild);
            newChild.setPreviousSibling(previousLastChild);
        }
        this.setLastChild(newChild);
    }

    private void prepend(PDOutlineItem newChild) {
        newChild.setParent(this);
        if (!this.hasChildren()) {
            this.setLastChild(newChild);
        } else {
            PDOutlineItem previousFirstChild = this.getFirstChild();
            newChild.setNextSibling(previousFirstChild);
            previousFirstChild.setPreviousSibling(newChild);
        }
        this.setFirstChild(newChild);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void insert(PDOutlineItem newChild, int index) {
        newChild.setParent(this);
        if (this.hasChildren()) {
            int currentIndex;
            Iterator<PDOutlineItem> iterator = this.children().iterator();
            PDOutlineItem current = iterator.next();
            for (currentIndex = 0; currentIndex < index && iterator.hasNext(); ++currentIndex) {
                current = iterator.next();
            }
            if (currentIndex == index) {
                PDOutlineItem prev = current.getPreviousSibling();
                current.setPreviousSibling(newChild);
                newChild.setNextSibling(current);
                newChild.setPreviousSibling(prev);
                if (prev != null) {
                    prev.setNextSibling(newChild);
                    return;
                } else {
                    this.setFirstChild(newChild);
                }
                return;
            } else {
                if (currentIndex + 1 > index) throw new RuntimeException("Cannot insert at: currentIndex: " + currentIndex + " index: " + index);
                newChild.setPreviousSibling(current);
                current.setNextSibling(newChild);
                this.setLastChild(newChild);
            }
            return;
        } else {
            this.setFirstChild(newChild);
            this.setLastChild(newChild);
        }
    }

    void updateParentOpenCountForAddedChild(PDOutlineItem newChild) {
        int delta = 1;
        if (newChild.isNodeOpen()) {
            delta += newChild.getOpenCount();
        }
        newChild.updateParentOpenCount(delta);
    }

    public boolean hasChildren() {
        return Objects.nonNull(this.getCOSObject().getDictionaryObject(COSName.FIRST, COSDictionary.class));
    }

    PDOutlineItem getOutlineItem(COSName name) {
        return Optional.ofNullable(this.getCOSObject().getDictionaryObject(name, COSDictionary.class)).map(PDOutlineItem::new).orElse(null);
    }

    public PDOutlineItem getFirstChild() {
        return this.getOutlineItem(COSName.FIRST);
    }

    void setFirstChild(PDOutlineNode outlineNode) {
        this.getCOSObject().setItem(COSName.FIRST, (COSObjectable)outlineNode);
    }

    public PDOutlineItem getLastChild() {
        return this.getOutlineItem(COSName.LAST);
    }

    void setLastChild(PDOutlineNode outlineNode) {
        this.getCOSObject().setItem(COSName.LAST, (COSObjectable)outlineNode);
    }

    public int getOpenCount() {
        return this.getCOSObject().getInt(COSName.COUNT, 0);
    }

    void setOpenCount(int openCount) {
        this.getCOSObject().setInt(COSName.COUNT, openCount);
    }

    public void openNode() {
        if (!this.isNodeOpen()) {
            this.switchNodeCount();
        }
    }

    public void closeNode() {
        if (this.isNodeOpen()) {
            this.switchNodeCount();
        }
    }

    private void switchNodeCount() {
        int openCount = this.getOpenCount();
        this.setOpenCount(-openCount);
        this.updateParentOpenCount(-openCount);
    }

    public boolean isNodeOpen() {
        return this.getOpenCount() > 0;
    }

    void updateParentOpenCount(int delta) {
        PDOutlineNode parent = this.getParent();
        if (parent != null) {
            if (parent.isNodeOpen()) {
                parent.setOpenCount(parent.getOpenCount() + delta);
                parent.updateParentOpenCount(delta);
            } else {
                parent.setOpenCount(parent.getOpenCount() - delta);
            }
        }
    }

    public Iterable<PDOutlineItem> children() {
        return new Iterable<PDOutlineItem>(){

            @Override
            public Iterator<PDOutlineItem> iterator() {
                return new PDOutlineItemIterator(PDOutlineNode.this.getFirstChild());
            }
        };
    }
}

