/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.interactive.form;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSArrayList;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSString;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAppearanceEntry;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.sejda.sambox.pdmodel.interactive.form.PDAcroForm;
import org.sejda.sambox.pdmodel.interactive.form.PDCheckBox;
import org.sejda.sambox.pdmodel.interactive.form.PDNonTerminalField;
import org.sejda.sambox.pdmodel.interactive.form.PDRadioButton;
import org.sejda.sambox.pdmodel.interactive.form.PDTerminalField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PDButton
extends PDTerminalField {
    private static final Logger LOG = LoggerFactory.getLogger(PDButton.class);
    static final int FLAG_RADIO = 32768;
    static final int FLAG_PUSHBUTTON = 65536;
    static final int FLAG_RADIOS_IN_UNISON = 0x2000000;
    private boolean ignoreExportOptions = false;

    public PDButton(PDAcroForm acroForm) {
        super(acroForm);
        this.getCOSObject().setItem(COSName.FT, (COSBase)COSName.BTN);
    }

    PDButton(PDAcroForm acroForm, COSDictionary field, PDNonTerminalField parent) {
        super(acroForm, field, parent);
    }

    public boolean isPushButton() {
        return this.getCOSObject().getFlag(COSName.FF, 65536);
    }

    @Deprecated
    public void setPushButton(boolean pushbutton) {
        this.getCOSObject().setFlag(COSName.FF, 65536, pushbutton);
        if (pushbutton) {
            this.setRadioButton(false);
        }
    }

    public boolean isRadioButton() {
        return this.getCOSObject().getFlag(COSName.FF, 32768);
    }

    @Deprecated
    public void setRadioButton(boolean radiobutton) {
        this.getCOSObject().setFlag(COSName.FF, 32768, radiobutton);
        if (radiobutton) {
            this.setPushButton(false);
        }
    }

    public String getValue() {
        COSBase value = this.getInheritableAttribute(COSName.V);
        if (value instanceof COSName) {
            String stringValue = ((COSName)value).getName();
            if (this.ignoreExportOptions) {
                return stringValue;
            }
            List<String> exportValues = this.getExportValues();
            if (!exportValues.isEmpty()) {
                try {
                    int idx = Integer.parseInt(stringValue, 10);
                    if (idx >= 0 && idx < exportValues.size()) {
                        return exportValues.get(idx);
                    }
                }
                catch (NumberFormatException nfe) {
                    return stringValue;
                }
            }
            return stringValue;
        }
        return "Off";
    }

    @Override
    public void setValue(String value) throws IOException {
        boolean hasExportValues;
        this.checkValue(value);
        boolean bl = hasExportValues = this.getExportValues().size() > 0;
        if (hasExportValues && !this.ignoreExportOptions) {
            this.updateByOption(value);
        } else {
            this.updateByValue(value);
        }
        this.applyChange();
    }

    public void setValue(int index) throws IOException {
        if (this.getExportValues().isEmpty() || index < 0 || index >= this.getExportValues().size()) {
            throw new IllegalArgumentException("index '" + index + "' is not a valid index for the field " + this.getFullyQualifiedName() + ", valid indices are from 0 to " + (this.getExportValues().size() - 1));
        }
        this.updateByValue(String.valueOf(index));
        this.applyChange();
    }

    public String getDefaultValue() {
        COSBase value = this.getInheritableAttribute(COSName.DV);
        if (value instanceof COSName) {
            return ((COSName)value).getName();
        }
        return "";
    }

    public void setDefaultValue(String value) {
        this.checkValue(value);
        this.getCOSObject().setName(COSName.DV, value);
    }

    @Override
    public String getValueAsString() {
        return this.getValue();
    }

    public List<String> getExportValues() {
        COSBase value = this.getInheritableAttribute(COSName.OPT);
        if (value instanceof COSString) {
            ArrayList<String> array = new ArrayList<String>();
            array.add(((COSString)value).getString());
            return array;
        }
        if (value instanceof COSArray) {
            return COSArrayList.convertCOSStringCOSArrayToList((COSArray)value);
        }
        return Collections.emptyList();
    }

    public void setExportValues(List<String> values) {
        if (values != null && !values.isEmpty()) {
            COSArray cosValues = COSArrayList.convertStringListToCOSStringCOSArray(values);
            this.getCOSObject().setItem(COSName.OPT, (COSBase)cosValues);
        } else {
            this.getCOSObject().removeItem(COSName.OPT);
        }
    }

    @Override
    void constructAppearances() throws IOException {
        List<String> exportValues = this.getExportValues();
        if (exportValues.size() > 0 && !this.ignoreExportOptions) {
            try {
                int optionsIndex = Integer.parseInt(this.getValue());
                if (optionsIndex < exportValues.size()) {
                    this.updateByOption(exportValues.get(optionsIndex));
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            this.updateByValue(this.getValue());
        }
    }

    public Set<String> getOnValues() {
        HashSet<String> onValues = new HashSet<String>();
        if (!this.ignoreExportOptions) {
            onValues.addAll(this.getExportValues());
        }
        onValues.addAll(this.getNormalAppearanceValues());
        return onValues;
    }

    public List<String> getNormalAppearanceValues() {
        ArrayList<String> values = new ArrayList<String>();
        List<PDAnnotationWidget> widgets = this.getWidgets();
        for (PDAnnotationWidget widget : widgets) {
            String value = this.getOnValueForWidget(widget);
            if (value == null) continue;
            values.add(value);
        }
        return values;
    }

    private String getOnValue(int index) {
        List<PDAnnotationWidget> widgets = this.getWidgets();
        if (index < widgets.size()) {
            return this.getOnValueForWidget(widgets.get(index));
        }
        return null;
    }

    public String getOnValueForWidget(PDAnnotationWidget widget) {
        PDAppearanceEntry normalAppearance;
        PDAppearanceDictionary apDictionary = widget.getAppearance();
        if (apDictionary != null && (normalAppearance = apDictionary.getNormalAppearance()) != null && normalAppearance.isSubDictionary()) {
            Map<COSName, PDAppearanceStream> subDictionary = normalAppearance.getSubDictionary();
            TreeSet<COSName> entries = new TreeSet<COSName>(subDictionary.keySet());
            for (COSName entry : entries) {
                if (COSName.Off.compareTo(entry) == 0 || entries.size() > 2 && subDictionary.get(entry) == null) continue;
                return entry.getName();
            }
        }
        return null;
    }

    void checkValue(String value) {
        Set<String> onValues = this.getOnValues();
        if (onValues.isEmpty()) {
            return;
        }
        if (COSName.Off.getName().compareTo(value) != 0 && !onValues.contains(value)) {
            throw new IllegalArgumentException("value '" + value + "' is not a valid option for the field " + this.getFullyQualifiedName() + ", valid values are: " + onValues + " and " + COSName.Off.getName());
        }
    }

    private void updateByValue(String value) {
        this.getCOSObject().setName(COSName.V, value);
        for (PDAnnotationWidget widget : this.getWidgets()) {
            PDAppearanceDictionary appearance = widget.getAppearance();
            PDAppearanceEntry normalAppearance = null;
            Set<Object> entries = new HashSet();
            if (appearance != null && (normalAppearance = widget.getAppearance().getNormalAppearance()) != null && normalAppearance.isSubDictionary()) {
                entries = normalAppearance.getSubDictionary().keySet().stream().map(COSName::getName).collect(Collectors.toSet());
                if (entries.contains(value)) {
                    widget.setAppearanceState(value);
                } else {
                    widget.setAppearanceState(COSName.Off.getName());
                }
            }
            if (!entries.isEmpty() && (entries.size() != 1 || !entries.contains("Off"))) continue;
            if (this instanceof PDCheckBox) {
                PDCheckBox checkBox = (PDCheckBox)this;
                if (checkBox.getOnValue().equals(value)) {
                    widget.setAppearanceState(value);
                } else {
                    widget.setAppearanceState(COSName.Off.getName());
                }
            }
            if (normalAppearance == null || normalAppearance.isSubDictionary() || !(this instanceof PDRadioButton) && !(this instanceof PDCheckBox)) continue;
            throw new RuntimeException("Check/radio has a single normal appearance, might look the same when checked or not");
        }
    }

    private void updateByOption(String value) throws IOException {
        List<PDAnnotationWidget> widgets = this.getWidgets();
        List<String> options = this.getExportValues();
        if (widgets.size() != options.size()) {
            throw new IllegalArgumentException("The number of options doesn't match the number of widgets");
        }
        if (value.equals(COSName.Off.getName())) {
            this.updateByValue(value);
        } else {
            int optionsIndex = options.indexOf(value);
            if (optionsIndex != -1) {
                this.updateByValue(this.getOnValue(optionsIndex));
            }
        }
    }

    public boolean isIgnoreExportOptions() {
        return this.ignoreExportOptions;
    }

    public void setIgnoreExportOptions(boolean ignoreExportOptions) {
        this.ignoreExportOptions = ignoreExportOptions;
    }
}

