/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.contentstream.operator.text;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.sejda.sambox.contentstream.operator.MissingOperandException;
import org.sejda.sambox.contentstream.operator.Operator;
import org.sejda.sambox.contentstream.operator.OperatorProcessor;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSNumber;
import org.sejda.sambox.pdmodel.font.PDFont;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetFontAndSize
extends OperatorProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(SetFontAndSize.class);

    @Override
    public void process(Operator operator, List<COSBase> arguments) throws IOException {
        if (arguments.size() < 2) {
            throw new MissingOperandException(operator, arguments);
        }
        COSBase base0 = arguments.get(0);
        COSBase base1 = arguments.get(1);
        if (!(base0 instanceof COSName)) {
            return;
        }
        if (!(base1 instanceof COSNumber)) {
            return;
        }
        COSName fontName = (COSName)base0;
        float fontSize = ((COSNumber)base1).floatValue();
        this.getContext().getGraphicsState().getTextState().setFontSize(fontSize);
        PDFont font = this.getContext().getResources().getFont(fontName);
        if (Objects.isNull(font)) {
            LOG.warn("font '{}' not found in resources", (Object)fontName.getName());
        }
        this.getContext().getGraphicsState().getTextState().setFont(font);
    }

    @Override
    public String getName() {
        return "Tf";
    }
}

