/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.font;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.apache.fontbox.ttf.TrueTypeFont;

public final class FontUtils {
    private static final String BASE25 = "BCDEFGHIJKLMNOPQRSTUVWXYZ";

    private FontUtils() {
    }

    public static boolean isEmbeddingPermitted(TrueTypeFont ttf) throws IOException {
        if (ttf.getOS2Windows() != null) {
            short fsType = ttf.getOS2Windows().getFsType();
            int maskedFsType = fsType & 0xF;
            if (maskedFsType == 2) {
                return false;
            }
            if ((fsType & 0x200) == 512) {
                return false;
            }
        }
        return true;
    }

    public static boolean isSubsettingPermitted(TrueTypeFont ttf) throws IOException {
        short fsType;
        return ttf.getOS2Windows() == null || ((fsType = ttf.getOS2Windows().getFsType()) & 0x100) != 256;
    }

    public static String getTag(Map<Integer, Integer> gidToCid) {
        long div;
        long num = gidToCid.hashCode();
        StringBuilder sb = new StringBuilder();
        do {
            div = num / 25L;
            int mod = (int)(num % 25L);
            sb.append(BASE25.charAt(mod));
        } while ((num = div) != 0L && sb.length() < 6);
        while (sb.length() < 6) {
            sb.insert(0, 'A');
        }
        return sb.append('+').toString();
    }

    public static String getTag() {
        StringBuilder sb = new StringBuilder("");
        for (int k = 0; k < 6; ++k) {
            sb.append((char)(Math.random() * 26.0 + 65.0));
        }
        return sb.append('+').toString();
    }

    public static boolean isSubsetFontName(String name) {
        String[] nameFragments = Optional.ofNullable(name).map(String::trim).map(s -> s.split("\\+")).orElseGet(() -> new String[0]);
        return nameFragments.length == 2 && nameFragments[0].length() == 6;
    }
}

