/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.interactive.documentnavigation.destination;

import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSInteger;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSNumber;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.PDPageTree;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import org.sejda.sambox.util.Matrix;

public abstract class PDPageDestination
extends PDDestination {
    protected final COSArray array;

    protected PDPageDestination() {
        this.array = new COSArray();
    }

    protected PDPageDestination(COSArray array) {
        this.array = array;
    }

    public PDPage getPage() {
        COSBase page;
        if (this.array.size() > 0 && (page = this.array.getObject(0)) instanceof COSDictionary) {
            return new PDPage((COSDictionary)page);
        }
        return null;
    }

    public void setPage(PDPage page) {
        this.array.set(0, page);
    }

    public int getPageNumber() {
        COSBase page;
        if (this.array.size() > 0 && (page = this.array.getObject(0)) instanceof COSNumber) {
            return ((COSNumber)page).intValue();
        }
        return -1;
    }

    public int retrievePageNumber() {
        if (this.array.size() > 0) {
            COSBase page = this.array.getObject(0);
            if (page instanceof COSNumber) {
                return ((COSNumber)page).intValue();
            }
            if (page instanceof COSDictionary) {
                return this.indexOfPageTree((COSDictionary)page);
            }
        }
        return -1;
    }

    private int indexOfPageTree(COSDictionary pageDict) {
        COSDictionary parent = pageDict;
        while (parent.getDictionaryObject(COSName.PARENT, COSName.P) instanceof COSDictionary) {
            parent = (COSDictionary)parent.getDictionaryObject(COSName.PARENT, COSName.P);
        }
        if (parent.containsKey(COSName.KIDS) && COSName.PAGES.equals(parent.getItem(COSName.TYPE))) {
            PDPageTree pages = new PDPageTree(parent);
            return pages.indexOf(new PDPage(pageDict));
        }
        return -1;
    }

    public void setPageNumber(int pageNumber) {
        this.array.set(0, COSInteger.get(pageNumber));
    }

    @Override
    public COSArray getCOSObject() {
        return this.array;
    }

    public abstract void transform(Matrix var1);
}

