/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.interactive.documentnavigation.outline;

import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Queue;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;

public class PDOutlineTreeIterator
implements Iterator<PDOutlineItem> {
    private final LinkedHashSet<PDOutlineItem> elements = new LinkedHashSet();
    private final Queue<PDOutlineItem> queue = new ArrayDeque<PDOutlineItem>();

    public PDOutlineTreeIterator(PDDocumentOutline outline) {
        if (Objects.nonNull(outline)) {
            this.enqueueChildren(outline.children());
        }
    }

    private void enqueueChildren(Iterable<PDOutlineItem> children) {
        for (PDOutlineItem item : children) {
            if (this.elements.contains(item)) continue;
            if (item.hasChildren()) {
                this.elements.add(item);
                this.enqueueChildren(item.children());
                continue;
            }
            this.elements.add(item);
        }
    }

    @Override
    public boolean hasNext() {
        return !this.elements.isEmpty();
    }

    @Override
    public PDOutlineItem next() {
        PDOutlineItem next = (PDOutlineItem)this.elements.stream().findFirst().orElseThrow(NoSuchElementException::new);
        this.elements.remove(next);
        return next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

