/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.interactive.form;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.sejda.commons.util.RequireUtils;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.pdmodel.common.PDDictionaryWrapper;
import org.sejda.sambox.pdmodel.interactive.action.PDFormFieldAdditionalActions;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.sejda.sambox.pdmodel.interactive.form.PDAcroForm;
import org.sejda.sambox.pdmodel.interactive.form.PDFieldFactory;
import org.sejda.sambox.pdmodel.interactive.form.PDNonTerminalField;

public abstract class PDField
extends PDDictionaryWrapper {
    private static final int FLAG_READ_ONLY = 1;
    private static final int FLAG_REQUIRED = 2;
    private static final int FLAG_NO_EXPORT = 4;
    private final PDAcroForm acroForm;
    private final PDNonTerminalField parent;

    PDField(PDAcroForm acroForm) {
        this(acroForm, new COSDictionary(), null);
    }

    PDField(PDAcroForm acroForm, COSDictionary dictionary, PDNonTerminalField parent) {
        super(dictionary);
        this.acroForm = acroForm;
        this.parent = parent;
    }

    static PDField fromDictionary(PDAcroForm form, COSDictionary field, PDNonTerminalField parent) {
        return PDFieldFactory.createField(form, field, parent);
    }

    protected COSBase getInheritableAttribute(COSName key) {
        if (this.getCOSObject().containsKey(key)) {
            return this.getCOSObject().getDictionaryObject(key);
        }
        if (this.parent != null) {
            return this.parent.getInheritableAttribute(key);
        }
        return this.acroForm.getCOSObject().getDictionaryObject(key);
    }

    public abstract String getFieldType();

    public abstract String getValueAsString();

    public abstract void setValue(String var1) throws IOException;

    public abstract List<PDAnnotationWidget> getWidgets();

    public void setReadonly(boolean readonly) {
        this.getCOSObject().setFlag(COSName.FF, 1, readonly);
    }

    public boolean isReadonly() {
        return this.getCOSObject().getFlag(COSName.FF, 1);
    }

    public void setRequired(boolean required) {
        this.getCOSObject().setFlag(COSName.FF, 2, required);
    }

    public boolean isRequired() {
        return this.getCOSObject().getFlag(COSName.FF, 2);
    }

    public void setNoExport(boolean noExport) {
        this.getCOSObject().setFlag(COSName.FF, 4, noExport);
    }

    public boolean isNoExport() {
        return this.getCOSObject().getFlag(COSName.FF, 4);
    }

    public abstract int getFieldFlags();

    public void setFieldFlags(int flags) {
        this.getCOSObject().setInt(COSName.FF, flags);
    }

    public PDFormFieldAdditionalActions getActions() {
        return Optional.ofNullable(this.getCOSObject().getDictionaryObject(COSName.AA, COSDictionary.class)).map(PDFormFieldAdditionalActions::new).orElse(null);
    }

    public PDNonTerminalField getParent() {
        return this.parent;
    }

    PDField findKid(String[] name, int nameIndex) {
        PDField retval = null;
        COSArray kids = (COSArray)this.getCOSObject().getDictionaryObject(COSName.KIDS);
        if (kids != null) {
            for (int i = 0; retval == null && i < kids.size(); ++i) {
                COSDictionary kidDictionary = (COSDictionary)kids.getObject(i);
                if (!name[nameIndex].equals(kidDictionary.getString(COSName.T))) continue;
                retval = PDField.fromDictionary(this.acroForm, kidDictionary, (PDNonTerminalField)this);
                if (name.length <= nameIndex + 1) continue;
                retval = retval.findKid(name, nameIndex + 1);
            }
        }
        return retval;
    }

    public PDAcroForm getAcroForm() {
        return this.acroForm;
    }

    public String getPartialName() {
        return this.getCOSObject().getString(COSName.T);
    }

    public void setPartialName(String name) {
        RequireUtils.requireArg((!name.contains(".") ? 1 : 0) != 0, (String)("A field partial name shall not contain a period character: " + name));
        this.getCOSObject().setString(COSName.T, name);
    }

    public String getFullyQualifiedName() {
        String parentName;
        String finalName = this.getPartialName();
        String string = parentName = this.parent != null ? this.parent.getFullyQualifiedName() : null;
        if (parentName != null) {
            finalName = finalName != null ? parentName + "." + finalName : parentName;
        }
        return finalName;
    }

    public String getAlternateFieldName() {
        return this.getCOSObject().getString(COSName.TU);
    }

    public void setAlternateFieldName(String alternateFieldName) {
        this.getCOSObject().setString(COSName.TU, alternateFieldName);
    }

    public String getMappingName() {
        return this.getCOSObject().getString(COSName.TM);
    }

    public void setMappingName(String mappingName) {
        this.getCOSObject().setString(COSName.TM, mappingName);
    }

    public abstract boolean isTerminal();

    public String toString() {
        return this.getFullyQualifiedName() + "{type: " + this.getClass().getSimpleName() + " value: " + this.getInheritableAttribute(COSName.V) + "}";
    }
}

