/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.cos;

import java.io.IOException;
import java.util.Optional;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSNull;
import org.sejda.sambox.cos.COSVisitor;
import org.sejda.sambox.cos.DisposableCOSObject;
import org.sejda.sambox.xref.XrefEntry;

public class IndirectCOSObjectReference
extends COSBase
implements DisposableCOSObject {
    private COSBase baseObject;
    private XrefEntry xrefEntry;

    public IndirectCOSObjectReference(long objectNumber, int generationNumber, COSBase baseObject) {
        this.xrefEntry = XrefEntry.unknownOffsetEntry(objectNumber, generationNumber);
        this.baseObject = baseObject;
    }

    @Override
    public void accept(COSVisitor visitor) throws IOException {
        visitor.visit(this);
    }

    public XrefEntry xrefEntry() {
        return this.xrefEntry;
    }

    public void setValue(COSBase baseObject) {
        this.baseObject = baseObject;
    }

    @Override
    public COSBase getCOSObject() {
        return Optional.ofNullable(this.baseObject).orElse(COSNull.NULL);
    }

    @Override
    public void releaseCOSObject() {
        if (this.baseObject instanceof DisposableCOSObject) {
            ((DisposableCOSObject)((Object)this.baseObject)).releaseCOSObject();
        }
        this.baseObject = null;
    }

    public String toString() {
        return this.xrefEntry().key().objectNumber() + " " + this.xrefEntry().key().generation() + " R";
    }
}

