/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.output;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.sejda.commons.util.IOUtils;
import org.sejda.commons.util.RequireUtils;
import org.sejda.io.CountingWritableByteChannel;
import org.sejda.sambox.encryption.EncryptionContext;
import org.sejda.sambox.input.IncrementablePDDocument;
import org.sejda.sambox.output.AsyncPDFBodyObjectsWriter;
import org.sejda.sambox.output.DefaultPDFWriter;
import org.sejda.sambox.output.IncrementalPDFBodyWriter;
import org.sejda.sambox.output.IndirectObjectsWriter;
import org.sejda.sambox.output.ObjectsStreamPDFBodyObjectsWriter;
import org.sejda.sambox.output.PDFBodyObjectsWriter;
import org.sejda.sambox.output.PDFBodyWriter;
import org.sejda.sambox.output.PDFWriteContext;
import org.sejda.sambox.output.SyncPDFBodyObjectsWriter;
import org.sejda.sambox.output.WriteOption;
import org.sejda.sambox.util.SpecVersionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementablePDDocumentWriter
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(IncrementablePDDocumentWriter.class);
    private DefaultPDFWriter writer;
    private PDFWriteContext context;
    private CountingWritableByteChannel channel;
    private Set<WriteOption> options;

    public IncrementablePDDocumentWriter(CountingWritableByteChannel channel, WriteOption ... options) {
        RequireUtils.requireNotNullArg((Object)channel, (String)"Cannot write to a null channel");
        this.channel = channel;
        this.options = Optional.ofNullable(options).map(Arrays::asList).map(HashSet::new).orElseGet(HashSet::new);
    }

    public void write(IncrementablePDDocument document) throws IOException {
        RequireUtils.requireNotNullArg((Object)document, (String)"Incremented document cannot be null");
        RequireUtils.requireState((document.trailer().xrefOffset() != -1L ? 1 : 0) != 0, (String)"The incremented document has errors and its xref table couldn't be found");
        this.sanitizeWriteOptions(document);
        this.context = new PDFWriteContext(document.highestExistingReference().objectNumber(), EncryptionContext.encryptionAlgorithmFromEncryptionDictionary(document.encryptionDictionary(), document.encryptionKey()), (WriteOption[])this.options.toArray(WriteOption[]::new));
        this.writer = new DefaultPDFWriter(new IndirectObjectsWriter(this.channel, this.context));
        try (InputStream stream = document.incrementedAsStream();){
            this.writer.writer().write(stream);
        }
        this.writer.writer().writeEOL();
        this.writeBody(document);
        this.writeXref(document);
    }

    private void sanitizeWriteOptions(IncrementablePDDocument document) {
        if (document.trailer().isXrefStream()) {
            this.options.add(WriteOption.XREF_STREAM);
        } else {
            this.options.remove((Object)WriteOption.XREF_STREAM);
            this.options.remove((Object)WriteOption.OBJECT_STREAMS);
        }
        if (!SpecVersionUtils.isAtLeast(document.incremented().getVersion(), "1.5")) {
            this.options.remove((Object)WriteOption.OBJECT_STREAMS);
        }
    }

    private void writeBody(IncrementablePDDocument document) throws IOException {
        try (IncrementalPDFBodyWriter bodyWriter = new IncrementalPDFBodyWriter(this.context, this.objectStreamWriter(this.objectsWriter()));){
            LOG.debug("Writing body using " + bodyWriter.objectsWriter.getClass());
            ((PDFBodyWriter)bodyWriter).write(document);
        }
    }

    private PDFBodyObjectsWriter objectsWriter() {
        if (this.context.hasWriteOption(WriteOption.ASYNC_BODY_WRITE)) {
            return new AsyncPDFBodyObjectsWriter(this.writer.writer());
        }
        return new SyncPDFBodyObjectsWriter(this.writer.writer());
    }

    private PDFBodyObjectsWriter objectStreamWriter(PDFBodyObjectsWriter wrapped) {
        if (this.context.hasWriteOption(WriteOption.OBJECT_STREAMS)) {
            return new ObjectsStreamPDFBodyObjectsWriter(this.context, wrapped);
        }
        return wrapped;
    }

    private void writeXref(IncrementablePDDocument document) throws IOException {
        if (this.context.hasWriteOption(WriteOption.XREF_STREAM) || this.context.hasWriteOption(WriteOption.OBJECT_STREAMS)) {
            this.writer.writeXrefStream(document.trailer().getCOSObject(), document.trailer().xrefOffset());
        } else {
            long startxref = this.writer.writeXrefTable();
            this.writer.writeTrailer(document.trailer().getCOSObject(), startxref, document.trailer().xrefOffset());
        }
    }

    @Override
    public void close() throws IOException {
        IOUtils.close((Closeable)this.writer);
    }
}

