/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.interactive.annotation.handlers;

import java.io.IOException;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.fontbox.util.Charsets;
import org.sejda.io.SeekableSources;
import org.sejda.sambox.contentstream.operator.Operator;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSNumber;
import org.sejda.sambox.input.ContentStreamParser;
import org.sejda.sambox.pdmodel.PDAppearanceContentStream;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.PDResources;
import org.sejda.sambox.pdmodel.common.PDRectangle;
import org.sejda.sambox.pdmodel.font.PDFont;
import org.sejda.sambox.pdmodel.font.PDType1Font;
import org.sejda.sambox.pdmodel.graphics.color.PDColor;
import org.sejda.sambox.pdmodel.graphics.color.PDColorSpace;
import org.sejda.sambox.pdmodel.graphics.color.PDDeviceCMYK;
import org.sejda.sambox.pdmodel.graphics.color.PDDeviceGray;
import org.sejda.sambox.pdmodel.graphics.color.PDDeviceRGB;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotation;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotationMarkup;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.sejda.sambox.pdmodel.interactive.annotation.PDBorderEffectDictionary;
import org.sejda.sambox.pdmodel.interactive.annotation.handlers.AnnotationBorder;
import org.sejda.sambox.pdmodel.interactive.annotation.handlers.CloudyBorder;
import org.sejda.sambox.pdmodel.interactive.annotation.handlers.PDAbstractAppearanceHandler;
import org.sejda.sambox.pdmodel.interactive.annotation.layout.AppearanceStyle;
import org.sejda.sambox.pdmodel.interactive.annotation.layout.PlainText;
import org.sejda.sambox.pdmodel.interactive.annotation.layout.PlainTextFormatter;
import org.sejda.sambox.pdmodel.interactive.form.PDAcroForm;
import org.sejda.sambox.util.Matrix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFreeTextAppearanceHandler
extends PDAbstractAppearanceHandler {
    private static final Logger LOG = LoggerFactory.getLogger(PDFreeTextAppearanceHandler.class);
    private static final Pattern COLOR_PATTERN = Pattern.compile(".*color\\:\\s*\\#([0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F]).*");
    private float fontSize = 10.0f;
    private COSName fontName = COSName.HELV;
    private PDDocument document;

    public PDFreeTextAppearanceHandler(PDAnnotation annotation) {
        this(annotation, null);
    }

    public PDFreeTextAppearanceHandler(PDAnnotation annotation, PDDocument document) {
        super(annotation);
        this.document = document;
    }

    @Override
    public void generateNormalAppearance() {
        PDAnnotationMarkup annotation = (PDAnnotationMarkup)this.getAnnotation();
        float[] pathsArray = new float[]{};
        if ("FreeTextCallout".equals(annotation.getIntent()) && ((pathsArray = annotation.getCallout()) == null || pathsArray.length != 4 && pathsArray.length != 6)) {
            pathsArray = new float[]{};
        }
        AnnotationBorder ab = AnnotationBorder.getAnnotationBorder(annotation, annotation.getBorderStyle());
        try (PDAppearanceContentStream cs = this.getNormalAppearanceAsContentStream(true);){
            float yOffset;
            float xOffset;
            PDFont defaultResourcesFont;
            PDResources defaultResources;
            PDAcroForm acroForm;
            PDRectangle borderBox;
            PDBorderEffectDictionary borderEffect;
            Matcher m;
            boolean hasBackground = cs.setNonStrokingColorOnDemand(annotation.getColor());
            this.setOpacity(cs, annotation.getConstantOpacity());
            PDColor strokingColor = this.extractNonStrokingColor(annotation);
            boolean hasStroke = cs.setStrokingColorOnDemand(strokingColor);
            PDColor textColor = strokingColor;
            String defaultStyleString = annotation.getDefaultStyleString();
            if (defaultStyleString != null && (m = COLOR_PATTERN.matcher(defaultStyleString)).find()) {
                int color = Integer.parseInt(m.group(1), 16);
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                textColor = new PDColor(new float[]{r, g, b}, (PDColorSpace)PDDeviceRGB.INSTANCE);
            }
            if (ab.dashArray != null) {
                cs.setLineDashPattern(ab.dashArray, 0.0f);
            }
            cs.setLineWidth(ab.width);
            for (int i = 0; i < pathsArray.length / 2; ++i) {
                float x = pathsArray[i * 2];
                float y = pathsArray[i * 2 + 1];
                if (i == 0) {
                    if (SHORT_STYLES.contains(annotation.getLineEndingStyle())) {
                        float x1 = pathsArray[2];
                        float y1 = pathsArray[3];
                        float len = (float)Math.sqrt(Math.pow(x - x1, 2.0) + Math.pow(y - y1, 2.0));
                        if (Float.compare(len, 0.0f) != 0) {
                            x += (x1 - x) / len * ab.width;
                            y += (y1 - y) / len * ab.width;
                        }
                    }
                    cs.moveTo(x, y);
                    continue;
                }
                cs.lineTo(x, y);
            }
            if (pathsArray.length > 0) {
                cs.stroke();
            }
            if ("FreeTextCallout".equals(annotation.getIntent()) && !"None".equals(annotation.getLineEndingStyle()) && pathsArray.length >= 4) {
                float x2 = pathsArray[2];
                float y2 = pathsArray[3];
                float x1 = pathsArray[0];
                float y1 = pathsArray[1];
                cs.saveGraphicsState();
                if (ANGLED_STYLES.contains(annotation.getLineEndingStyle())) {
                    double angle = Math.atan2(y2 - y1, x2 - x1);
                    cs.transform(Matrix.getRotateInstance(angle, x1, y1));
                } else {
                    cs.transform(Matrix.getTranslateInstance(x1, y1));
                }
                this.drawStyle(annotation.getLineEndingStyle(), cs, 0.0f, 0.0f, ab.width, hasStroke, hasBackground, false);
                cs.restoreGraphicsState();
            }
            if ((borderEffect = annotation.getBorderEffect()) != null && borderEffect.getStyle().equals("C")) {
                borderBox = this.applyRectDifferences(this.getRectangle(), annotation.getRectDifferences());
                CloudyBorder cloudyBorder = new CloudyBorder(cs, borderEffect.getIntensity(), ab.width, this.getRectangle());
                cloudyBorder.createCloudyRectangle(annotation.getRectDifference());
                annotation.setRectangle(cloudyBorder.getRectangle());
                annotation.setRectDifference(cloudyBorder.getRectDifference());
                PDAppearanceStream appearanceStream = annotation.getNormalAppearanceStream();
                appearanceStream.setBBox(cloudyBorder.getBBox());
                appearanceStream.setMatrix(cloudyBorder.getMatrix());
            } else {
                borderBox = this.applyRectDifferences(this.getRectangle(), annotation.getRectDifferences());
                annotation.getNormalAppearanceStream().setBBox(borderBox);
                PDRectangle paddedRectangle = this.getPaddedRectangle(borderBox, ab.width / 2.0f);
                cs.addRect(paddedRectangle.getLowerLeftX(), paddedRectangle.getLowerLeftY(), paddedRectangle.getWidth(), paddedRectangle.getHeight());
            }
            cs.drawShape(ab.width, hasStroke, hasBackground);
            int rotation = annotation.getCOSObject().getInt(COSName.ROTATE, 0);
            cs.transform(Matrix.getRotateInstance(Math.toRadians(rotation), 0.0f, 0.0f));
            float width = rotation == 90 || rotation == 270 ? borderBox.getHeight() : borderBox.getWidth();
            PDFont font = PDType1Font.HELVETICA;
            float clipWidth = width - ab.width * 4.0f;
            float clipHeight = rotation == 90 || rotation == 270 ? borderBox.getWidth() - ab.width * 4.0f : borderBox.getHeight() - ab.width * 4.0f;
            this.extractFontDetails(annotation);
            if (this.document != null && (acroForm = this.document.getDocumentCatalog().getAcroForm()) != null && (defaultResources = acroForm.getDefaultResources()) != null && (defaultResourcesFont = defaultResources.getFont(this.fontName)) != null) {
                font = defaultResourcesFont;
            }
            float yDelta = 0.7896f;
            cs.addRect(xOffset, switch (rotation) {
                case 180 -> {
                    xOffset = -borderBox.getUpperRightX() + ab.width * 2.0f;
                    yOffset = -borderBox.getLowerLeftY() - ab.width * 2.0f - yDelta * this.fontSize;
                    yield -borderBox.getUpperRightY() + ab.width * 2.0f;
                }
                case 90 -> {
                    xOffset = borderBox.getLowerLeftY() + ab.width * 2.0f;
                    yOffset = -borderBox.getLowerLeftX() - ab.width * 2.0f - yDelta * this.fontSize;
                    yield -borderBox.getUpperRightX() + ab.width * 2.0f;
                }
                case 270 -> {
                    xOffset = -borderBox.getUpperRightY() + ab.width * 2.0f;
                    yOffset = borderBox.getUpperRightX() - ab.width * 2.0f - yDelta * this.fontSize;
                    yield borderBox.getLowerLeftX() + ab.width * 2.0f;
                }
                default -> {
                    xOffset = borderBox.getLowerLeftX() + ab.width * 2.0f;
                    yOffset = borderBox.getUpperRightY() - ab.width * 2.0f - yDelta * this.fontSize;
                    yield borderBox.getLowerLeftY() + ab.width * 2.0f;
                }
            }, clipWidth, clipHeight);
            cs.clip();
            if (annotation.getContents() != null) {
                cs.beginText();
                cs.setFont(font, this.fontSize);
                cs.setNonStrokingColor(textColor.getComponents());
                AppearanceStyle appearanceStyle = new AppearanceStyle();
                appearanceStyle.setFont(font);
                appearanceStyle.setFontSize(this.fontSize);
                String textContents = Optional.ofNullable(annotation.getContents()).orElse("");
                PlainTextFormatter formatter = new PlainTextFormatter.Builder(cs).style(appearanceStyle).text(new PlainText(textContents)).width(width - ab.width * 4.0f).wrapLines(true).initialOffset(xOffset, yOffset).build();
                try {
                    formatter.format();
                }
                catch (IllegalArgumentException ex) {
                    throw new IOException(ex);
                }
                finally {
                    cs.endText();
                }
            }
            if (pathsArray.length > 0) {
                PDRectangle rect = this.getRectangle();
                float minX = Float.MAX_VALUE;
                float minY = Float.MAX_VALUE;
                float maxX = Float.MIN_VALUE;
                float maxY = Float.MIN_VALUE;
                for (int i = 0; i < pathsArray.length / 2; ++i) {
                    float x = pathsArray[i * 2];
                    float y = pathsArray[i * 2 + 1];
                    minX = Math.min(minX, x);
                    minY = Math.min(minY, y);
                    maxX = Math.max(maxX, x);
                    maxY = Math.max(maxY, y);
                }
                rect.setLowerLeftX(Math.min(minX - ab.width * 10.0f, rect.getLowerLeftX()));
                rect.setLowerLeftY(Math.min(minY - ab.width * 10.0f, rect.getLowerLeftY()));
                rect.setUpperRightX(Math.max(maxX + ab.width * 10.0f, rect.getUpperRightX()));
                rect.setUpperRightY(Math.max(maxY + ab.width * 10.0f, rect.getUpperRightY()));
                annotation.setRectangle(rect);
                annotation.getNormalAppearanceStream().setBBox(this.getRectangle());
            }
        }
        catch (IOException e) {
            LOG.error("Error writing to the content stream", (Throwable)e);
        }
    }

    private PDColor extractNonStrokingColor(PDAnnotationMarkup annotation) {
        PDColor strokingColor = new PDColor(new float[]{0.0f}, (PDColorSpace)PDDeviceGray.INSTANCE);
        String defaultAppearance = annotation.getDefaultAppearance();
        if (defaultAppearance == null) {
            return strokingColor;
        }
        try (ContentStreamParser parser = new ContentStreamParser(SeekableSources.inMemorySeekableSourceFrom((byte[])defaultAppearance.getBytes(Charsets.US_ASCII)));){
            COSArray arguments = new COSArray();
            COSArray colors = null;
            Operator graphicOp = null;
            Object token = null;
            while ((token = parser.nextParsedToken()) != null) {
                if (token instanceof Operator) {
                    Operator op = (Operator)token;
                    String name = op.getName();
                    if ("g".equals(name) || "rg".equals(name) || "k".equals(name)) {
                        graphicOp = op;
                        colors = arguments;
                    }
                    arguments = new COSArray();
                    continue;
                }
                arguments.add(((COSBase)token).getCOSObject());
            }
            if (graphicOp != null) {
                String graphicOpName = graphicOp.getName();
                if ("g".equals(graphicOpName)) {
                    strokingColor = new PDColor(colors, (PDColorSpace)PDDeviceGray.INSTANCE);
                } else if ("rg".equals(graphicOpName)) {
                    strokingColor = new PDColor(colors, (PDColorSpace)PDDeviceRGB.INSTANCE);
                } else if ("k".equals(graphicOpName)) {
                    strokingColor = new PDColor(colors, (PDColorSpace)PDDeviceCMYK.INSTANCE);
                }
            }
        }
        catch (IOException ex) {
            LOG.warn("Problem parsing /DA, will use default black", (Throwable)ex);
        }
        return strokingColor;
    }

    private void extractFontDetails(PDAnnotationMarkup annotation) {
        PDAcroForm pdAcroForm;
        String defaultAppearance = annotation.getDefaultAppearance();
        if (defaultAppearance == null && this.document != null && (pdAcroForm = this.document.getDocumentCatalog().getAcroForm()) != null) {
            defaultAppearance = pdAcroForm.getDefaultAppearance();
        }
        if (defaultAppearance == null) {
            return;
        }
        try (ContentStreamParser parser = new ContentStreamParser(SeekableSources.inMemorySeekableSourceFrom((byte[])defaultAppearance.getBytes(Charsets.US_ASCII)));){
            COSArray arguments = new COSArray();
            COSArray fontArguments = new COSArray();
            Object token = null;
            while ((token = parser.nextParsedToken()) != null) {
                if (token instanceof Operator) {
                    Operator op = (Operator)token;
                    String name = op.getName();
                    if ("Tf".equals(name)) {
                        fontArguments = arguments;
                    }
                    arguments = new COSArray();
                    continue;
                }
                arguments.add(((COSBase)token).getCOSObject());
            }
            if (fontArguments.size() >= 2) {
                COSBase base = fontArguments.get(0);
                if (base instanceof COSName) {
                    this.fontName = (COSName)base;
                }
                if ((base = fontArguments.get(1)) instanceof COSNumber) {
                    this.fontSize = ((COSNumber)base).floatValue();
                }
            }
        }
        catch (IOException ex) {
            LOG.warn("Problem parsing /DA, will use default 'Helv 10'", (Throwable)ex);
        }
    }

    @Override
    public void generateRolloverAppearance() {
    }

    @Override
    public void generateDownAppearance() {
    }
}

