/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.interactive.documentnavigation.outline;

import java.awt.Color;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSFloat;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSObjectable;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.documentinterchange.logicalstructure.PDStructureElement;
import org.sejda.sambox.pdmodel.graphics.color.PDColor;
import org.sejda.sambox.pdmodel.graphics.color.PDColorSpace;
import org.sejda.sambox.pdmodel.graphics.color.PDDeviceRGB;
import org.sejda.sambox.pdmodel.interactive.action.PDAction;
import org.sejda.sambox.pdmodel.interactive.action.PDActionFactory;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.destination.PDPageDestination;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.destination.PDPageXYZDestination;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.destination.WithActionOrDestination;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.outline.PDOutlineNode;

public final class PDOutlineItem
extends PDOutlineNode
implements WithActionOrDestination {
    private static final int ITALIC_FLAG = 1;
    private static final int BOLD_FLAG = 2;

    public PDOutlineItem() {
    }

    public PDOutlineItem(COSDictionary dic) {
        super(dic);
    }

    public void insertSiblingAfter(PDOutlineItem newSibling) {
        this.requireSingleNode(newSibling);
        PDOutlineNode parent = this.getParent();
        newSibling.setParent(parent);
        PDOutlineItem next = this.getNextSibling();
        this.setNextSibling(newSibling);
        newSibling.setPreviousSibling(this);
        if (next != null) {
            newSibling.setNextSibling(next);
            next.setPreviousSibling(newSibling);
        } else if (parent != null) {
            this.getParent().setLastChild(newSibling);
        }
        this.updateParentOpenCountForAddedChild(newSibling);
    }

    public void insertSiblingBefore(PDOutlineItem newSibling) {
        this.requireSingleNode(newSibling);
        PDOutlineNode parent = this.getParent();
        newSibling.setParent(parent);
        PDOutlineItem previous = this.getPreviousSibling();
        this.setPreviousSibling(newSibling);
        newSibling.setNextSibling(this);
        if (previous != null) {
            previous.setNextSibling(newSibling);
            newSibling.setPreviousSibling(previous);
        } else if (parent != null) {
            this.getParent().setFirstChild(newSibling);
        }
        this.updateParentOpenCountForAddedChild(newSibling);
    }

    public PDOutlineItem getPreviousSibling() {
        return this.getOutlineItem(COSName.PREV);
    }

    void setPreviousSibling(PDOutlineNode outlineNode) {
        this.getCOSObject().setItem(COSName.PREV, (COSObjectable)outlineNode);
    }

    public PDOutlineItem getNextSibling() {
        return this.getOutlineItem(COSName.NEXT);
    }

    void setNextSibling(PDOutlineNode outlineNode) {
        this.getCOSObject().setItem(COSName.NEXT, (COSObjectable)outlineNode);
    }

    public String getTitle() {
        return this.getCOSObject().getString(COSName.TITLE);
    }

    public void setTitle(String title) {
        this.getCOSObject().setString(COSName.TITLE, title);
    }

    @Override
    public PDDestination getDestination() throws IOException {
        return PDDestination.create(this.getCOSObject().getDictionaryObject(COSName.DEST));
    }

    public void setDestination(PDDestination dest) {
        this.getCOSObject().setItem(COSName.DEST, (COSObjectable)dest);
    }

    public void setDestination(PDPage page) {
        PDPageXYZDestination dest = null;
        if (page != null) {
            dest = new PDPageXYZDestination();
            dest.setPage(page);
        }
        this.setDestination(dest);
    }

    public PDPage findDestinationPage(PDDocument doc) throws IOException {
        PDPageDestination pageDestination = this.resolveToPageDestination(doc.getDocumentCatalog()).orElse(null);
        if (Objects.nonNull(pageDestination)) {
            return Optional.ofNullable(pageDestination.getPage()).orElseGet(() -> {
                int pageNumber = pageDestination.getPageNumber();
                if (pageNumber != -1) {
                    return doc.getPage(pageNumber);
                }
                return null;
            });
        }
        return null;
    }

    @Override
    public PDAction getAction() {
        return PDActionFactory.createAction(this.getCOSObject().getDictionaryObject(COSName.A, COSDictionary.class));
    }

    public void setAction(PDAction action) {
        this.getCOSObject().setItem(COSName.A, (COSObjectable)action);
    }

    public PDStructureElement getStructureElement() {
        PDStructureElement se = null;
        COSDictionary dic = this.getCOSObject().getDictionaryObject(COSName.SE, COSDictionary.class);
        if (dic != null) {
            se = new PDStructureElement(dic);
        }
        return se;
    }

    public void setStructureElement(PDStructureElement structureElement) {
        this.getCOSObject().setItem(COSName.SE, (COSObjectable)structureElement);
    }

    public PDColor getTextColor() {
        COSArray csValues = this.getCOSObject().getDictionaryObject(COSName.C, COSArray.class);
        if (csValues == null) {
            csValues = new COSArray();
            csValues.growToSize(3, new COSFloat(0.0f));
            this.getCOSObject().setItem(COSName.C, (COSBase)csValues);
        }
        return new PDColor(csValues, (PDColorSpace)PDDeviceRGB.INSTANCE);
    }

    public void setTextColor(PDColor textColor) {
        this.getCOSObject().setItem(COSName.C, (COSBase)textColor.toComponentsCOSArray());
    }

    public void setTextColor(Color textColor) {
        COSArray array = new COSArray();
        array.add(new COSFloat((float)textColor.getRed() / 255.0f));
        array.add(new COSFloat((float)textColor.getGreen() / 255.0f));
        array.add(new COSFloat((float)textColor.getBlue() / 255.0f));
        this.getCOSObject().setItem(COSName.C, (COSBase)array);
    }

    public boolean isItalic() {
        return this.getCOSObject().getFlag(COSName.F, 1);
    }

    public void setItalic(boolean italic) {
        this.getCOSObject().setFlag(COSName.F, 1, italic);
    }

    public boolean isBold() {
        return this.getCOSObject().getFlag(COSName.F, 2);
    }

    public void setBold(boolean bold) {
        this.getCOSObject().setFlag(COSName.F, 2, bold);
    }

    public void delete() {
        PDOutlineItem prev = this.getPreviousSibling();
        PDOutlineItem next = this.getNextSibling();
        PDOutlineNode parent = this.getParent();
        if (prev == null) {
            if (parent != null) {
                parent.setFirstChild(next);
            }
        } else {
            prev.setNextSibling(next);
        }
        if (next == null) {
            if (parent != null) {
                parent.setLastChild(prev);
            }
        } else {
            next.setPreviousSibling(prev);
        }
        this.updateParentOpenCount(-1);
    }
}

