/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.icepdf;

import java.awt.image.RenderedImage;
import java.io.File;
import org.icepdf.core.pobjects.Document;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.core.support.io.IOUtils;
import org.sejda.core.support.io.MultipleOutputWriter;
import org.sejda.core.support.io.OutputWriters;
import org.sejda.core.support.io.model.FileOutput;
import org.sejda.core.support.prefix.NameGenerator;
import org.sejda.core.support.prefix.model.NameGenerationRequest;
import org.sejda.impl.icepdf.BasePdfToImageTask;
import org.sejda.impl.icepdf.PdfToSingleImageTask;
import org.sejda.impl.icepdf.component.DefaultPdfSourceOpener;
import org.sejda.impl.icepdf.component.PdfToBufferedImageProvider;
import org.sejda.model.exception.TaskException;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.parameter.image.AbstractPdfToMultipleImageParameters;
import org.sejda.model.task.NotifiableTaskMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfToMultipleImageTask<T extends AbstractPdfToMultipleImageParameters>
extends BasePdfToImageTask<T> {
    private static final Logger LOG = LoggerFactory.getLogger(PdfToSingleImageTask.class);
    private MultipleOutputWriter outputWriter = OutputWriters.newMultipleOutputWriter();
    private PdfSourceOpener<Document> sourceOpener = new DefaultPdfSourceOpener();
    private Document pdfDocument = null;

    public void execute(T parameters) throws TaskException {
        this.pdfDocument = (Document)parameters.getSource().open(this.sourceOpener);
        int numberOfPages = this.pdfDocument.getNumberOfPages();
        LOG.trace("Found {} pages", (Object)numberOfPages);
        for (int zeroBasedPageNumber = 0; zeroBasedPageNumber < this.pdfDocument.getNumberOfPages(); ++zeroBasedPageNumber) {
            File tmpFile = IOUtils.createTemporaryBuffer();
            LOG.debug("Created output temporary buffer {} ", (Object)tmpFile);
            this.getWriter().openWriteDestination(tmpFile, parameters);
            LOG.trace("Writing page {}", (Object)(zeroBasedPageNumber + 1));
            this.getWriter().write((RenderedImage)PdfToBufferedImageProvider.toBufferedImage(this.pdfDocument, zeroBasedPageNumber, parameters), parameters);
            this.getWriter().closeDestination();
            String outName = NameGenerator.nameGenerator((String)parameters.getOutputPrefix()).generate(NameGenerationRequest.nameRequest((String)"tif").page(zeroBasedPageNumber).originalName(parameters.getSource().getName()).fileNumber(zeroBasedPageNumber + 1));
            this.outputWriter.addOutput(FileOutput.file((File)tmpFile).name(outName));
            ApplicationEventsNotifier.notifyEvent((NotifiableTaskMetadata)this.getNotifiableTaskMetadata()).stepsCompleted(zeroBasedPageNumber + 1).outOf(numberOfPages);
        }
        this.outputWriter.flushOutputs(parameters.getOutput(), parameters.isOverwrite());
        LOG.debug("Document converted to {} and saved to {}", (Object)parameters.getOutputImageType(), (Object)parameters.getOutput());
    }

    @Override
    public void after() {
        super.after();
        if (this.pdfDocument != null) {
            this.pdfDocument.dispose();
        }
    }
}

