/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v134.runtime.model;

import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v134.runtime.model.ExecutionContextId;
import org.openqa.selenium.json.JsonInput;

@Beta
public class BindingCalled {
    private final String name;
    private final String payload;
    private final ExecutionContextId executionContextId;

    public BindingCalled(String name, String payload, ExecutionContextId executionContextId) {
        this.name = Objects.requireNonNull(name, "name is required");
        this.payload = Objects.requireNonNull(payload, "payload is required");
        this.executionContextId = Objects.requireNonNull(executionContextId, "executionContextId is required");
    }

    public String getName() {
        return this.name;
    }

    public String getPayload() {
        return this.payload;
    }

    public ExecutionContextId getExecutionContextId() {
        return this.executionContextId;
    }

    private static BindingCalled fromJson(JsonInput input) {
        String name = null;
        String payload = null;
        ExecutionContextId executionContextId = null;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "name": {
                    name = input.nextString();
                    continue block10;
                }
                case "payload": {
                    payload = input.nextString();
                    continue block10;
                }
                case "executionContextId": {
                    executionContextId = (ExecutionContextId)input.read(ExecutionContextId.class);
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new BindingCalled(name, payload, executionContextId);
    }
}

