/*
 * Copyright (c) 2015-2017 Petr Zelenka <petr.zelenka@sellcom.org>.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.sellcom.core.internal.io.character;

/**
 * Common symbols.
 *
 * @since 1.3
 */
public class Symbols {

	/**
	 * Alternative key symbol.
	 *
	 * @since 1.3
	 */
	public static final char ALTERNATIVE_KEY_SYMBOL = '\u2387';

	/**
	 * Cent sign.
	 *
	 * @since 1.3
	 */
	public static final char CENT_SIGN = '\u00A2';

	/**
	 * Command key symbol.
	 *
	 * @since 1.3
	 */
	public static final char COMMAND_KEY_SYMBOL = '\u2318';

	/**
	 * Copyright sign.
	 *
	 * @since 1.3
	 */
	public static final char COPYRIGHT_SIGN = '\u00A9';

	/**
	 * Currency sign.
	 *
	 * @since 1.3
	 */
	public static final char CURRENCY_SIGN = '\u00A4';

	/**
	 * Degree symbol.
	 *
	 * @since 1.3
	 */
	public static final char DEGREE_SYMBOL = '\u00B0';

	/**
	 * Division sign.
	 *
	 * @since 1.3
	 */
	public static final char DIVISION_SIGN = '\u00F7';

	/**
	 * Dollar sign.
	 *
	 * @since 1.3
	 */
	public static final char DOLLAR_SIGN = '\u0024';

	/**
	 * Erase to the left key symbol.
	 *
	 * @since 1.3
	 */
	public static final char ERASE_TO_THE_LEFT_KEY_SYMBOL = '\u232B';

	/**
	 * Erase to the right key symbol.
	 *
	 * @since 1.3
	 */
	public static final char ERASE_TO_THE_RIGHT_KEY_SYMBOL = '\u2326';

	/**
	 * Euro sign.
	 *
	 * @since 1.3
	 */
	public static final char EURO_SIGN = '\u20AC';

	/**
	 * Feminine ordinal indicator.
	 *
	 * @since 1.3
	 */
	public static final char FEMININE_ORDINAL_INDICATOR = '\u00AA';

	/**
	 * Horizontal ellipsis.
	 *
	 * @since 1.3
	 */
	public static final char HORIZONTAL_ELLIPSIS = '\u2026';

	/**
	 * Infinity symbol.
	 *
	 * @since 1.3
	 */
	public static final char INFINITY_SYMBOL = '\u221E';

	/**
	 * Inverted exclamation mark.
	 *
	 * @since 1.3
	 */
	public static final char INVERTED_EXCLAMATION_MARK = '\u00A1';

	/**
	 * Inverted question mark.
	 *
	 * @since 1.3
	 */
	public static final char INVERTED_QUESTION_MARK = '\u00BF';

	/**
	 * Masculine ordinal indicator.
	 *
	 * @since 1.3
	 */
	public static final char MASCULINE_ORDINAL_INDICATOR = '\u00BA';

	/**
	 * Middle dot.
	 *
	 * @since 1.3
	 */
	public static final char MIDDLE_DOT = '\u00B7';

	/**
	 * Midline horizontal ellipsis.
	 *
	 * @since 1.3
	 */
	public static final char MIDLINE_HORIZONTAL_ELLIPSIS = '\u20EF';

	/**
	 * Minus-plus sign.
	 *
	 * @since 1.3
	 */
	public static final char MINUS_PLUS_SIGN = '\u2213';

	/**
	 * Multiplication sign.
	 *
	 * @since 1.3
	 */
	public static final char MULTIPLICATION_SIGN = '\u00D7';

	/**
	 * Option key symbol.
	 *
	 * @since 1.3
	 */
	public static final char OPTION_KEY_SYMBOL = '\u2325';

	/**
	 * Pilcrow sign.
	 *
	 * @since 1.3
	 */
	public static final char PILCROW_SIGN = '\u00B6';

	/**
	 * Pound sign.
	 *
	 * @since 1.3
	 */
	public static final char POUND_SIGN = '\u00A3';

	/**
	 * Plus-minus sign.
	 *
	 * @since 1.3
	 */
	public static final char PLUS_MINUS_SIGN = '\u00B1';

	/**
	 * Registered trademark sign.
	 *
	 * @since 1.3
	 */
	public static final char REGISTERED_TRADEMARK_SIGN = '\u00AE';

	/**
	 * Section sign.
	 *
	 * @since 1.3
	 */
	public static final char SECTION_SIGN = '\u00A7';

	/**
	 * Shekel sign.
	 *
	 * @since 1.3
	 */
	public static final char SHEKEL_SIGN = '\u20AA';

	/**
	 * Trademark sign.
	 *
	 * @since 1.3
	 */
	public static final char TRADEMARK_SIGN = '\u2122';

	/**
	 * Vertical ellipsis.
	 *
	 * @since 1.3
	 */
	public static final char VERTICAL_ELLIPSIS = '\u22EE';

	/**
	 * Yen sign.
	 *
	 * @since 1.3
	 */
	public static final char YEN_SIGN = '\u00A5';


	private Symbols() {
		// Namespace for constants, not to be instantiated
	}

}
