/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.context.renderer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.semantictools.context.renderer.StreamFactory;
import org.semantictools.context.renderer.Style;
import org.semantictools.context.renderer.model.DiagramSpec;
import org.semantictools.context.renderer.model.Modifier;
import org.semantictools.context.renderer.model.Node;
import org.semantictools.context.renderer.model.Rect;
import org.semantictools.graphics.Padding;

public class ContextRenderer {
    private Style style;
    private FontMetrics nameMetrics;
    private FontMetrics typeMetrics;
    private StreamFactory streamFactory;

    public ContextRenderer(StreamFactory factory) {
        this.streamFactory = factory;
        this.style = new Style(true);
    }

    public void renderGraphicalNotationFigure(DiagramSpec spec) throws IOException {
        this.computeLayout(spec);
        NotationPainter painter = new NotationPainter(spec);
        painter.paintImage();
    }

    public void render(DiagramSpec spec) throws IOException {
        this.computeLayout(spec);
        this.paint(spec);
    }

    private void paint(DiagramSpec spec) throws IOException {
        this.paintRootNode(spec);
    }

    private void paintRootNode(DiagramSpec spec) throws IOException {
        Painter painter = new Painter(spec);
        painter.paintImage();
    }

    private void computeLayout(DiagramSpec spec) {
        LayoutEngine engine = new LayoutEngine(spec);
        engine.computeLayout();
    }

    class Grid {
        List<Column> columnList = new ArrayList<Column>();

        Grid() {
        }

        public Node getNode(int column, int index) {
            return this.columnList.get(column).getNodeList().get(index);
        }

        public void refinePlacement(int spacing) {
            Node root = this.getNode(0, 0);
            this.refinePlacement(root, spacing);
        }

        public Column getColumn(int col) {
            return this.columnList.get(col);
        }

        private void refinePlacement(Node node, int spacing) {
            List<Node> kids;
            int dy = this.getDeltaY(node, spacing);
            if (dy > 0) {
                this.shiftColumn(node, dy, spacing);
            }
            if ((kids = node.getChildren()) != null) {
                for (Node n : kids) {
                    this.refinePlacement(n, spacing);
                }
            }
        }

        private int getDeltaY(Node node, int spacing) {
            int row = node.getRow();
            int column = node.getColumn();
            int top = node.getBoundary().getY();
            int prevTop = 0;
            if (row > 0) {
                Node prev = this.getNode(column, row - 1);
                prevTop = prev.getBottom() + spacing;
            }
            int dy = prevTop - top;
            return dy;
        }

        private void shiftColumn(Node node, int dy, int spacing) {
            int row = node.getRow();
            int column = node.getColumn();
            List<Node> list = this.getColumn(column).getNodeList();
            for (int i = row; i < list.size(); ++i) {
                Node n = list.get(i);
                this.shiftNode(n, dy);
            }
            Node parent = node.getParent();
            this.shiftParent(parent, spacing);
        }

        private void shiftParent(Node parent, int spacing) {
            if (parent == null) {
                return;
            }
            int row = parent.getRow();
            int column = parent.getColumn();
            List<Node> list = this.getColumn(column).getNodeList();
            for (int i = row; i < list.size(); ++i) {
                Node n = list.get(i);
                this.placeParent(n, spacing);
            }
            this.shiftParent(parent.getParent(), spacing);
        }

        private void placeParent(Node n, int spacing) {
            List<Node> kids = n.getChildren();
            if (kids == null) {
                int dy = this.getDeltaY(n, spacing);
                if (dy > 0) {
                    int top = n.getTop() + dy;
                    n.setTop(top);
                }
                return;
            }
            Node firstChild = kids.get(0);
            Node lastChild = kids.get(kids.size() - 1);
            int kidsTop = firstChild.getTop();
            int kidsBottom = lastChild.getBottom();
            int middle = (kidsTop + kidsBottom) / 2;
            int dy = n.getHeight() / 2;
            int top = middle - dy;
            n.setTop(top);
        }

        private void shiftNode(Node node, int dy) {
            int top = node.getBoundary().getY() + dy;
            node.setTop(top);
            if (node.getChildren() != null) {
                for (Node c : node.getChildren()) {
                    this.shiftNode(c, dy);
                }
            }
        }

        public void add(Node node, int column) {
            while (this.columnList.size() < column + 1) {
                this.columnList.add(new Column());
            }
            Column c = this.columnList.get(column);
            int row = c.getNodeList().size();
            c.add(node);
            node.setGridCoordinates(row, column);
        }

        public void computeVerticalSpacing(int verticalSpacing) {
            this.computeDefaultVerticalSpacing(verticalSpacing);
        }

        private void computeDefaultVerticalSpacing(int spacing) {
            this.doBaselineVerticalSpacing(spacing);
            this.doRootVerticalSpacing(spacing);
        }

        private void doRootVerticalSpacing(int spacing) {
            if (this.columnList.size() < 2) {
                return;
            }
            Node root = this.getNode(0, 0);
            int height = this.columnList.get(1).getBoundary().getHeight();
            int middle = height / 2;
            int dy = root.getBoundary().getHeight() / 2;
            int top = middle - dy;
            root.setTop(top);
        }

        private void doBaselineVerticalSpacing(int spacing) {
            if (this.columnList.size() == 1) {
                this.columnList.get(0).getNodeList().get(0).setTop(0);
                return;
            }
            Column col = this.columnList.get(1);
            int mark = -spacing;
            for (Node n : col.getNodeList()) {
                int top = mark + spacing;
                n.setTop(top);
                Rect boundary = n.getBoundary();
                mark = top + boundary.getHeight();
                this.doChildrenBaseline(n, spacing);
            }
            col.getBoundary().setHeight(mark);
        }

        private void doChildrenBaseline(Node parent, int spacing) {
            List<Node> kids = parent.getChildren();
            if (kids == null) {
                return;
            }
            Rect parentBoundary = parent.getBoundary();
            int boxHeight = parentBoundary.getHeight();
            int kidCount = kids.size();
            int totalKidHeight = kidCount * boxHeight + (kidCount - 1) * spacing;
            int parentMiddle = parentBoundary.getY() + boxHeight / 2;
            int top = parentMiddle - totalKidHeight / 2;
            for (Node child : kids) {
                child.setTop(top);
                this.doChildrenBaseline(child, spacing);
                top += spacing + boxHeight;
            }
        }

        public void computeHorizontalSpacing(int horizontalSpacing) {
            this.computeColumnWidths();
            this.setColumnLeftEdges(horizontalSpacing);
        }

        private void setColumnLeftEdges(int spacing) {
            for (int i = 1; i < this.columnList.size(); ++i) {
                Column col = this.columnList.get(i);
                Column prev = this.columnList.get(i - 1);
                Rect prevBoundary = prev.getBoundary();
                int left = prevBoundary.getX() + prevBoundary.getWidth() + spacing;
                col.setLeft(left);
            }
        }

        private void computeColumnWidths() {
            for (Column col : this.columnList) {
                this.computeWidth(col);
            }
        }

        private void computeWidth(Column col) {
            List<Node> nodeList = col.getNodeList();
            int maxWidth = 0;
            for (Node n : nodeList) {
                Rect boundary = n.getBoundary();
                if (boundary.getWidth() <= maxWidth) continue;
                maxWidth = boundary.getWidth();
            }
            col.getBoundary().setWidth(maxWidth);
        }

        void inject(Node root) {
            this.inject(0, root);
        }

        private void inject(int column, Node node) {
            this.add(node, column);
            List<Node> kids = node.getChildren();
            if (kids != null) {
                ++column;
                for (Node n : kids) {
                    this.inject(column, n);
                }
            }
        }
    }

    class Column {
        List<Node> nodeList = new ArrayList<Node>();
        Rect boundary = new Rect();

        Column() {
        }

        public List<Node> getNodeList() {
            return this.nodeList;
        }

        public Rect getBoundary() {
            return this.boundary;
        }

        public void add(Node node) {
            this.nodeList.add(node);
        }

        public void setLeft(int left) {
            this.boundary.setX(left);
            for (Node n : this.nodeList) {
                n.setLeft(left, ContextRenderer.this.style.getModifierDiameter());
            }
        }
    }

    private class LayoutEngine {
        private DiagramSpec spec;
        private int nameHeight;
        private int typeHeight;
        private Grid grid;

        LayoutEngine(DiagramSpec spec) {
            this.grid = new Grid();
            this.spec = spec;
            BufferedImage image = new BufferedImage(10, 10, 2);
            Graphics2D g = image.createGraphics();
            ContextRenderer.this.nameMetrics = g.getFontMetrics(ContextRenderer.this.style.getNameFont());
            ContextRenderer.this.typeMetrics = g.getFontMetrics(ContextRenderer.this.style.getTypeFont());
            Padding namePad = ContextRenderer.this.style.getNamePadding();
            Padding typePad = ContextRenderer.this.style.getTypePadding();
            this.nameHeight = ContextRenderer.this.nameMetrics.getHeight() + namePad.getPadTop() + namePad.getPadBottom();
            this.typeHeight = ContextRenderer.this.typeMetrics.getHeight() + typePad.getPadTop() + typePad.getPadBottom();
            ContextRenderer.this.style.setModifierDiameter(this.typeHeight);
            namePad.setMaxDescent(ContextRenderer.this.nameMetrics.getMaxDescent());
            typePad.setMaxDescent(ContextRenderer.this.typeMetrics.getMaxDescent());
        }

        public void computeLayout() {
            Node root = this.spec.getRoot();
            this.grid.inject(root);
            this.computeDimensions(root);
            root.setLeft(0, ContextRenderer.this.style.getModifierDiameter());
            this.grid.computeHorizontalSpacing(ContextRenderer.this.style.getHorizontalSpacing());
            this.grid.computeVerticalSpacing(ContextRenderer.this.style.getVerticalSpacing());
            this.grid.refinePlacement(ContextRenderer.this.style.getVerticalSpacing());
        }

        public void computeDimensions(Node node) {
            String localName = node.getNameText();
            String typeName = node.getTypeText();
            this.setDimensions(node.getNameRect(), localName, this.nameHeight, ContextRenderer.this.nameMetrics, ContextRenderer.this.style.getNamePadding());
            this.setDimensions(node.getTypeRect(), typeName, this.typeHeight, ContextRenderer.this.typeMetrics, ContextRenderer.this.style.getTypePadding());
            node.alignWidth(ContextRenderer.this.style.getModifierDiameter());
            node.computeHeight();
            List<Node> kids = node.getChildren();
            if (kids != null) {
                for (Node n : kids) {
                    this.computeDimensions(n);
                }
            }
        }

        private void setDimensions(Rect rect, String text, int height, FontMetrics metrics, Padding padding) {
            rect.setHeight(height);
            rect.setWidth(metrics.stringWidth(text) + padding.getPadLeft() + padding.getPadRight());
        }
    }

    private class Painter {
        BufferedImage image;
        Graphics2D graphics;
        DiagramSpec spec;
        protected int imageWidth;
        protected int imageHeight;

        protected Painter() {
        }

        Painter(DiagramSpec spec) {
            this.init(spec);
        }

        protected void init(DiagramSpec spec) {
            this.spec = spec;
            this.computeImageDimensions();
            this.image = new BufferedImage(this.imageWidth, this.imageHeight, 2);
            this.graphics = this.image.createGraphics();
            this.graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }

        protected void computeImageDimensions() {
            this.updateDimensions(this.spec.getRoot());
        }

        private void updateDimensions(Node node) {
            this.imageWidth = Math.max(this.imageWidth, node.getRight() + 1);
            this.imageHeight = Math.max(this.imageHeight, node.getBottom() + 1);
            if (node.getChildren() != null) {
                for (Node n : node.getChildren()) {
                    this.updateDimensions(n);
                }
            }
        }

        public void paintImage() throws IOException {
            this.paintNode(this.spec.getRoot());
            this.writeFile();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeFile() throws IOException {
            OutputStream stream = ContextRenderer.this.streamFactory.createOutputStream(this.spec.getImagePath());
            try {
                ImageIO.write((RenderedImage)this.image, "png", stream);
            }
            finally {
                stream.close();
            }
        }

        private void paintNode(Node node) {
            this.graphics.setColor(ContextRenderer.this.style.getBoxBorderColor());
            this.drawText(node.getTypeText(), node.getTypeRect(), ContextRenderer.this.style.getTypePadding(), ContextRenderer.this.style.getTypeFont(), ContextRenderer.this.style.getTypeTextColor(), ContextRenderer.this.style.getTypeBgColor());
            this.drawText(node.getNameText(), node.getNameRect(), ContextRenderer.this.style.getNamePadding(), ContextRenderer.this.style.getNameFont(), ContextRenderer.this.style.getNameTextColor(), ContextRenderer.this.style.getNameBgColor());
            String q = node.getNameQualifier();
            if (q != null) {
                this.drawText(q, node.getNameRect(), ContextRenderer.this.style.getNamePadding(), ContextRenderer.this.style.getNameFont(), ContextRenderer.this.style.getArcColor(), null);
            }
            this.drawRect(node.getOutline(), ContextRenderer.this.style.getBoxBorderColor());
            this.drawModifier(node);
            if (node.getChildren() != null) {
                for (Node n : node.getChildren()) {
                    this.paintNode(n);
                }
                this.paintArc(node);
            }
        }

        private void drawModifier(Node node) {
            if (node.getModifier() == Modifier.NONE) {
                return;
            }
            int diameter = ContextRenderer.this.style.getModifierDiameter();
            int middle = (node.getTop() + node.getBottom()) / 2;
            int x = node.getLeft();
            int y = middle - diameter / 2;
            Ellipse2D.Float circle = new Ellipse2D.Float(x, y, diameter, diameter);
            this.graphics.setPaint(ContextRenderer.this.style.getTypeBgColor());
            this.graphics.fill(circle);
            this.graphics.setPaint(ContextRenderer.this.style.getBoxBorderColor());
            this.graphics.draw(circle);
            String symbol = node.getModifier().getSymbol();
            Rectangle2D bounds = ContextRenderer.this.nameMetrics.getStringBounds(symbol, this.graphics);
            int height = (int)bounds.getHeight();
            int width = (int)bounds.getWidth();
            x = x + (diameter - width) / 2 + ContextRenderer.this.nameMetrics.getLeading();
            y = y + (diameter - height) / 2 + ContextRenderer.this.nameMetrics.getAscent() + ContextRenderer.this.nameMetrics.getLeading();
            this.graphics.setFont(ContextRenderer.this.style.getNameFont());
            this.graphics.setColor(ContextRenderer.this.style.getArcColor());
            this.graphics.drawString(symbol, x, y);
        }

        private void paintArc(Node node) {
            switch (node.getBranchStyle()) {
                case RECTILINEAR: {
                    this.paintRectilinearArc(node);
                    break;
                }
                case OBLIQUE: {
                    this.paintObliqueArc(node);
                }
            }
        }

        private void paintObliqueArc(Node node) {
            int childLeft;
            int top = node.getTop();
            int bottom = node.getBottom();
            int x0 = node.getRight();
            int y0 = (top + bottom) / 2;
            Node firstChild = node.getFirstChild();
            int x2 = childLeft = firstChild.getLeft();
            int y2 = firstChild.getTop() + firstChild.getHeight() / 2;
            this.paintArc(x0, y0, x2, y2);
            Node lastChild = node.getLastChild();
            if (lastChild == firstChild) {
                return;
            }
            y2 = lastChild.getTop() + lastChild.getHeight() / 2;
            this.paintArc(x0, y0, x2, y2);
        }

        private void paintRectilinearArc(Node node) {
            int top = node.getTop();
            int bottom = node.getBottom();
            int x0 = node.getRight();
            int y0 = (top + bottom) / 2;
            Node firstChild = node.getFirstChild();
            int childLeft = firstChild.getLeft();
            int hspace = ContextRenderer.this.style.getHorizontalSpacing() / 2;
            int x1 = childLeft - hspace;
            int y1 = y0;
            this.paintArc(x0, y0, x1, y1);
            int x2 = childLeft;
            int y2 = firstChild.getTop() + firstChild.getHeight() / 2;
            this.paintArc(x1, y1, x1, y2);
            this.paintArc(x1, y2, x2, y2);
            Node lastChild = node.getLastChild();
            if (lastChild == firstChild) {
                return;
            }
            y2 = lastChild.getTop() + lastChild.getHeight() / 2;
            this.paintArc(x1, y1, x1, y2);
            this.paintArc(x1, y2, x2, y2);
        }

        private void paintArc(int x0, int y0, int x1, int y1) {
            this.graphics.setPaint(ContextRenderer.this.style.getArcColor());
            this.graphics.drawLine(x0, y0, x1, y1);
        }

        private void fill(Rect box, Color bgColor) {
            Rectangle2D.Float shape = new Rectangle2D.Float();
            shape.setRect(box.getX(), box.getY(), box.getWidth(), box.getHeight());
            this.graphics.setPaint(bgColor);
            this.graphics.fill(shape);
        }

        private void drawText(String text, Rect box, Padding padding, Font font, Color color, Color bgColor) {
            int x = box.getX() + padding.getPadLeft();
            int y = box.getY() + box.getHeight() - padding.getPadBottom() - padding.getMaxDescent();
            if (bgColor != null) {
                this.fill(box, bgColor);
                this.graphics.setBackground(bgColor);
            }
            this.graphics.setFont(font);
            this.graphics.setColor(color);
            this.graphics.drawString(text, x, y);
        }

        public void drawRect(Rect box, Color color) {
            int x = box.getX();
            int y = box.getY();
            int width = box.getWidth();
            int height = box.getHeight();
            this.graphics.setColor(color);
            this.graphics.drawRect(x, y, width, height);
        }
    }

    class NotationPainter
    extends Painter {
        private static final int ARROW_LENGTH = 50;
        private static final int ARROW_HEAD_LENGTH = 4;
        private static final int ARROW_SPACING = 5;
        private static final String PROPERTY_NAME = "property name";
        private static final String PROPERTY_TYPE = "property type";
        private Rectangle2D propertyNameBounds;
        private Rectangle2D propertyTypeBounds;
        private int ascent;

        NotationPainter(DiagramSpec spec) {
            this.init(spec);
        }

        @Override
        protected void computeImageDimensions() {
            super.computeImageDimensions();
            BufferedImage image = new BufferedImage(10, 10, 2);
            Graphics2D g = image.createGraphics();
            FontMetrics metrics = g.getFontMetrics(ContextRenderer.this.style.getLabelFont());
            this.ascent = metrics.getAscent() / 2 - metrics.getDescent();
            this.propertyNameBounds = metrics.getStringBounds(PROPERTY_NAME, g);
            this.propertyTypeBounds = metrics.getStringBounds(PROPERTY_TYPE, g);
            int textWidth = (int)Math.max(this.propertyNameBounds.getWidth(), this.propertyTypeBounds.getWidth());
            this.imageWidth += 73 + textWidth;
        }

        @Override
        public void paintImage() throws IOException {
            this.paintLabeledArrow(this.spec.getRoot().getNameRect(), this.propertyNameBounds, PROPERTY_NAME);
            this.paintLabeledArrow(this.spec.getRoot().getTypeRect(), this.propertyTypeBounds, PROPERTY_TYPE);
            super.paintImage();
        }

        private void paintLabeledArrow(Rect targetRect, Rectangle2D labelBounds, String labelText) {
            int x0 = targetRect.getWidth() + 5;
            int y0 = targetRect.getY() + targetRect.getHeight() / 2;
            int x1 = x0 + 8;
            int y1 = y0 + 4;
            int x2 = x1;
            int y2 = y0 - 4;
            int[] x = new int[]{x0, x1, x2, x0};
            int[] y = new int[]{y0, y1, y2, y0};
            BasicStroke width1 = new BasicStroke(1.0f);
            BasicStroke width2 = new BasicStroke(2.0f);
            this.graphics.setColor(Color.red);
            this.graphics.setPaint(Color.red);
            this.graphics.setStroke(width1);
            this.graphics.fillPolygon(x, y, 3);
            this.graphics.drawPolygon(x, y, 3);
            Stroke stroke = this.graphics.getStroke();
            this.graphics.setStroke(width2);
            x0 = x1;
            x1 = x0 + 50;
            y1 = y0;
            this.graphics.drawLine(x0, y0, x1, y1);
            this.graphics.setStroke(stroke);
            this.graphics.setColor(Color.black);
            this.graphics.setFont(ContextRenderer.this.style.getLabelFont());
            x0 = x1 + 10;
            this.graphics.drawString(labelText, x0, y0 += this.ascent);
        }
    }
}

