/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.context.renderer;

import com.ibm.icu.util.StringTokenizer;
import java.io.File;
import org.semantictools.context.renderer.model.JsonContext;
import org.semantictools.frame.model.Frame;

public class MediaTypeFileManager {
    private File mediaTypeDir;
    private File baseDir;

    public MediaTypeFileManager(File baseDir, File mediaTypeDir) {
        this.baseDir = baseDir;
        this.mediaTypeDir = mediaTypeDir;
    }

    public File getIndexFile(String mediaType) {
        String path = this.pathToMediaTypeDir(mediaType) + "/" + this.getIndexFileName();
        return new File(this.mediaTypeDir, path);
    }

    public String pathToMediaTypeDir(String mediaType) {
        return mediaType.replace('.', '/');
    }

    public String pathToBaseDir(String mediaType) {
        StringBuilder builder = new StringBuilder();
        StringTokenizer tokens = new StringTokenizer(mediaType, ".");
        builder.append("..");
        while (tokens.hasMoreTokens()) {
            tokens.nextToken();
            builder.append("/..");
        }
        return builder.toString();
    }

    public String toRelativeURL(String url, String baseURL, String mediaType) {
        if (url == null || baseURL == null || !url.startsWith(baseURL)) {
            return url;
        }
        String result = this.pathToBaseDir(mediaType) + url.substring(baseURL.length());
        return result;
    }

    public String getStyleSheetFileName() {
        return "mediaType.css";
    }

    public String pathToStyleSheet(String mediaType) {
        String mediaTypeDir = this.pathToMediaTypeDir(mediaType);
        String[] array = mediaTypeDir.split("/");
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            builder.append("../");
        }
        builder.append(this.getStyleSheetFileName());
        return builder.toString();
    }

    public String getIndexFileName() {
        return "index.html";
    }

    public String getJsonContextFileName(JsonContext context) {
        return "context.json";
    }

    public File getMediaTypeDocumentationFile(String mediaType) {
        File parentDir = new File(this.baseDir, this.pathToMediaTypeDir(mediaType));
        parentDir.mkdirs();
        return new File(parentDir, this.getIndexFileName());
    }

    public String getServiceDocumentationFileName() {
        return "service.html";
    }

    public String getJsonSampleFileName() {
        return "sample.json";
    }

    public String getOverviewDiagramPath() {
        return "images/overview.png";
    }

    public String getClassDiagramPath(Frame frame) {
        return "images/" + frame.getLocalName() + ".png";
    }

    public String getImagesDir() {
        return "images";
    }
}

