/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.context.renderer;

import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.XSD;
import org.semantictools.context.renderer.TermNotFoundException;
import org.semantictools.context.renderer.model.JsonContext;
import org.semantictools.context.renderer.model.TermInfo;
import org.semantictools.context.renderer.model.TreeNode;
import org.semantictools.frame.api.TypeManager;

public class NodeUtil {
    public static TreeNode createDefaultTypeNode(TypeManager typeManager, JsonContext context, String typeURI) {
        String namespaceURI;
        TermInfo namespaceTerm;
        if (typeManager.isStandardLiteralType(typeURI)) {
            typeURI = XSD.xstring.getURI();
        }
        if ((namespaceTerm = context.getTermInfoByURI(namespaceURI = TypeManager.getNamespace(typeURI))) == null) {
            throw new TermNotFoundException(namespaceURI);
        }
        TreeNode node = new TreeNode();
        String localName = TypeManager.getLocalName(typeURI);
        String prefix = namespaceTerm.getTermName();
        String typeName = XSD.getURI().equals(namespaceURI) || OWL.getURI().equals(namespaceURI) ? prefix + ":" + localName : localName;
        String typeHref = typeManager.isStandardDatatype(namespaceURI) ? null : "#" + prefix + "." + localName;
        node.setTypeName(typeName);
        node.setTypeHref(typeHref);
        node.setTypeURI(typeURI);
        return node;
    }
}

