/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.context.renderer;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.PrettyPrinter;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectWriter;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.JsonNodeFactory;
import org.codehaus.jackson.node.ObjectNode;
import org.semantictools.frame.api.TypeManager;
import org.semantictools.frame.model.OntologyInfo;

public class SampleWriter {
    private TypeManager typeManager;
    private JsonNodeFactory factory = JsonNodeFactory.instance;
    private Map<String, OntologyInfo> uri2OntologyInfo = new HashMap<String, OntologyInfo>();
    private Map<String, ObjectNode> uri2Resource = new HashMap<String, ObjectNode>();

    public SampleWriter(TypeManager typeManager) {
        this.typeManager = typeManager;
    }

    public void add(Resource resource) {
        String id = this.getIdentifier(resource);
        ObjectNode node = this.uri2Resource.get(id);
        if (node == null) {
            node = this.factory.objectNode();
            this.uri2Resource.put(id, node);
            node.put("@id", id);
            this.addType(node, resource);
            this.addProperties(node, resource);
        }
    }

    public void write(File file) throws IOException {
        ObjectNode universe = this.createUniverse();
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationConfig.Feature.INDENT_OUTPUT, true);
        mapper.writeValue(file, (Object)universe);
    }

    public void write(OutputStream output) throws IOException {
        ObjectNode universe = this.createUniverse();
        ObjectMapper mapper = new ObjectMapper();
        ObjectWriter writer = mapper.writer((PrettyPrinter)new MyPrettyPrinter());
        mapper.configure(SerializationConfig.Feature.INDENT_OUTPUT, true);
        writer.writeValue(output, (Object)universe);
    }

    private ObjectNode createUniverse() {
        ObjectNode universe = this.factory.objectNode();
        universe.put("@context", (JsonNode)this.createContext());
        universe.put("database", (JsonNode)this.createDatabase());
        return universe;
    }

    private ArrayNode createDatabase() {
        ArrayNode array = this.factory.arrayNode();
        ArrayList<Map.Entry<String, ObjectNode>> list = new ArrayList<Map.Entry<String, ObjectNode>>(this.uri2Resource.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, ObjectNode>>(){

            @Override
            public int compare(Map.Entry<String, ObjectNode> a, Map.Entry<String, ObjectNode> b) {
                return a.getKey().compareTo(b.getKey());
            }
        });
        for (Map.Entry entry : list) {
            array.add((JsonNode)entry.getValue());
        }
        return array;
    }

    private ObjectNode createContext() {
        ObjectNode node = this.factory.objectNode();
        ArrayList<OntologyInfo> list = new ArrayList<OntologyInfo>(this.uri2OntologyInfo.values());
        Collections.sort(list, new Comparator<OntologyInfo>(){

            @Override
            public int compare(OntologyInfo a, OntologyInfo b) {
                return a.getPrefix().compareTo(b.getPrefix());
            }
        });
        for (OntologyInfo info : list) {
            node.put(info.getPrefix(), info.getNamespaceUri());
        }
        return node;
    }

    private String getIdentifier(Resource resource) {
        String result;
        String string = resource.isURIResource() ? resource.getURI() : (result = resource.isAnon() ? "_:" + resource.getId().getLabelString() : null);
        if (result == null) {
            throw new IllegalArgumentException("Resource does not have an identifier");
        }
        return result;
    }

    private void addProperties(ObjectNode node, Resource resource) {
        StmtIterator sequence = resource.listProperties();
        while (sequence.hasNext()) {
            Statement s = (Statement)sequence.next();
            Property p = s.getPredicate();
            if (p.equals(RDF.type)) continue;
            RDFNode object = s.getObject();
            String fieldName = this.getCurie((Resource)p);
            JsonNode fieldValue = node.get(fieldName);
            if (fieldValue == null) {
                this.addField(node, fieldName, object);
                continue;
            }
            if (fieldValue.isArray()) {
                this.addElement((ArrayNode)fieldValue, object);
                continue;
            }
            ArrayNode array = this.factory.arrayNode();
            node.remove(fieldName);
            node.put(fieldName, (JsonNode)array);
            array.add(fieldValue);
            this.addElement(array, object);
        }
    }

    private void addElement(ArrayNode array, RDFNode value) {
        if (value.isLiteral()) {
            JsonNode jsonValue = this.toJsonNode(value.asLiteral());
            array.add(jsonValue);
        } else if (value.isResource()) {
            Resource resource = value.asResource();
            String id = this.getIdentifier(resource);
            array.add(id);
            this.add(resource);
        } else {
            throw new IllegalArgumentException("The elements in an array must be a literal or a resource");
        }
    }

    private void addField(ObjectNode node, String fieldName, RDFNode object) {
        if (object.isLiteral()) {
            this.addLiteral(node, fieldName, object.asLiteral());
        } else if (object.isResource()) {
            this.addResource(node, fieldName, object.asResource());
        }
    }

    private void addResource(ObjectNode node, String fieldName, Resource resource) {
        if (resource.canAs(RDFList.class)) {
            this.addList(node, fieldName, (RDFList)resource.as(RDFList.class));
        } else {
            node.put(fieldName, this.getIdentifier(resource));
            this.add(resource);
        }
    }

    private void addList(ObjectNode node, String fieldName, RDFList list) {
        ArrayNode array = this.factory.arrayNode();
        node.put(fieldName, (JsonNode)array);
        List valueList = list.asJavaList();
        for (RDFNode value : valueList) {
            this.addElement(array, value);
        }
    }

    private JsonNode toJsonNode(Literal literal) {
        Object node = null;
        Object value = literal.getValue();
        node = value instanceof Boolean ? this.factory.booleanNode(literal.getBoolean()) : (value instanceof Byte ? this.factory.numberNode(literal.getByte()) : (value instanceof Double ? this.factory.numberNode(literal.getDouble()) : (value instanceof Float ? this.factory.numberNode(literal.getFloat()) : (value instanceof Integer ? this.factory.numberNode(literal.getInt()) : (value instanceof Long ? this.factory.numberNode(literal.getLong()) : (value instanceof Short ? this.factory.numberNode(literal.getShort()) : this.factory.textNode(value.toString())))))));
        return node;
    }

    private void addLiteral(ObjectNode node, String fieldName, Literal literal) {
        JsonNode value = this.toJsonNode(literal);
        node.put(fieldName, value);
    }

    private void addType(ObjectNode node, Resource resource) {
        List list = resource.listProperties(RDF.type).toList();
        if (list.size() == 1) {
            String value = this.getCurie(((Statement)list.get(0)).getResource());
            node.put("@type", value);
        } else if (list.size() > 1) {
            ArrayNode array = this.factory.arrayNode();
            node.put("@type", (JsonNode)array);
            for (Statement s : list) {
                Resource type = s.getResource();
                String curie = this.getCurie(type);
                array.add(curie);
            }
        }
    }

    private String getCurie(Resource resource) {
        String namespace = resource.getNameSpace();
        OntologyInfo info = this.getOntologyInfo(namespace);
        if (info != null) {
            return info.getPrefix() + ":" + resource.getLocalName();
        }
        return resource.getURI();
    }

    private OntologyInfo getOntologyInfo(String namespace) {
        OntologyInfo info = this.uri2OntologyInfo.get(namespace);
        if (info == null && (info = this.typeManager.getOntologyByNamespaceUri(namespace)) != null) {
            this.uri2OntologyInfo.put(namespace, info);
        }
        return info;
    }

    static class MyPrettyPrinter
    implements PrettyPrinter {
        private int indent = 0;
        private int tabSize = 2;
        private List<Container> stack = new ArrayList<Container>();

        MyPrettyPrinter() {
        }

        private void pushIndent(Container container) {
            this.indent += this.tabSize;
            this.stack.add(container);
        }

        private void popIndent() {
            this.indent -= this.tabSize;
            this.stack.remove(this.stack.size() - 1);
        }

        private Container getContainer() {
            return this.stack.size() > 1 ? this.stack.get(this.stack.size() - 2) : Container.OBJECT;
        }

        private void indent(JsonGenerator g) throws IOException {
            for (int i = 0; i < this.indent; ++i) {
                g.writeRaw(' ');
            }
        }

        public void writeRootValueSeparator(JsonGenerator jg) throws IOException, JsonGenerationException {
            jg.writeRaw('\n');
        }

        public void writeStartObject(JsonGenerator jg) throws IOException, JsonGenerationException {
            jg.writeRaw("{");
            this.pushIndent(Container.OBJECT);
        }

        public void writeEndObject(JsonGenerator jg, int nrOfEntries) throws IOException, JsonGenerationException {
            jg.writeRaw("\n");
            this.popIndent();
            this.indent(jg);
            jg.writeRaw("}");
        }

        public void writeObjectEntrySeparator(JsonGenerator jg) throws IOException, JsonGenerationException {
            jg.writeRaw(",\n");
            this.indent(jg);
        }

        public void writeObjectFieldValueSeparator(JsonGenerator jg) throws IOException, JsonGenerationException {
            jg.writeRaw(" : ");
        }

        public void writeStartArray(JsonGenerator jg) throws IOException, JsonGenerationException {
            jg.writeRaw("[");
            this.pushIndent(Container.ARRAY);
        }

        public void writeEndArray(JsonGenerator jg, int nrOfValues) throws IOException, JsonGenerationException {
            jg.writeRaw('\n');
            this.popIndent();
            this.indent(jg);
            jg.writeRaw("]");
        }

        public void writeArrayValueSeparator(JsonGenerator jg) throws IOException, JsonGenerationException {
            jg.writeRaw(",\n");
            this.indent(jg);
        }

        public void beforeArrayValues(JsonGenerator jg) throws IOException, JsonGenerationException {
            jg.writeRaw(" \n");
            this.indent(jg);
        }

        public void beforeObjectEntries(JsonGenerator jg) throws IOException, JsonGenerationException {
            switch (this.getContainer()) {
                case OBJECT: {
                    jg.writeRaw('\n');
                    this.indent(jg);
                    break;
                }
                case ARRAY: {
                    jg.writeRaw(' ');
                }
            }
        }

        private static enum Container {
            OBJECT,
            ARRAY;

        }
    }
}

