/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.context.renderer;

import com.hp.hpl.jena.vocabulary.OWL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.semantictools.context.renderer.FieldNotFoundException;
import org.semantictools.context.renderer.NodeUtil;
import org.semantictools.context.renderer.TermNotFoundException;
import org.semantictools.context.renderer.model.BranchStyle;
import org.semantictools.context.renderer.model.ContextProperties;
import org.semantictools.context.renderer.model.FrameConstraints;
import org.semantictools.context.renderer.model.JsonContext;
import org.semantictools.context.renderer.model.ObjectPresentation;
import org.semantictools.context.renderer.model.TermInfo;
import org.semantictools.context.renderer.model.TreeNode;
import org.semantictools.frame.api.TypeManager;
import org.semantictools.frame.model.Datatype;
import org.semantictools.frame.model.Field;
import org.semantictools.frame.model.Frame;
import org.semantictools.frame.model.RdfType;
import org.semantictools.frame.model.RestCategory;

public class TreeGenerator {
    private static final String XMLSCHEMA_URI = "http://www.w3.org/2001/XMLSchema#";
    private JsonContext context;
    private ContextProperties contextProperties;
    private int maxDepth;
    private Set<String> memory;
    private TypeManager typeManager;

    public TreeGenerator(TypeManager typeManager, JsonContext context, ContextProperties properties) {
        this.typeManager = typeManager;
        this.context = context;
        this.contextProperties = properties;
    }

    public TreeNode generateRoot(Frame frame, String propertyName, int depth) {
        if (propertyName == null) {
            return this.generateRoot(frame, depth);
        }
        TermInfo term = this.context.getTermInfoByShortName(propertyName);
        if (term == null) {
            throw new TermNotFoundException(propertyName);
        }
        Field field = this.getField(frame, propertyName);
        if (field == null) {
            throw new FieldNotFoundException(frame.getLocalName(), propertyName);
        }
        RdfType type = field.getRdfType();
        if ((type.canAsDatatype() || type.canAsEnumeration()) && field.getMaxCardinality() == 1) {
            throw new RuntimeException("Cannot define a JSON-LD representation where the top node is a literal or an enumeration as required by " + frame.getLocalName() + "." + propertyName);
        }
        if (type.canAsFrame() && field.getMaxCardinality() == 1) {
            return this.generateRoot(type.asFrame(), depth);
        }
        TreeNode root = new TreeNode();
        root.setTypeName("");
        this.addContextNode(root);
        TreeNode graph = new TreeNode();
        root.add(graph);
        graph.setLocalName("@graph");
        graph.setMaxCardinality(-1);
        this.setType(graph, field);
        if (type.canAsFrame()) {
            this.memory = new HashSet<String>();
            this.addProperties(graph, type.asFrame(), depth);
            this.memory = null;
        }
        return root;
    }

    private Field getField(Frame frame, String propertyName) {
        List<Field> list = frame.listAllFields();
        for (Field field : list) {
            if (!field.getLocalName().equals(propertyName)) continue;
            return field;
        }
        return null;
    }

    public TreeNode generateRoot(Frame frame, int depth) {
        this.memory = new HashSet<String>();
        this.maxDepth = depth;
        TreeNode root = null;
        if (frame.getSubtypeList().isEmpty() || depth == 1) {
            root = this.createBasicFrameNode(frame);
            this.addContextNode(root);
            this.addTypeNode(root, frame, 1);
            this.addProperties(root, frame, 0);
        } else {
            root = this.generateRootSubtypes(frame, depth);
        }
        this.memory = null;
        return root;
    }

    private TreeNode generateRootSubtypes(Frame frame, int depth) {
        TreeNode root = new TreeNode();
        root.setKind(TreeNode.Kind.FRAME);
        root.setDescription("");
        root.setTypeName("");
        root.setLocalName("");
        this.addSubtypes(root, frame, true, depth);
        return root;
    }

    public TreeNode generateGraph(List<Frame> frameList, int maxDepth) {
        this.memory = new HashSet<String>();
        this.maxDepth = maxDepth;
        TreeNode root = new TreeNode();
        root.setDescription("");
        root.setKind(TreeNode.Kind.FRAME);
        root.setLocalName("");
        root.setTypeName("");
        this.addContextNode(root);
        TreeNode graph = new TreeNode();
        root.add(graph);
        graph.setMaxCardinality(-1);
        graph.setKind(TreeNode.Kind.PROPERTY);
        graph.setLocalName("@graph");
        if (frameList.size() == 1) {
            Frame frame = frameList.get(0);
            graph.setTypeName(frame.getLocalName());
            this.addProperties(graph, frame, 0);
        } else {
            graph.setTypeName("");
            graph.setBranchStyle(BranchStyle.OBLIQUE);
            for (Frame frame : frameList) {
                TreeNode node = this.createBasicFrameNode(frame);
                graph.add(node);
                this.addTypeNode(node, frame, 1);
                this.addProperties(node, frame, 0);
            }
        }
        this.memory = null;
        return root;
    }

    public TreeNode generateNode(Frame frame, int depth) {
        this.memory = new HashSet<String>();
        this.maxDepth = depth;
        TreeNode root = this.createBasicFrameNode(frame);
        if (frame.hasFields()) {
            this.addProperties(root, frame, 0);
        }
        this.memory = null;
        return root;
    }

    private void addProperties(TreeNode parent, Frame frame, int depth) {
        if (this.maxDepth >= 0 && depth >= this.maxDepth) {
            return;
        }
        String frameURI = frame.getUri();
        if (this.memory.contains(frameURI)) {
            return;
        }
        this.memory.add(frameURI);
        ++depth;
        this.addIdProperty(parent, frame);
        List<Field> list = frame.listAllFields();
        for (Field field : list) {
            this.addField(parent, frame, field, depth);
        }
    }

    private void addIdProperty(TreeNode parent, Frame frame) {
        if (frame.getCategory() == RestCategory.ADDRESSABLE) {
            String parentType = parent.getTypeName();
            TreeNode node = new TreeNode();
            node.setKind(TreeNode.Kind.PROPERTY);
            node.setDescription("The URI that identifies this <code>" + parentType + "</code> instance.");
            node.setLocalName("@id");
            node.setMaxCardinality(1);
            if (this.contextProperties.requiresId(frame.getUri())) {
                node.setMinCardinality(1);
            } else {
                node.setMinCardinality(0);
            }
            node.setTypeName("xs:anyURI");
            parent.add(node);
        }
    }

    public TreeNode generateNode(Field field) {
        this.memory = new HashSet<String>();
        TreeNode result = this.doGenerateNode(field);
        this.memory = null;
        return result;
    }

    private TreeNode doGenerateNode(Field field) {
        String uri = field.getURI();
        TermInfo term = this.context.getTermInfoByURI(uri);
        if (term == null) {
            return null;
        }
        String frameURI = field.getDeclaringFrame().getUri();
        FrameConstraints constraints = this.contextProperties.getFrameConstraints(frameURI);
        if (constraints != null && !constraints.isIncludedProperty(field.getURI())) {
            return null;
        }
        Frame frame = this.getFieldTypeAsFrame(field);
        TreeNode node = new TreeNode();
        TreeNode setContainer = null;
        int max = field.getMaxCardinality();
        if (max > 0) {
            node.setMaxCardinality(max);
        }
        boolean isList = field.getRdfType().canAsListType();
        if (max < 0 && !isList && this.contextProperties.isSetProperty(field.getURI())) {
            node.setLocalName("@set");
            TreeNode id = new TreeNode();
            id.setLocalName("@id");
            id.setMaxCardinality(1);
            id.setMinCardinality(1);
            id.setTypeName("xs:anyURI");
            setContainer = new TreeNode();
            setContainer.add(id);
            setContainer.add(node);
            setContainer.setLocalName(this.context.rewrite(uri));
            setContainer.setMinCardinality(field.getMinCardinality());
            setContainer.setMaxCardinality(1);
            setContainer.setTypeName("");
            setContainer.setKind(TreeNode.Kind.PROPERTY);
        } else {
            String localName = this.context.rewrite(uri);
            if (this.contextProperties.usePrefix(uri)) {
                String namespace = TypeManager.getNamespace(uri);
                String prefix = this.context.rewrite(namespace);
                node.setLocalName(prefix + ":" + localName);
            } else {
                node.setLocalName(localName);
            }
        }
        int maxCardinality = field.getMaxCardinality();
        if (this.contextProperties.getOptionalProperties().contains(uri)) {
            maxCardinality = 0;
        }
        node.setKind(TreeNode.Kind.PROPERTY);
        node.setMinCardinality(field.getMinCardinality());
        node.setMaxCardinality(maxCardinality);
        this.setDescription(node, field);
        this.setType(node, field);
        if (isList) {
            node.setMaxCardinality(-1);
            node.setSequential(true);
        }
        if (this.contextProperties.isMixed(uri)) {
            node.setObjectPresentation(ObjectPresentation.MIXED_VALUE);
        } else if (term.hasObjectValue() && "@id".equals(term.getObjectValue().getType()) && frame != null && frame.getCategory() != RestCategory.ENUMERABLE) {
            node.setObjectPresentation(ObjectPresentation.URI_REFERENCE);
            node.setTypeHref(null);
        } else if (frame != null && frame.getCategory() == RestCategory.ENUMERABLE) {
            node.setObjectPresentation(ObjectPresentation.SIMPLE_NAME);
        }
        this.checkExpandedValue(node, field, term);
        return setContainer == null ? node : setContainer;
    }

    private void checkExpandedValue(TreeNode node, Field field, TermInfo term) {
        if (term.hasObjectValue()) {
            return;
        }
        String typeURI = node.getTypeURI();
        TypeManager manager = field.getDeclaringFrame().getTypeManager();
        if (manager.getDatatypeByUri(typeURI) == null) {
            return;
        }
        node.setObjectPresentation(ObjectPresentation.EXPANDED_VALUE);
    }

    private void setDescription(TreeNode node, Field field) {
        String comment = field.getComment();
        if ((comment == null || comment.length() == 0) && OWL.sameAs.getURI().equals(field.getURI())) {
            Frame parent = field.getDeclaringFrame();
            TermInfo term = this.context.getTermInfoByURI(parent.getUri());
            String typeName = term == null ? parent.getLocalName() : term.getTermName();
            String text = "Specifies an alternative representation of this <code>{0}</code>.";
            comment = text.replace("{0}", typeName);
        }
        node.setDescription(comment);
    }

    private Frame getFieldTypeAsFrame(Field field) {
        RdfType rdfType = field.getRdfType();
        if (rdfType.canAsListType()) {
            rdfType = rdfType.asListType().getElementType();
        }
        Frame frame = rdfType.canAsFrame() ? rdfType.asFrame() : null;
        return frame;
    }

    private void addField(TreeNode parent, Frame parentFrame, Field field, int depth) {
        Frame frame;
        TreeNode node = this.doGenerateNode(field);
        if (node == null) {
            return;
        }
        parent.add(node);
        if (this.contextProperties.isSetProperty(field.getURI())) {
            node = node.getChildren().get(1);
        }
        if ((frame = this.getFieldTypeAsFrame(field)) == null || this.isCyclic(node)) {
            return;
        }
        if (node.getObjectPresentation() == ObjectPresentation.NONE) {
            List<Frame> subtypeList = frame.getSubtypeList();
            boolean excludeSubtypes = this.excludeSubtypes(parentFrame, field);
            if (subtypeList.isEmpty() || excludeSubtypes) {
                this.addProperties(node, frame, depth);
            } else {
                node.setBranchStyle(BranchStyle.OBLIQUE);
                this.addSubtypes(node, frame, false, depth);
            }
        }
    }

    private boolean excludeSubtypes(Frame frame, Field field) {
        FrameConstraints constraints = this.contextProperties.getFrameConstraints(frame.getUri());
        return constraints != null && constraints.isExcludesSubtypes(field.getURI());
    }

    private void addSubtypes(TreeNode node, Frame frame, boolean hasContext, int depth) {
        List<Frame> list = frame.listAllSubtypes();
        this.filterSubtypes(list);
        Collections.sort(list);
        if (frame.isAbstract() && list.size() == 1) {
            Frame subtype = list.get(0);
            TermInfo info = this.context.getTermInfoByURI(subtype.getUri());
            if (info == null) {
                throw new TermNotFoundException(subtype.getUri());
            }
            String typeName = info.getTermName();
            String href = "#" + typeName;
            node.setTypeHref(href);
            node.setTypeName(typeName);
            node.setTypeURI(subtype.getUri());
            node.setBranchStyle(BranchStyle.RECTILINEAR);
            this.addConcreteTypeNode(node, subtype, hasContext, depth);
            this.addProperties(node, subtype, depth);
            return;
        }
        if (this.maxDepth >= 0 && depth >= this.maxDepth) {
            return;
        }
        if (!frame.isAbstract()) {
            list.add(0, frame);
        }
        node.setBranchStyle(BranchStyle.OBLIQUE);
        for (Frame sub : list) {
            if (this.contextProperties.getExcludedTypes().contains(sub.getUri())) continue;
            TreeNode child = this.createBasicFrameNode(sub);
            node.add(child);
            TermInfo info = this.context.getTermInfoByURI(sub.getUri());
            if (info == null) {
                throw new TermNotFoundException(this.contextProperties.getMediaType(), sub.getUri());
            }
            String typeName = info.getTermName();
            String href = "#" + typeName;
            child.setTypeHref(href);
            this.addConcreteTypeNode(child, sub, hasContext, depth + 1);
            this.addProperties(child, sub, depth + 1);
        }
    }

    private void addConcreteTypeNode(TreeNode node, Frame subtype, boolean hasContext, int depth) {
        if (this.maxDepth >= 0 && depth >= this.maxDepth) {
            return;
        }
        if (hasContext) {
            this.addContextNode(node);
        }
        TreeNode typeNode = new TreeNode();
        node.add(typeNode);
        typeNode.setLocalName("@type");
        typeNode.setTypeName("owl:Class");
        typeNode.setKind(TreeNode.Kind.PROPERTY);
        typeNode.setDescription("A simple name that identifies the type of this resource.  The value should be <code>" + subtype.getLocalName() + "</code>.");
        typeNode.setMaxCardinality(1);
        typeNode.setMinCardinality(1);
        typeNode.setObjectPresentation(ObjectPresentation.SIMPLE_NAME);
    }

    private void filterSubtypes(List<Frame> list) {
        Iterator<Frame> sequence = list.iterator();
        while (sequence.hasNext()) {
            Frame frame = sequence.next();
            if (frame.isAbstract()) {
                sequence.remove();
            }
            if (this.context.getTermInfoByURI(frame.getUri()) != null) continue;
            sequence.remove();
        }
    }

    private boolean isCyclic(TreeNode node) {
        String typeName = node.getTypeName();
        if (typeName.length() == 0) {
            return false;
        }
        while ((node = node.getParent()) != null) {
            if (!typeName.equals(node.getTypeName())) continue;
            return true;
        }
        return false;
    }

    private void setType(TreeNode node, Field field) {
        RdfType type = field.getRdfType();
        String propertyURI = field.getURI();
        if (!this.contextProperties.isIdRef(propertyURI) && this.shortCircuitType(node, field)) {
            return;
        }
        boolean isList = type.canAsListType();
        String typeURI = isList ? type.asListType().getElementType().getUri() : field.getType().getURI();
        TermInfo term = this.context.getTermInfoByURI(typeURI);
        String typeName = null;
        String typeHref = null;
        if (typeURI.startsWith(XMLSCHEMA_URI)) {
            typeName = "xs:" + field.getType().getLocalName();
        } else if (term == null) {
            TreeNode tmp = NodeUtil.createDefaultTypeNode(this.typeManager, this.context, typeURI);
            typeName = tmp.getTypeName();
            typeHref = tmp.getTypeHref();
        } else {
            typeName = term.getTermName();
            if (!field.getRdfType().canAsDatatype()) {
                typeHref = "#" + typeName;
            }
        }
        node.setTypeName(typeName);
        node.setTypeURI(typeURI);
        node.setTypeHref(typeHref);
        if (isList) {
            node.setSequential(true);
        }
    }

    private boolean shortCircuitType(TreeNode node, Field field) {
        RdfType rdfType = field.getRdfType();
        if (!rdfType.canAsFrame()) {
            return false;
        }
        Frame frame = rdfType.asFrame();
        if (!frame.isAbstract()) {
            return false;
        }
        List<Frame> subtypeList = frame.listAllSubtypes();
        List<Datatype> datatypeList = frame.getSubdatatypeList();
        if (subtypeList.size() + datatypeList.size() != 1) {
            return false;
        }
        RdfType type = subtypeList.isEmpty() ? (RdfType)datatypeList.get(0) : (RdfType)subtypeList.get(0);
        String typeURI = type.getUri();
        TermInfo term = this.context.getTermInfoByURI(typeURI);
        String typeName = null;
        String typeHref = null;
        if (typeURI.startsWith(XMLSCHEMA_URI)) {
            typeName = "xs:" + type.getLocalName();
        } else {
            if (term == null) {
                throw new TermNotFoundException(typeURI);
            }
            typeName = term.getTermName();
            typeHref = "#" + typeName;
        }
        node.setTypeName(typeName);
        node.setTypeURI(typeURI);
        node.setTypeHref(typeHref);
        return true;
    }

    private void addTypeNode(TreeNode parent, Frame frame, int minCardinality) {
        if (frame.isAbstract()) {
            minCardinality = 1;
        }
        Set<String> set = this.getTypesForFrame(frame);
        if (minCardinality == 0 && set.isEmpty()) {
            return;
        }
        TreeNode child = new TreeNode();
        child.setLocalName("@type");
        child.setTypeName("owl:Class");
        child.setTypeURI(OWL.Class.getURI());
        child.setObjectPresentation(ObjectPresentation.SIMPLE_NAME);
        child.setMinCardinality(minCardinality);
        child.setMaxCardinality(1);
        StringBuilder text = new StringBuilder("A simple name identifying the object's type.  ");
        if (!frame.isAbstract()) {
            set.add(parent.getTypeName());
        }
        text.append("The standard context " + this.contextProperties.getContextRef() + " defines the following simple names that are applicable: <UL>\n");
        for (String name : set) {
            text.append("  <LI><CODE>");
            text.append(name);
            text.append("</CODE></LI>");
        }
        text.append("</UL>");
        TermInfo info = this.context.getTermInfoByURI(frame.getUri());
        if (info == null) {
            throw new TermNotFoundException(this.context.getMediaType(), frame.getUri());
        }
        String termName = info.getTermName();
        text.append("<P>Implementations may use a custom JSON-LD context which defines simple names for additional types that are subtypes of <code>" + termName + ".</code></P>");
        if (minCardinality == 0) {
            text.append("<P>The default value of the @type property is <code>" + termName + "</code>. " + "The @type property may be omitted if the object's type is <code>" + termName + "</code>, " + "but this property is required otherwise.");
        }
        child.setDescription(text.toString());
        parent.add(child);
    }

    private Set<String> getTypesForFrame(Frame frame) {
        HashSet<String> set = new HashSet<String>();
        List<Frame> list = frame.listAllSubtypes();
        for (Frame subtype : list) {
            if (subtype.isAbstract()) continue;
            String uri = subtype.getUri();
            TermInfo term = this.context.getTermInfoByURI(uri);
            if (term == null) {
                throw new TermNotFoundException(uri);
            }
            set.add(term.getTermName());
        }
        return set;
    }

    private void addContextNode(TreeNode parent) {
        TreeNode node = new TreeNode();
        node.setKind(TreeNode.Kind.PROPERTY);
        node.setLocalName("@context");
        node.setTypeName("JSON-LD Context");
        node.setMinCardinality(1);
        node.setMaxCardinality(-1);
        this.addContextDescription(node);
        parent.add(node);
    }

    private void addContextDescription(TreeNode node) {
        if (this.contextProperties == null) {
            node.setDescription("This value specifies one or more JSON-LD contexts, either by reference or by value.");
            return;
        }
        String text = "<p>This value specifies one or more JSON-LD contexts, either by reference or by value.\nWhen multiple contexts are specified, they must be encapsulated within an array.</p>\n<p>For most implementations, the value will be the single URI for the standard context associated with the <code>{0}</code> media type.  In this case, the value will be</p>\n<blockquote><code>\"{1}\"</code></blockquote>";
        String mediaType = this.contextProperties.getMediaType();
        String contextURI = this.contextProperties.getContextURI();
        text = text.replace("{0}", mediaType).replace("{1}", contextURI);
        node.setDescription(text);
    }

    private TreeNode createBasicFrameNode(Frame frame) {
        String localName = this.context.rewrite(frame.getUri());
        TreeNode node = new TreeNode();
        node.setDescription(frame.getComment());
        node.setKind(TreeNode.Kind.FRAME);
        node.setLocalName("");
        node.setTypeName(localName);
        node.setTypeURI(frame.getUri());
        return node;
    }
}

