/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.context.renderer.model;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.semantictools.context.renderer.model.BibliographicReference;
import org.semantictools.context.renderer.model.DocumentMetadata;
import org.semantictools.context.renderer.model.Person;
import org.semantictools.context.renderer.model.ReferenceManager;

public class BaseDocumentMetadata
implements DocumentMetadata {
    private File localFile;
    private String logo;
    private String date;
    private String documentLocation;
    private String footer;
    private String latestVersionURI;
    private String legalNotice;
    private String purpose;
    private String release;
    private String status;
    private String subtitle;
    private String templateName;
    private String title;
    private String version;
    private Boolean historyLink;
    private String css;
    protected List<Person> authorList;
    protected List<Person> cochairList;
    protected List<Person> editorList;
    protected ReferenceManager refManager;
    protected Boolean validateJsonSamples;
    private DocumentMetadata parent;

    public BaseDocumentMetadata() {
    }

    public BaseDocumentMetadata(DocumentMetadata parent) {
        this.parent = parent;
    }

    @Override
    public DocumentMetadata getParent() {
        return this.parent;
    }

    @Override
    public void setParent(DocumentMetadata parent) {
        this.parent = parent;
    }

    @Override
    public String getLogo() {
        return this.logo == null && this.parent != null ? this.parent.getLogo() : this.logo;
    }

    @Override
    public void setLogo(String logo) {
        this.logo = logo;
    }

    @Override
    public String getTitle() {
        return this.title == null && this.parent != null ? this.parent.getTitle() : this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getSubtitle() {
        return this.subtitle == null && this.parent != null ? this.parent.getSubtitle() : this.subtitle;
    }

    @Override
    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    @Override
    public String getVersion() {
        return this.version == null && this.parent != null ? this.parent.getVersion() : this.version;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String getRelease() {
        return this.release == null && this.parent != null ? this.parent.getRelease() : this.release;
    }

    @Override
    public void setRelease(String release) {
        this.release = release;
    }

    @Override
    public String getLatestVersionURI() {
        return this.latestVersionURI == null && this.parent != null ? this.parent.getLatestVersionURI() : this.latestVersionURI;
    }

    @Override
    public void setLatestVersionURI(String value) {
        this.latestVersionURI = value;
    }

    @Override
    public String getStatus() {
        return this.status == null && this.parent != null ? this.parent.getStatus() : this.status;
    }

    @Override
    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public String getDate() {
        return this.date == null && this.parent != null ? this.parent.getDate() : this.date;
    }

    @Override
    public void setDate(String date) {
        this.date = date;
    }

    @Override
    public String getPurpose() {
        return this.purpose == null && this.parent != null ? this.parent.getPurpose() : this.purpose;
    }

    @Override
    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    @Override
    public String getDocumentLocation() {
        return this.documentLocation == null && this.parent != null ? this.parent.getDocumentLocation() : this.documentLocation;
    }

    @Override
    public void setDocumentLocation(String location) {
        this.documentLocation = location;
    }

    @Override
    public String getLegalNotice() {
        return this.legalNotice == null && this.parent != null ? this.parent.getLegalNotice() : this.legalNotice;
    }

    @Override
    public void setLegalNotice(String legalNotice) {
        this.legalNotice = legalNotice;
    }

    @Override
    public String getFooter() {
        return this.footer == null && this.parent != null ? this.parent.getFooter() : this.footer;
    }

    @Override
    public void setFooter(String footer) {
        this.footer = footer;
    }

    @Override
    public void addAuthor(Person person) {
        if (this.authorList == null) {
            this.authorList = new ArrayList<Person>();
        }
        this.authorList.add(person);
    }

    @Override
    public List<Person> getAuthors() {
        return this.authorList == null && this.parent != null ? this.parent.getAuthors() : this.authorList;
    }

    @Override
    public void addEditor(Person person) {
        if (this.editorList == null) {
            this.editorList = new ArrayList<Person>();
        }
        this.editorList.add(person);
    }

    @Override
    public List<Person> getEditors() {
        return this.editorList == null && this.parent != null ? this.parent.getEditors() : this.editorList;
    }

    @Override
    public void addCoChair(Person person) {
        if (this.cochairList == null) {
            this.cochairList = new ArrayList<Person>();
        }
        this.cochairList.add(person);
    }

    @Override
    public List<Person> getCoChairs() {
        return this.cochairList == null && this.parent != null ? this.parent.getCoChairs() : this.cochairList;
    }

    @Override
    public ReferenceManager getReferenceManager() {
        return this.refManager == null && this.parent != null ? this.parent.getReferenceManager() : this.refManager;
    }

    @Override
    public void setReferenceManager(ReferenceManager refManager) {
        this.refManager = refManager;
    }

    @Override
    public Boolean hasHistoryLink() {
        Boolean value = this.historyLink == null && this.parent != null ? this.parent.hasHistoryLink() : this.historyLink;
        return value == null ? Boolean.FALSE : value;
    }

    @Override
    public void setHistoryLink(Boolean truth) {
        this.historyLink = truth;
    }

    @Override
    public String getTemplateName() {
        return this.templateName == null && this.parent != null ? this.parent.getTemplateName() : this.templateName;
    }

    @Override
    public void setTemplateName(String name) {
        this.templateName = name;
    }

    @Override
    public String getCss() {
        return this.css == null && this.parent != null ? this.parent.getCss() : this.css;
    }

    @Override
    public void setCss(String css) {
        this.css = css;
    }

    @Override
    public void putReference(String label, String referenceText) {
        ReferenceManager manager = this.getReferenceManager();
        if (manager == null) {
            return;
        }
        BibliographicReference ref = BibliographicReference.parse(referenceText);
        ref.setLabel(label);
        manager.add(ref);
    }

    @Override
    public File getLocalFile() {
        return this.localFile;
    }

    @Override
    public void setLocalFile(File localFile) {
        this.localFile = localFile;
    }

    @Override
    public boolean getValidateJsonSamples() {
        if (this.validateJsonSamples == null && this.parent != null) {
            return this.parent.getValidateJsonSamples();
        }
        return this.validateJsonSamples == null ? true : this.validateJsonSamples;
    }

    @Override
    public void setValidateJsonSamples(boolean truthValue) {
        this.validateJsonSamples = truthValue;
    }
}

