/*
 * Decompiled with CFR 0.152.
 */
package org.semantictools.context.renderer.model;

import java.io.File;
import java.util.List;
import org.semantictools.context.renderer.model.Person;

public class BibliographicReference {
    private String label;
    private String author;
    private String title;
    private String edition;
    private String date;
    private String uri;
    private String text;
    private File localFile;

    public static BibliographicReference parse(String text) {
        BibliographicReference result = new BibliographicReference();
        String[] array = text.split("\\|");
        if (array.length == 5) {
            result.setAuthor(array[0].trim());
            result.setTitle(array[1].trim());
            result.setEdition(array[2].trim());
            result.setDate(array[3].trim());
            result.setUri(array[4].trim());
        } else {
            result.setText(text.replace("|", "."));
        }
        return result;
    }

    public String htmlLabel() {
        return this.label.replace(" ", "&nbsp;");
    }

    public String textLabel() {
        return this.label.replace("&nbsp;", " ");
    }

    private String toId(String tag) {
        tag = tag.replace("&nbsp;", "_");
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < tag.length(); ++i) {
            char c = tag.charAt(i);
            if (Character.isJavaIdentifierPart(c)) {
                builder.append(c);
                continue;
            }
            builder.append('_');
        }
        return builder.toString();
    }

    public String getId() {
        return this.toId(this.label);
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getEdition() {
        return this.edition;
    }

    public void setEdition(String edition) {
        this.edition = edition;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String htmlText() {
        if (this.text != null) {
            return this.text.replace("|", ". ");
        }
        StringBuilder builder = new StringBuilder();
        String dot = "";
        if (this.author != null) {
            builder.append(this.author);
            dot = ". ";
        }
        if (this.title != null) {
            builder.append(dot);
            if (this.uri != null) {
                builder.append("<a href=\"");
                builder.append(this.uri);
                builder.append("\"><em>");
            }
            builder.append(this.title);
            if (this.uri != null) {
                builder.append("</em></a>");
            }
            dot = ". ";
        }
        if (this.edition != null) {
            builder.append(dot);
            builder.append(this.edition);
            dot = ". ";
        }
        if (this.date != null) {
            builder.append(dot);
            builder.append(this.date);
            dot = ". ";
        }
        builder.append(".");
        String result = builder.toString();
        result = result.replace("<br>", " ");
        return result;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String toString() {
        if (this.text != null) {
            return this.text;
        }
        StringBuilder builder = new StringBuilder();
        String dot = "";
        if (this.author != null) {
            builder.append(this.author);
            dot = ". ";
        }
        if (this.title != null) {
            builder.append(dot);
            builder.append(this.title);
            dot = ". ";
        }
        if (this.edition != null) {
            builder.append(dot);
            builder.append(this.edition);
            dot = ". ";
        }
        if (this.date != null) {
            builder.append(dot);
            builder.append(this.date);
            dot = ". ";
        }
        if (this.uri != null) {
            builder.append(dot);
            builder.append(this.uri);
        }
        return builder.toString();
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setAuthor(List<Person> list) {
        StringBuilder buffer = new StringBuilder();
        String comma = "";
        for (Person p : list) {
            buffer.append(comma);
            buffer.append(p.getPersonName());
            comma = ", ";
        }
        this.author = buffer.toString();
    }

    public File getLocalFile() {
        return this.localFile;
    }

    public void setLocalFile(File localFile) {
        this.localFile = localFile;
    }
}

